/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.FlamingoCommand;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuPrimaryCommand;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel2;

public class JRibbonApplicationMenuPopupPanelSecondary
extends JCommandButtonPanel {
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_2 = new CommandButtonDisplayState("Ribbon application menu tile level 2", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel2();
        }
    };

    public JRibbonApplicationMenuPopupPanelSecondary(RibbonApplicationMenuPrimaryCommand primaryMenuEntry) {
        super(MENU_TILE_LEVEL_2);
        this.setMaxButtonColumns(1);
        int groupCount = primaryMenuEntry.getSecondaryGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            String groupDesc = primaryMenuEntry.getSecondaryGroupTitleAt(i);
            this.addButtonGroup(groupDesc);
            for (FlamingoCommand menuCommand : primaryMenuEntry.getSecondaryGroupCommands(i)) {
                if (menuCommand.isToggle()) {
                    throw new IllegalStateException("Secondary menu commands cannot be toggle");
                }
                JCommandMenuButton commandButton = (JCommandMenuButton)menuCommand.buildMenuButton();
                commandButton.setDisplayState(MENU_TILE_LEVEL_2);
                commandButton.setHorizontalAlignment(10);
                commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                this.addButtonToLastGroup(commandButton);
            }
        }
    }
}

