/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;

public class JRibbonApplicationMenuButton
extends JCommandButton {
    private static final CommandButtonDisplayState APP_MENU_BUTTON_STATE = new CommandButtonDisplayState("Ribbon Application Menu Button", 16){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManager(){

                @Override
                public int getPreferredIconSize(AbstractCommandButton commandButton) {
                    return 0;
                }

                @Override
                public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
                    CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
                    result.actionClickArea = new Rectangle(0, 0, 0, 0);
                    result.popupActionRect = new Rectangle(0, 0, 0, 0);
                    result.isTextInActionArea = false;
                    FontMetrics fm = g.getFontMetrics();
                    int labelHeight = fm.getAscent() + fm.getDescent();
                    int availableWidth = commandButton.getWidth();
                    int textWidth = (int)fm.getStringBounds(commandButton.getText(), g).getWidth();
                    CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                    lineLayoutInfo.text = commandButton.getText();
                    lineLayoutInfo.textRect = new Rectangle();
                    result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                    result.textLayoutInfoList.add(lineLayoutInfo);
                    lineLayoutInfo.textRect.x = (availableWidth - textWidth) / 2;
                    lineLayoutInfo.textRect.y = (commandButton.getHeight() - labelHeight) / 2;
                    lineLayoutInfo.textRect.width = textWidth;
                    lineLayoutInfo.textRect.height = labelHeight;
                    result.popupClickArea = new Rectangle(0, 0, availableWidth, commandButton.getHeight());
                    return result;
                }

                @Override
                public Dimension getPreferredSize(AbstractCommandButton commandButton) {
                    return new Dimension(40, 20);
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                }

                @Override
                public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
                    return new Point(commandButton.getWidth() / 2, commandButton.getHeight());
                }
            };
        }
    };

    public JRibbonApplicationMenuButton(JRibbon ribbon) {
        super("", null);
        this.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        this.setDisplayState(APP_MENU_BUTTON_STATE);
        this.setHorizontalAlignment(0);
        this.setPopupCallback(commandButton -> {
            RibbonApplicationMenu ribbonMenu = ribbon.getApplicationMenu();
            JRibbonApplicationMenuPopupPanel menuPopupPanel = new JRibbonApplicationMenuPopupPanel(ribbonMenu);
            menuPopupPanel.applyComponentOrientation(this.getComponentOrientation());
            menuPopupPanel.setCustomizer(() -> {
                int ph;
                boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
                int pw = menuPopupPanel.getPreferredSize().width;
                int x = ltr ? ribbon.getLocationOnScreen().x : ribbon.getLocationOnScreen().x + ribbon.getWidth() - pw;
                int y = commandButton.getLocationOnScreen().y + commandButton.getSize().height + 2;
                Rectangle scrBounds = commandButton.getGraphicsConfiguration().getBounds();
                if (x + pw > scrBounds.x + scrBounds.width) {
                    x = scrBounds.x + scrBounds.width - pw;
                }
                if (y + (ph = menuPopupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                    y = scrBounds.y + scrBounds.height - ph;
                }
                return new Rectangle(x, y, menuPopupPanel.getPreferredSize().width, menuPopupPanel.getPreferredSize().height);
            });
            return menuPopupPanel;
        });
    }
}

