/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.icon.ResizableIcon;

public class CommandButtonLayoutManagerMenuTileLevel2
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize(AbstractCommandButton commandButton) {
        return FlamingoUtilities.getScaledSize(32, commandButton.getFont().getSize(), 2.0, 4);
    }

    @Override
    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        JSeparator jsep = new JSeparator(1);
        int titleWidth = fm.stringWidth(commandButton.getText());
        int layoutHGap = 2 * FlamingoUtilities.getHLayoutGap(commandButton);
        int layoutVGap = 2 * FlamingoUtilities.getVLayoutGap(commandButton);
        int widthMed = this.getPreferredIconSize(commandButton) + 2 * layoutHGap + jsep.getPreferredSize().width + titleWidth + (FlamingoUtilities.hasPopupAction(commandButton) ? 1 + fm.getHeight() / 2 + 4 * layoutHGap + jsep.getPreferredSize().width : 0);
        int fontHeight = fm.getAscent() + fm.getDescent();
        int textHeight = fontHeight + layoutVGap;
        String extraText = commandButton.getExtraText();
        if (extraText != null && extraText.length() > 0) {
            textHeight += 2 * fontHeight;
        }
        return new Dimension(bx + widthMed, by + Math.max(this.getPreferredIconSize(commandButton), textHeight));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
        Insets ins = commandButton.getInsets();
        int height = commandButton.getHeight();
        ResizableIcon buttonIcon = commandButton.getIcon();
        return new Point(ins.left + buttonIcon.getIconWidth(), (height + buttonIcon.getIconHeight()) / 2);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
        JCommandButton.CommandButtonKind buttonKind;
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind commandButtonKind = buttonKind = commandButton instanceof JCommandButton ? ((JCommandButton)commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
            result.isTextInActionArea = false;
        }
        JSeparator jsep = new JSeparator(1);
        int layoutHGap = 2 * FlamingoUtilities.getHLayoutGap(commandButton);
        int layoutVGap = 2 * FlamingoUtilities.getVLayoutGap(commandButton);
        ResizableIcon buttonIcon = commandButton.getIcon();
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        if (ltr) {
            int x;
            result.iconRect.x = x = ins.left;
            result.iconRect.y = ins.top + layoutVGap;
            result.iconRect.width = buttonIcon.getIconWidth();
            result.iconRect.height = buttonIcon.getIconHeight();
            x += buttonIcon.getIconWidth();
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = x + layoutHGap;
                result.actionClickArea.height = height;
                result.popupClickArea.x = x + layoutHGap;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = width - x - layoutHGap;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = x + layoutHGap;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = false;
            }
            CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            lineLayoutInfo.text = commandButton.getText();
            lineLayoutInfo.textRect = new Rectangle();
            lineLayoutInfo.textRect.x = x += 2 * layoutHGap + jsep.getPreferredSize().width;
            lineLayoutInfo.textRect.y = ins.top + layoutVGap / 2;
            lineLayoutInfo.textRect.width = fm.stringWidth(commandButton.getText());
            lineLayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(lineLayoutInfo);
            String extraText = commandButton.getExtraText();
            if (extraText == null || extraText.length() == 0) {
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
            } else {
                AttributedString attributedDescription = new AttributedString(commandButton.getExtraText());
                attributedDescription.addAttribute(TextAttribute.FONT, g.getFont());
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), ((Graphics2D)g).getFontRenderContext());
                int maxFirstExtraLineWidth = width - x - ins.right - layoutHGap - labelHeight;
                int breakIndex = lineBreakMeasurer.nextOffset(maxFirstExtraLineWidth);
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo1 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo1.text = commandButton.getExtraText().substring(0, breakIndex);
                extraLineLayoutInfo1.textRect = new Rectangle();
                extraLineLayoutInfo1.textRect.x = x;
                extraLineLayoutInfo1.textRect.y = ins.top + layoutVGap + labelHeight;
                extraLineLayoutInfo1.textRect.width = fm.stringWidth(extraLineLayoutInfo1.text);
                extraLineLayoutInfo1.textRect.height = labelHeight;
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo2 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo2.text = commandButton.getExtraText().substring(breakIndex);
                extraLineLayoutInfo2.textRect = new Rectangle();
                extraLineLayoutInfo2.textRect.x = x;
                extraLineLayoutInfo2.textRect.y = ins.top + layoutVGap + 2 * labelHeight;
                extraLineLayoutInfo2.textRect.width = fm.stringWidth(extraLineLayoutInfo2.text);
                extraLineLayoutInfo2.textRect.height = labelHeight;
                result.extraTextLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo1);
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo2);
            }
            x = (int)((double)x + fm.getStringBounds(commandButton.getText(), g).getWidth());
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.actionClickArea.x = 0;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - ins.right - labelHeight;
                result.actionClickArea.height = height;
                result.popupClickArea.x = width - ins.right - labelHeight;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = labelHeight + ins.right;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = width - ins.right - labelHeight;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = true;
            }
            if (FlamingoUtilities.hasPopupAction(commandButton)) {
                result.popupActionRect.x = width - ins.right - labelHeight * 3 / 4;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
            }
        } else {
            int x = commandButton.getWidth() - ins.right;
            result.iconRect.x = x - buttonIcon.getIconWidth();
            result.iconRect.y = ins.top + layoutVGap;
            result.iconRect.width = buttonIcon.getIconWidth();
            result.iconRect.height = buttonIcon.getIconHeight();
            x -= buttonIcon.getIconWidth();
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP) {
                result.actionClickArea.x = x + layoutHGap;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - x - layoutHGap;
                result.actionClickArea.height = height;
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = x + layoutHGap;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = x + layoutHGap;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = false;
            }
            CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
            lineLayoutInfo.text = commandButton.getText();
            lineLayoutInfo.textRect = new Rectangle();
            lineLayoutInfo.textRect.width = fm.stringWidth(commandButton.getText());
            lineLayoutInfo.textRect.x = (x -= 2 * layoutHGap + jsep.getPreferredSize().width) - lineLayoutInfo.textRect.width;
            lineLayoutInfo.textRect.y = ins.top + layoutVGap / 2;
            lineLayoutInfo.textRect.height = labelHeight;
            result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
            result.textLayoutInfoList.add(lineLayoutInfo);
            String extraText = commandButton.getExtraText();
            if (extraText == null || extraText.length() == 0) {
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
            } else {
                AttributedString attributedDescription = new AttributedString(commandButton.getExtraText());
                attributedDescription.addAttribute(TextAttribute.FONT, g.getFont());
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), ((Graphics2D)g).getFontRenderContext());
                int maxFirstExtraLineWidth = x - ins.left - layoutHGap - labelHeight;
                int breakIndex = lineBreakMeasurer.nextOffset(maxFirstExtraLineWidth);
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo1 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo1.text = commandButton.getExtraText().substring(0, breakIndex);
                extraLineLayoutInfo1.textRect = new Rectangle();
                extraLineLayoutInfo1.textRect.width = fm.stringWidth(extraLineLayoutInfo1.text);
                extraLineLayoutInfo1.textRect.x = x - extraLineLayoutInfo1.textRect.width;
                extraLineLayoutInfo1.textRect.y = ins.top + layoutVGap + labelHeight;
                extraLineLayoutInfo1.textRect.height = labelHeight;
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo2 = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo2.text = commandButton.getExtraText().substring(breakIndex);
                extraLineLayoutInfo2.textRect = new Rectangle();
                extraLineLayoutInfo2.textRect.width = fm.stringWidth(extraLineLayoutInfo2.text);
                extraLineLayoutInfo2.textRect.x = x - extraLineLayoutInfo2.textRect.width;
                extraLineLayoutInfo2.textRect.y = ins.top + layoutVGap + 2 * labelHeight;
                extraLineLayoutInfo2.textRect.height = labelHeight;
                result.extraTextLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo1);
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo2);
            }
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION) {
                result.actionClickArea.x = labelHeight + ins.left;
                result.actionClickArea.y = 0;
                result.actionClickArea.width = width - ins.right - labelHeight;
                result.actionClickArea.height = height;
                result.popupClickArea.x = 0;
                result.popupClickArea.y = 0;
                result.popupClickArea.width = ins.left + labelHeight;
                result.popupClickArea.height = height;
                result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                result.separatorArea = new Rectangle();
                result.separatorArea.x = labelHeight + ins.left;
                result.separatorArea.y = 0;
                result.separatorArea.width = new JSeparator((int)1).getPreferredSize().width;
                result.separatorArea.height = height;
                result.isTextInActionArea = true;
            }
            if (FlamingoUtilities.hasPopupAction(commandButton)) {
                result.popupActionRect.x = ins.left + labelHeight / 4;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
            }
        }
        return result;
    }
}

