/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.FlamingoCommand;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceRibbonGalleryUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonGalleryUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonGalleryUI;

public class JRibbonGallery
extends JComponent {
    protected List<JCommandToggleButton> buttons = new ArrayList<JCommandToggleButton>();
    protected List<FlamingoCommand> commands = new ArrayList<FlamingoCommand>();
    protected CommandToggleButtonGroup buttonSelectionGroup = new CommandToggleButtonGroup();
    protected RibbonElementPriority displayPriority;
    protected Map<RibbonElementPriority, Integer> preferredVisibleIconCount;
    protected List<StringValuePair<List<FlamingoCommand>>> commandGroups;
    protected int preferredPopupMaxButtonColumns;
    protected int preferredPopupMaxVisibleButtonRows;
    protected boolean isShowingPopupPanel;
    protected JRibbonBand.RibbonGalleryPopupCallback popupCallback;
    public static final String uiClassID = "RibbonGalleryUI";
    private String expandKeyTip;
    private CommandButtonDisplayState buttonDisplayState;

    public JRibbonGallery() {
        this.buttonSelectionGroup.addPropertyChangeListener(evt -> {
            if ("selected".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> this.firePropertyChange("selectedButton", evt.getOldValue(), evt.getNewValue()));
            }
        });
        this.preferredVisibleIconCount = new HashMap<RibbonElementPriority, Integer>();
        for (RibbonElementPriority state : RibbonElementPriority.values()) {
            this.preferredVisibleIconCount.put(state, 100);
        }
        this.isShowingPopupPanel = false;
        this.buttonDisplayState = JRibbonBand.BIG_FIXED_LANDSCAPE;
        this.updateUI();
    }

    public void setUI(RibbonGalleryUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceRibbonGalleryUI.createUI(this));
    }

    @Override
    public RibbonGalleryUI getUI() {
        return (RibbonGalleryUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void addGalleryCommand(StringValuePair<List<FlamingoCommand>> commandGroup, FlamingoCommand command) {
        String commandGroupName = (String)commandGroup.getKey();
        int indexToAdd = 0;
        for (int i = 0; i < this.commandGroups.size(); ++i) {
            StringValuePair<List<FlamingoCommand>> commandGroupPair = this.commandGroups.get(i);
            String currGroupName = (String)commandGroupPair.getKey();
            indexToAdd += ((List)commandGroupPair.getValue()).size();
            if (currGroupName == null && commandGroupName == null || currGroupName.compareTo(commandGroupName) == 0) break;
        }
        JCommandToggleButton button = (JCommandToggleButton)command.buildButton();
        this.buttons.add(indexToAdd, button);
        this.buttonSelectionGroup.add(button);
        this.commands.add(indexToAdd, command);
        ((List)commandGroup.getValue()).add(command);
        button.setDisplayState(this.buttonDisplayState);
        super.add(button);
    }

    private void removeGalleryCommand(FlamingoCommand command) {
        int index = this.commands.indexOf(command);
        this.commands.remove(command);
        JCommandToggleButton button = this.buttons.get(index);
        this.buttons.remove(button);
        this.buttonSelectionGroup.remove(button);
        super.remove(button);
    }

    public void setPreferredVisibleButtonCount(RibbonElementPriority state, int visibleButtonCount) {
        this.preferredVisibleIconCount.put(state, visibleButtonCount);
    }

    public int getPreferredWidth(RibbonElementPriority state, int availableHeight) {
        int preferredVisibleButtonCount = this.preferredVisibleIconCount.get((Object)state);
        BasicRibbonGalleryUI ui = (BasicRibbonGalleryUI)this.getUI();
        return ui.getPreferredWidth(preferredVisibleButtonCount, availableHeight);
    }

    public void setDisplayPriority(RibbonElementPriority displayPriority) {
        this.displayPriority = displayPriority;
    }

    public RibbonElementPriority getDisplayPriority() {
        return this.displayPriority;
    }

    public int getCommandGroupCount() {
        return this.commandGroups.size();
    }

    public List<FlamingoCommand> getCommandGroup(String commandGroupName) {
        for (StringValuePair<List<FlamingoCommand>> group : this.commandGroups) {
            if (((String)group.getKey()).compareTo(commandGroupName) != 0) continue;
            return (List)group.getValue();
        }
        return null;
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public FlamingoCommand getCommandAt(int index) {
        return this.commands.get(index);
    }

    public JCommandToggleButton getButtonAt(int index) {
        return this.buttons.get(index);
    }

    public JCommandToggleButton getButtonForCommand(FlamingoCommand command) {
        int index = this.commands.indexOf(command);
        if (index < 0) {
            return null;
        }
        return this.buttons.get(index);
    }

    public JCommandToggleButton getSelectedButton() {
        return this.buttonSelectionGroup.getSelected();
    }

    public FlamingoCommand getSelectedCommand() {
        JCommandToggleButton selectedButton = this.getSelectedButton();
        if (selectedButton == null) {
            return null;
        }
        int commandIndex = this.buttons.indexOf(selectedButton);
        return this.commands.get(commandIndex);
    }

    public void setSelectedButton(JCommandToggleButton selectedButton) {
        this.buttonSelectionGroup.setSelected(selectedButton, true);
    }

    public void setSelectedCommand(FlamingoCommand selectedCommand) {
        int buttonIndex = this.commands.indexOf(selectedCommand);
        this.setSelectedButton(this.buttons.get(buttonIndex));
    }

    public JCommandButtonPanel getPopupButtonPanel() {
        JCommandButtonPanel buttonPanel = new JCommandButtonPanel(this.buttonDisplayState);
        buttonPanel.setMaxButtonColumns(this.preferredPopupMaxButtonColumns);
        buttonPanel.setToShowGroupLabels(true);
        for (StringValuePair<List<FlamingoCommand>> commandGroupEntry : this.commandGroups) {
            String groupName = (String)commandGroupEntry.getKey();
            if (groupName == null) {
                buttonPanel.setToShowGroupLabels(false);
            }
            buttonPanel.addButtonGroup(groupName);
            for (FlamingoCommand command : (List)commandGroupEntry.getValue()) {
                JCommandToggleButton button = this.buttons.get(this.commands.indexOf(command));
                button.setVisible(true);
                buttonPanel.addButtonToLastGroup(button);
            }
        }
        buttonPanel.setSingleSelectionMode(true);
        return buttonPanel;
    }

    public void setShowingPopupPanel(boolean isShowingPopupPanel) {
        this.isShowingPopupPanel = isShowingPopupPanel;
        if (!isShowingPopupPanel) {
            for (StringValuePair<List<FlamingoCommand>> commandGroupEntry : this.commandGroups) {
                for (FlamingoCommand command : (List)commandGroupEntry.getValue()) {
                    JCommandToggleButton button = this.buttons.get(this.commands.indexOf(command));
                    button.setDisplayState(this.buttonDisplayState);
                    this.add(button);
                }
            }
            this.doLayout();
        }
    }

    public boolean isShowingPopupPanel() {
        return this.isShowingPopupPanel;
    }

    public void setGroupMapping(List<StringValuePair<List<FlamingoCommand>>> commands) {
        for (StringValuePair<List<FlamingoCommand>> commandGroupPair : commands) {
            for (FlamingoCommand command : (List)commandGroupPair.getValue()) {
                if (!command.isToggle()) {
                    throw new IllegalStateException("Gallery command must be toggle");
                }
                if (command.getToggleGroup() == null) continue;
                throw new IllegalStateException("Gallery toggle command should not be associated with a toggle group");
            }
        }
        this.commandGroups = new ArrayList<StringValuePair<List<FlamingoCommand>>>();
        boolean hasGroupWithNullTitle = false;
        for (StringValuePair<List<FlamingoCommand>> commandGroupPair : commands) {
            if (commandGroupPair.getKey() == null) {
                if (hasGroupWithNullTitle) {
                    throw new IllegalArgumentException("Can't have more than one ribbon gallery group with null name");
                }
                hasGroupWithNullTitle = true;
            }
            ArrayList commandGroupCopy = new ArrayList();
            StringValuePair<List<FlamingoCommand>> commandGroupInfo = new StringValuePair<List<FlamingoCommand>>((String)commandGroupPair.getKey(), (List<FlamingoCommand>)commandGroupCopy);
            this.commandGroups.add(commandGroupInfo);
            for (FlamingoCommand command : (List)commandGroupPair.getValue()) {
                this.addGalleryCommand(commandGroupInfo, command);
            }
        }
    }

    public void addRibbonGalleryCommands(String commandGroupName, FlamingoCommand ... commands) {
        for (StringValuePair<List<FlamingoCommand>> commandGroup : this.commandGroups) {
            if (((String)commandGroup.getKey()).compareTo(commandGroupName) != 0) continue;
            for (FlamingoCommand command : commands) {
                this.addGalleryCommand(commandGroup, command);
            }
            return;
        }
        this.revalidate();
        this.doLayout();
    }

    public void removeRibbonGalleryCommands(FlamingoCommand ... commands) {
        for (StringValuePair<List<FlamingoCommand>> commandGroup : this.commandGroups) {
            Iterator it = ((List)commandGroup.getValue()).iterator();
            while (it.hasNext()) {
                FlamingoCommand currCommandInGroup = (FlamingoCommand)it.next();
                for (FlamingoCommand toRemove : commands) {
                    if (toRemove != currCommandInGroup) continue;
                    it.remove();
                    this.removeGalleryCommand(toRemove);
                }
            }
        }
        this.revalidate();
        this.doLayout();
    }

    public void setPreferredPopupPanelDimension(int preferredPopupMaxButtonColumns, int preferredPopupMaxVisibleButtonRows) {
        this.preferredPopupMaxButtonColumns = preferredPopupMaxButtonColumns;
        this.preferredPopupMaxVisibleButtonRows = preferredPopupMaxVisibleButtonRows;
    }

    public void setPopupCallback(JRibbonBand.RibbonGalleryPopupCallback popupCallback) {
        this.popupCallback = popupCallback;
    }

    public JRibbonBand.RibbonGalleryPopupCallback getPopupCallback() {
        return this.popupCallback;
    }

    public int getPreferredPopupMaxButtonColumns() {
        return this.preferredPopupMaxButtonColumns;
    }

    public int getPreferredPopupMaxVisibleButtonRows() {
        return this.preferredPopupMaxVisibleButtonRows;
    }

    public void setExpandKeyTip(String expandKeyTip) {
        String old = this.expandKeyTip;
        this.expandKeyTip = expandKeyTip;
        this.firePropertyChange("expandKeyTip", old, this.expandKeyTip);
    }

    public String getExpandKeyTip() {
        return this.expandKeyTip;
    }

    public CommandButtonDisplayState getButtonDisplayState() {
        return this.buttonDisplayState;
    }

    public void setCommandDisplayState(CommandButtonDisplayState commandDisplayState) {
        boolean isSupported;
        if (this.getCommandCount() > 0) {
            throw new IllegalStateException("Cannot change command display state on ribbon gallery with existing commands");
        }
        boolean bl = isSupported = commandDisplayState == JRibbonBand.BIG_FIXED || commandDisplayState == CommandButtonDisplayState.SMALL || commandDisplayState == JRibbonBand.BIG_FIXED_LANDSCAPE;
        if (!isSupported) {
            throw new IllegalArgumentException("Display state " + commandDisplayState.getDisplayName() + " is not supported in ribbon galleries");
        }
        if (!commandDisplayState.equals(this.buttonDisplayState)) {
            CommandButtonDisplayState old = this.buttonDisplayState;
            this.buttonDisplayState = commandDisplayState;
            for (JCommandToggleButton button : this.buttons) {
                button.setDisplayState(commandDisplayState);
            }
            this.firePropertyChange("buttonDisplayState", old, this.buttonDisplayState);
        }
    }
}

