/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.internal.ui.common.JRichTooltipPanel;
import org.pushingpixels.flamingo.internal.ui.common.RichTooltipPanelUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public abstract class BasicRichTooltipPanelUI
extends RichTooltipPanelUI {
    protected JRichTooltipPanel richTooltipPanel;
    protected List<JLabel> titleLabels = new ArrayList<JLabel>();
    protected List<JLabel> descriptionLabels = new ArrayList<JLabel>();
    protected JLabel mainImageLabel;
    protected JSeparator footerSeparator;
    protected JLabel footerImageLabel;
    protected List<JLabel> footerLabels = new ArrayList<JLabel>();

    @Override
    public void installUI(JComponent c) {
        this.richTooltipPanel = (JRichTooltipPanel)c;
        super.installUI(this.richTooltipPanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.richTooltipPanel.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.richTooltipPanel);
    }

    protected void installDefaults() {
        Border b = this.richTooltipPanel.getBorder();
        if (b == null || b instanceof UIResource) {
            this.richTooltipPanel.setBorder((Border)new SubstanceBorder(new Insets(3, 5, 4, 5)));
        }
        LookAndFeel.installProperty(this.richTooltipPanel, "opaque", Boolean.TRUE);
        Font f = this.richTooltipPanel.getFont();
        if (f == null || f instanceof UIResource) {
            this.richTooltipPanel.setFont(SubstanceCortex.GlobalScope.getFontPolicy().getFontSet(null).getControlFont());
        }
    }

    protected void installListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.richTooltipPanel);
    }

    protected void uninstallListeners() {
    }

    protected void uninstallComponents() {
        this.removeExistingComponents();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paintBackground(g);
        this.paint(g, c);
    }

    protected abstract void paintBackground(Graphics var1);

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    protected LayoutManager createLayoutManager() {
        return new RichTooltipPanelLayout();
    }

    protected int getDescriptionTextWidth() {
        return FlamingoUtilities.getScaledSize(200, this.richTooltipPanel.getFont().getSize(), 40.0, 4);
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected void removeExistingComponents() {
        for (JLabel label : this.titleLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.mainImageLabel != null) {
            this.richTooltipPanel.remove(this.mainImageLabel);
        }
        for (JLabel label : this.descriptionLabels) {
            this.richTooltipPanel.remove(label);
        }
        if (this.footerSeparator != null) {
            this.richTooltipPanel.remove(this.footerSeparator);
        }
        if (this.footerImageLabel != null) {
            this.richTooltipPanel.remove(this.footerImageLabel);
        }
        for (JLabel label : this.footerLabels) {
            this.richTooltipPanel.remove(label);
        }
    }

    protected class RichTooltipPanelLayout
    implements LayoutManager {
        protected RichTooltipPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            TextLayout tl;
            Insets ins = parent.getInsets();
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet(null).getControlFont();
            Font titleFont = font.deriveFont(1);
            int descTextWidth = BasicRichTooltipPanelUI.this.getDescriptionTextWidth();
            int width = ins.left + 2 * gap + descTextWidth + ins.right;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            if (tooltipInfo.getMainIcon() != null) {
                width += tooltipInfo.getMainIcon().getIconWidth();
            }
            int fontHeight = parent.getFontMetrics(font).getHeight();
            int height = ins.top;
            int titleTextHeight = 0;
            AttributedString titleAttributedDescription = new AttributedString(tooltipInfo.getTitle());
            titleAttributedDescription.addAttribute(TextAttribute.FONT, titleFont);
            LineBreakMeasurer titleLineBreakMeasurer = new LineBreakMeasurer(titleAttributedDescription.getIterator(), frc);
            int maxTitleLineWidth = 0;
            while ((tl = titleLineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                titleTextHeight += fontHeight;
                int lineWidth = (int)Math.ceil(tl.getBounds().getWidth());
                maxTitleLineWidth = Math.max(maxTitleLineWidth, lineWidth);
            }
            height += titleTextHeight;
            height += gap;
            int descriptionTextHeight = 0;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl2;
                AttributedString descAttributedDescription = new AttributedString(descText);
                descAttributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer descLineBreakMeasurer = new LineBreakMeasurer(descAttributedDescription.getIterator(), frc);
                while ((tl2 = descLineBreakMeasurer.nextLayout(descTextWidth)) != null) {
                    descriptionTextHeight += fontHeight;
                }
                descriptionTextHeight += fontHeight;
            }
            if (!tooltipInfo.getDescriptionSections().isEmpty()) {
                descriptionTextHeight -= fontHeight;
                descriptionTextHeight += gap;
            }
            height = tooltipInfo.getMainIcon() != null ? (height += Math.max(descriptionTextHeight, tooltipInfo.getMainIcon().getIconHeight())) : (height += descriptionTextHeight);
            if (tooltipInfo.getFooterIcon() != null || tooltipInfo.getFooterSections().size() > 0) {
                height += gap;
                height += new JSeparator((int)0).getPreferredSize().height;
                height += gap;
                int footerTextHeight = 0;
                int availableWidth = descTextWidth;
                if (tooltipInfo.getFooterIcon() != null) {
                    availableWidth -= 16;
                }
                if (tooltipInfo.getMainIcon() != null) {
                    availableWidth += tooltipInfo.getMainIcon().getIconWidth();
                }
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl3;
                    AttributedString footerAttributedDescription = new AttributedString(footerText);
                    footerAttributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer footerLineBreakMeasurer = new LineBreakMeasurer(footerAttributedDescription.getIterator(), frc);
                    while ((tl3 = footerLineBreakMeasurer.nextLayout(availableWidth)) != null) {
                        footerTextHeight += fontHeight;
                    }
                    footerTextHeight += fontHeight;
                }
                height = tooltipInfo.getFooterIcon() != null ? (height += Math.max(footerTextHeight, 16)) : (height += (footerTextHeight -= fontHeight));
            }
            height += ins.bottom;
            if (tooltipInfo.getDescriptionSections().isEmpty() && tooltipInfo.getMainIcon() == null && tooltipInfo.getFooterSections().isEmpty() && tooltipInfo.getFooterIcon() == null) {
                width = maxTitleLineWidth + 1 + ins.left + ins.right;
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            TextLayout tl;
            BasicRichTooltipPanelUI.this.removeExistingComponents();
            FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet(null).getControlFont();
            Insets ins = BasicRichTooltipPanelUI.this.richTooltipPanel.getInsets();
            int y = ins.top;
            RichTooltip tooltipInfo = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, false);
            int gap = BasicRichTooltipPanelUI.this.getLayoutGap();
            int fontHeight = parent.getFontMetrics(font).getHeight();
            Font titleFont = font.deriveFont(1);
            boolean ltr = BasicRichTooltipPanelUI.this.richTooltipPanel.getComponentOrientation().isLeftToRight();
            int titleLabelWidth = parent.getWidth() - ins.left - ins.right;
            AttributedString titleAtributedDescription = new AttributedString(tooltipInfo.getTitle());
            titleAtributedDescription.addAttribute(TextAttribute.FONT, titleFont);
            LineBreakMeasurer titleLineBreakMeasurer = new LineBreakMeasurer(titleAtributedDescription.getIterator(), frc);
            int titleCurrOffset = 0;
            while ((tl = titleLineBreakMeasurer.nextLayout(titleLabelWidth)) != null) {
                int charCount = tl.getCharacterCount();
                String line = tooltipInfo.getTitle().substring(titleCurrOffset, titleCurrOffset + charCount);
                JLabel titleLabel = new JLabel(line);
                titleLabel.setFont(titleFont);
                BasicRichTooltipPanelUI.this.titleLabels.add(titleLabel);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(titleLabel);
                int currLabelWidth = titleLabel.getPreferredSize().width;
                if (ltr) {
                    titleLabel.setBounds(ins.left, y, currLabelWidth, fontHeight);
                } else {
                    titleLabel.setBounds(parent.getWidth() - ins.right - currLabelWidth, y, currLabelWidth, fontHeight);
                }
                y += titleLabel.getHeight();
                titleCurrOffset += charCount;
            }
            y += gap;
            int x = ltr ? ins.left : parent.getWidth() - ins.right;
            ResizableIcon mainImage = tooltipInfo.getMainIcon();
            if (mainImage != null) {
                BasicRichTooltipPanelUI.this.mainImageLabel = new JLabel((Icon)mainImage);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.mainImageLabel);
                int mainImageWidth = BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().width;
                if (ltr) {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x, y, mainImageWidth, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                    x += mainImageWidth;
                } else {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(x - mainImageWidth, y, mainImageWidth, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                    x -= mainImageWidth;
                }
            }
            x = ltr ? (x += 2 * gap) : (x -= 2 * gap);
            int descLabelWidth = ltr ? parent.getWidth() - x - ins.right : x - ins.left;
            for (String descText : tooltipInfo.getDescriptionSections()) {
                TextLayout tl2;
                AttributedString attributedDescription = new AttributedString(descText);
                attributedDescription.addAttribute(TextAttribute.FONT, font);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                int currOffset = 0;
                while ((tl2 = lineBreakMeasurer.nextLayout(descLabelWidth)) != null) {
                    int charCount = tl2.getCharacterCount();
                    String line = descText.substring(currOffset, currOffset + charCount);
                    JLabel descLabel = new JLabel(line);
                    BasicRichTooltipPanelUI.this.descriptionLabels.add(descLabel);
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(descLabel);
                    int currDescWidth = descLabel.getPreferredSize().width;
                    if (ltr) {
                        descLabel.setBounds(x, y, currDescWidth, fontHeight);
                    } else {
                        descLabel.setBounds(x - currDescWidth, y, currDescWidth, fontHeight);
                    }
                    y += descLabel.getHeight();
                    currOffset += charCount;
                }
                y += fontHeight;
            }
            y -= fontHeight;
            if (BasicRichTooltipPanelUI.this.mainImageLabel != null) {
                y = Math.max(y, BasicRichTooltipPanelUI.this.mainImageLabel.getY() + BasicRichTooltipPanelUI.this.mainImageLabel.getHeight());
            }
            if (tooltipInfo.getFooterIcon() != null || tooltipInfo.getFooterSections().size() > 0) {
                BasicRichTooltipPanelUI.this.footerSeparator = new JSeparator(0);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerSeparator);
                BasicRichTooltipPanelUI.this.footerSeparator.setBounds(ins.left, y += gap, parent.getWidth() - ins.left - ins.right, BasicRichTooltipPanelUI.this.footerSeparator.getPreferredSize().height);
                y += BasicRichTooltipPanelUI.this.footerSeparator.getHeight() + gap;
                int n = x = ltr ? ins.left : parent.getWidth() - ins.right;
                if (tooltipInfo.getFooterIcon() != null) {
                    tooltipInfo.getFooterIcon().setDimension(new Dimension(16, 16));
                    BasicRichTooltipPanelUI.this.footerImageLabel = new JLabel((Icon)tooltipInfo.getFooterIcon());
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerImageLabel);
                    int footerImageWidth = BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().width;
                    if (ltr) {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x, y, footerImageWidth, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                        x += footerImageWidth + 2 * gap;
                    } else {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(x - footerImageWidth, y, footerImageWidth, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                        x -= footerImageWidth + 2 * gap;
                    }
                }
                int footerLabelWidth = ltr ? parent.getWidth() - x - ins.right : x - ins.left;
                for (String footerText : tooltipInfo.getFooterSections()) {
                    TextLayout tl3;
                    AttributedString attributedDescription = new AttributedString(footerText);
                    attributedDescription.addAttribute(TextAttribute.FONT, font);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedDescription.getIterator(), frc);
                    int currOffset = 0;
                    while ((tl3 = lineBreakMeasurer.nextLayout(footerLabelWidth)) != null) {
                        int charCount = tl3.getCharacterCount();
                        String line = footerText.substring(currOffset, currOffset + charCount);
                        JLabel footerLabel = new JLabel(line);
                        BasicRichTooltipPanelUI.this.footerLabels.add(footerLabel);
                        BasicRichTooltipPanelUI.this.richTooltipPanel.add(footerLabel);
                        int currLabelWidth = footerLabel.getPreferredSize().width;
                        if (ltr) {
                            footerLabel.setBounds(x, y, currLabelWidth, fontHeight);
                        } else {
                            footerLabel.setBounds(x - currLabelWidth, y, currLabelWidth, fontHeight);
                        }
                        y += footerLabel.getHeight();
                        currOffset += charCount;
                    }
                    y += fontHeight;
                }
                y -= fontHeight;
            }
        }
    }
}

