/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pushingpixels.flamingo.api.common.FlamingoCommand;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuPrimaryCommand;

public class RibbonApplicationMenu {
    private boolean isFrozen;
    private String title;
    private List<List<RibbonApplicationMenuPrimaryCommand>> primaryCommands;
    private List<FlamingoCommand> footerCommands;
    private RibbonApplicationMenuPrimaryCommand.PrimaryRolloverCallback defaultCallback;

    public RibbonApplicationMenu(String title) {
        if (title == null || title.isEmpty()) {
            throw new IllegalArgumentException("Menu title can not be null or empty");
        }
        this.title = title;
        this.primaryCommands = new ArrayList<List<RibbonApplicationMenuPrimaryCommand>>();
        this.primaryCommands.add(new ArrayList());
        this.footerCommands = new ArrayList<FlamingoCommand>();
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void addMenuCommand(RibbonApplicationMenuPrimaryCommand command) {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add menu entries after the menu has been set on the ribbon");
        }
        this.primaryCommands.get(this.primaryCommands.size() - 1).add(command);
    }

    public synchronized void addMenuSeparator() {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add menu entries after the menu has been set on the ribbon");
        }
        this.primaryCommands.add(new ArrayList());
    }

    public List<List<RibbonApplicationMenuPrimaryCommand>> getPrimaryCommands() {
        return Collections.unmodifiableList(this.primaryCommands);
    }

    public synchronized void addFooterCommand(FlamingoCommand entry) {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add footer commands after the menu has been set on the ribbon");
        }
        this.footerCommands.add(entry);
    }

    public List<FlamingoCommand> getFooterCommands() {
        return Collections.unmodifiableList(this.footerCommands);
    }

    public void setDefaultCallback(RibbonApplicationMenuPrimaryCommand.PrimaryRolloverCallback defaultCallback) {
        this.defaultCallback = defaultCallback;
    }

    public RibbonApplicationMenuPrimaryCommand.PrimaryRolloverCallback getDefaultCallback() {
        return this.defaultCallback;
    }

    synchronized void setFrozen() {
        this.isFrozen = true;
        if (this.primaryCommands.get(this.primaryCommands.size() - 1).isEmpty()) {
            this.primaryCommands.remove(this.primaryCommands.size() - 1);
        }
    }
}

