/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.layout.TransitionLayoutEvent;
import org.pushingpixels.flamingo.api.layout.TransitionLayoutListener;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.swing.SwingComponentTimeline;

public class TransitionLayout
implements LayoutManager {
    private LayoutManager delegate;
    private List<TransitionLayoutListener> eventListeners;
    private static final String SHOWING = "flamingo.layout.showing";
    private static final String BOUNDS = "flamingo.layout.bounds";
    private WeakHashMap<Component, Timeline> boundsMap = new WeakHashMap();
    private Container container;
    private boolean doImmediateRepaint;
    private boolean hasPendingLayoutRequests;
    private int pendingAnimationCount;

    public TransitionLayout(Container container, LayoutManager delegate) {
        this.container = container;
        this.delegate = delegate;
        this.doImmediateRepaint = false;
        this.hasPendingLayoutRequests = false;
        this.pendingAnimationCount = 0;
        this.eventListeners = new ArrayList<TransitionLayoutListener>();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.delegate.addLayoutComponent(name, comp);
    }

    @Override
    public void layoutContainer(Container parent) {
        JComponent jc;
        int i;
        if (this.getPendingAnimationCount() > 0) {
            this.requestLayout();
            return;
        }
        this.fireEvent(null, 100);
        HashMap<JComponent, Rectangle> oldLocations = new HashMap<JComponent, Rectangle>();
        for (i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            jc = (JComponent)c;
            oldLocations.put(jc, new Rectangle(jc.getBounds()));
        }
        this.delegate.layoutContainer(parent);
        parent.repaint();
        for (i = 0; i < parent.getComponentCount(); ++i) {
            Component comp = parent.getComponent(i);
            jc = (JComponent)comp;
            final Rectangle newBounds = new Rectangle(jc.getBounds());
            final Rectangle oldBounds = jc.getClientProperty(BOUNDS) instanceof Rectangle ? (Rectangle)jc.getClientProperty(BOUNDS) : (Rectangle)oldLocations.get(jc);
            boolean wasShowing = Boolean.TRUE.equals(jc.getClientProperty(SHOWING));
            boolean isShowing = jc.isVisible();
            if (jc.isVisible()) {
                jc.putClientProperty(SHOWING, Boolean.TRUE);
            } else {
                jc.putClientProperty(SHOWING, null);
            }
            jc.putClientProperty(BOUNDS, new Rectangle(newBounds));
            if (!isShowing || !wasShowing || oldBounds.equals(newBounds)) continue;
            jc.setBounds(oldBounds);
            this.animationStarted();
            Timeline boundsTimeline = this.boundsMap.get(jc);
            if (boundsTimeline != null) {
                boundsTimeline.abort();
            }
            boundsTimeline = new SwingComponentTimeline((Component)jc);
            this.boundsMap.put(jc, boundsTimeline);
            boundsTimeline.addCallback((TimelineCallback)new UIThreadTimelineCallbackAdapter(){

                public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                    this.onPulse(timelinePosition);
                    if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                        TransitionLayout.this.animationEnded();
                        TransitionLayout.this.boundsMap.remove(jc);
                    }
                }

                public void onTimelinePulse(float durationFraction, float timelinePosition) {
                    this.onPulse(timelinePosition);
                }

                void onPulse(float timelinePosition) {
                    Rectangle currBounds = new Rectangle((int)((float)oldBounds.x + timelinePosition * (float)(newBounds.x - oldBounds.x)), (int)((float)oldBounds.y + timelinePosition * (float)(newBounds.y - oldBounds.y)), (int)((float)oldBounds.width + timelinePosition * (float)(newBounds.width - oldBounds.width)), (int)((float)oldBounds.height + timelinePosition * (float)(newBounds.height - oldBounds.height)));
                    jc.setBounds(currBounds);
                    TransitionLayout.this.fireEvent(jc, 104);
                    jc.doLayout();
                    TransitionLayout.this.repaint(jc);
                }
            });
            boundsTimeline.play();
        }
        if (this.getPendingAnimationCount() == 0) {
            this.fireEvent(null, 101);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.delegate.minimumLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.delegate.preferredLayoutSize(parent);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.delegate.removeLayoutComponent(comp);
    }

    private synchronized void requestLayout() {
        this.hasPendingLayoutRequests = true;
    }

    private synchronized void layoutFinished() {
        this.hasPendingLayoutRequests = false;
        if (this.getPendingAnimationCount() == 0) {
            this.fireEvent(null, 101);
        }
    }

    private synchronized boolean hasPendingLayoutRequests() {
        return this.hasPendingLayoutRequests;
    }

    private synchronized int getPendingAnimationCount() {
        return this.pendingAnimationCount;
    }

    private synchronized void animationStarted() {
        ++this.pendingAnimationCount;
    }

    private synchronized void animationEnded() {
        --this.pendingAnimationCount;
        if (this.pendingAnimationCount == 0) {
            if (this.hasPendingLayoutRequests()) {
                SwingUtilities.invokeLater(() -> {
                    this.layoutContainer(this.container);
                    this.layoutFinished();
                    this.container.repaint();
                });
            } else {
                this.fireEvent(null, 101);
            }
        }
    }

    public LayoutManager getDelegate() {
        return this.delegate;
    }

    void setDoImmediateRepaint(boolean doImmediateRepaint) {
        this.doImmediateRepaint = doImmediateRepaint;
    }

    protected void repaint(Component comp) {
        if (this.doImmediateRepaint && comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            SwingUtilities.invokeLater(() -> jc.paintImmediately(0, 0, jc.getWidth(), jc.getHeight()));
            return;
        }
        comp.repaint();
    }

    public synchronized void addTransitionLayoutListener(TransitionLayoutListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized void removeTransitionLayoutListener(TransitionLayoutListener listener) {
        this.eventListeners.remove(listener);
    }

    protected void fireEvent(Component child, int id) {
        TransitionLayoutEvent event = new TransitionLayoutEvent(this.container, child, id);
        for (TransitionLayoutListener listener : this.eventListeners) {
            listener.onTransitionLayoutEvent(event);
        }
    }
}

