/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ScrollableHost;

public class JCommandPopupMenu
extends JPopupPanel
implements ScrollableHost {
    public static final String uiClassID = "CommandPopupMenuUI";
    protected JCommandButtonPanel mainButtonPanel;
    protected List<Component> menuComponents = new ArrayList<Component>();
    protected int maxButtonColumns;
    protected int maxVisibleButtonRows;
    protected int maxVisibleMenuButtons = -1;
    private boolean toDismissOnChildClick = true;

    public JCommandPopupMenu() {
    }

    public JCommandPopupMenu(JCommandButtonPanel buttonPanel, int maxButtonColumns, int maxVisibleButtonRows) {
        this();
        this.mainButtonPanel = buttonPanel;
        this.maxButtonColumns = maxButtonColumns;
        this.maxVisibleButtonRows = maxVisibleButtonRows;
        this.updateUI();
    }

    public void addMenuButton(JCommandMenuButton menuButton) {
        menuButton.setHorizontalAlignment(2);
        this.menuComponents.add(menuButton);
        this.fireStateChanged();
    }

    public void addMenuButton(JCommandToggleMenuButton menuButton) {
        menuButton.setHorizontalAlignment(2);
        this.menuComponents.add(menuButton);
        this.fireStateChanged();
    }

    public void addMenuSeparator() {
        this.menuComponents.add(new JPopupMenu.Separator());
        this.fireStateChanged();
    }

    protected void addMenuPanel(JPanel menuPanel) {
        if (this.maxVisibleMenuButtons > 0) {
            throw new IllegalStateException("This method is not supported on menu that contains a command button panel");
        }
        this.menuComponents.add(menuPanel);
        this.fireStateChanged();
    }

    public boolean hasCommandButtonPanel() {
        return this.mainButtonPanel != null;
    }

    public JCommandButtonPanel getMainButtonPanel() {
        return this.mainButtonPanel;
    }

    public List<Component> getMenuComponents() {
        if (this.menuComponents == null) {
            return null;
        }
        return Collections.unmodifiableList(this.menuComponents);
    }

    public int getMaxButtonColumns() {
        return this.maxButtonColumns;
    }

    public int getMaxVisibleButtonRows() {
        return this.maxVisibleButtonRows;
    }

    public int getMaxVisibleMenuButtons() {
        return this.maxVisibleMenuButtons;
    }

    public void setMaxVisibleMenuButtons(int maxVisibleMenuButtons) {
        for (Component menuComp : this.menuComponents) {
            if (!(menuComp instanceof JPanel)) continue;
            throw new IllegalStateException("This method is not supported on menus with panels");
        }
        int old = this.maxVisibleMenuButtons;
        this.maxVisibleMenuButtons = maxVisibleMenuButtons;
        if (old != this.maxVisibleMenuButtons) {
            this.firePropertyChange("maxVisibleMenuButtons", old, this.maxVisibleMenuButtons);
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandPopupMenuUI.createUI(this));
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public boolean isToDismissOnChildClick() {
        return this.toDismissOnChildClick;
    }

    public void setToDismissOnChildClick(boolean toDismissOnChildClick) {
        this.toDismissOnChildClick = toDismissOnChildClick;
    }
}

