/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.neon.AsynchronousLoading;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.neon.internal.contrib.intellij.UIUtil;

public class FilteredResizableIcon
implements ResizableIcon {
    protected Map<String, BufferedImage> cachedImages;
    protected ResizableIcon delegate;
    protected BufferedImageOp operation;

    public FilteredResizableIcon(ResizableIcon delegate, BufferedImageOp operation) {
        this.delegate = delegate;
        this.operation = operation;
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d;
        String key = this.getIconWidth() + ":" + this.getIconHeight();
        if (!this.cachedImages.containsKey(key)) {
            AsynchronousLoading asyncDelegate;
            if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)this.delegate).isLoading()) {
                return;
            }
            BufferedImage offscreen = NeonCortex.getBlankImage((int)this.getIconWidth(), (int)this.getIconHeight());
            g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, (Graphics)g2d, 0, 0);
            g2d.dispose();
            BufferedImage filtered = this.operation.filter(offscreen, null);
            this.cachedImages.put(key, filtered);
        }
        BufferedImage toDraw = this.cachedImages.get(key);
        g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        double scaleFactor = UIUtil.getScaleFactor();
        g2d.drawImage(toDraw, 0, 0, (int)((double)toDraw.getWidth(null) / scaleFactor), (int)((double)toDraw.getHeight(null) / scaleFactor), null);
        g2d.dispose();
    }
}

