/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.pushingpixels.neon.icon.ResizableIcon;

public class RichTooltip {
    private String title;
    private ResizableIcon mainIcon;
    private List<String> descriptionSections;
    private ResizableIcon footerIcon;
    private List<String> footerSections;

    private RichTooltip() {
    }

    public String getTitle() {
        return this.title;
    }

    public ResizableIcon getMainIcon() {
        return this.mainIcon;
    }

    public List<String> getDescriptionSections() {
        return this.descriptionSections;
    }

    public ResizableIcon getFooterIcon() {
        return this.footerIcon;
    }

    public List<String> getFooterSections() {
        return this.footerSections;
    }

    public static class RichTooltipBuilder {
        private String title;
        private ResizableIcon mainIcon;
        private List<String> descriptionSections;
        private ResizableIcon footerIcon;
        private List<String> footerSections;

        public RichTooltip build() {
            RichTooltip richTooltip = new RichTooltip();
            richTooltip.title = this.title;
            richTooltip.mainIcon = this.mainIcon;
            richTooltip.descriptionSections = this.descriptionSections != null ? Collections.unmodifiableList(this.descriptionSections) : Collections.EMPTY_LIST;
            richTooltip.footerIcon = this.footerIcon;
            richTooltip.footerSections = this.footerSections != null ? Collections.unmodifiableList(this.footerSections) : Collections.EMPTY_LIST;
            return richTooltip;
        }

        public RichTooltipBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public RichTooltipBuilder setMainIcon(ResizableIcon mainIcon) {
            this.mainIcon = mainIcon;
            return this;
        }

        public RichTooltipBuilder addDescriptionSection(String section) {
            if (this.descriptionSections == null) {
                this.descriptionSections = new LinkedList<String>();
            }
            this.descriptionSections.add(section);
            return this;
        }

        public RichTooltipBuilder setFooterIcon(ResizableIcon footerIcon) {
            this.footerIcon = footerIcon;
            return this;
        }

        public RichTooltipBuilder addFooterSection(String section) {
            if (this.footerSections == null) {
                this.footerSections = new LinkedList<String>();
            }
            this.footerSections.add(section);
            return this;
        }
    }
}

