/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.internal.ui.common.JRichTooltipPanel;

public class RichToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private Timer initialDelayTimer = new Timer(750, new InitialDelayTimerAction());
    private Timer dismissTimer;
    private RichTooltip richTooltip;
    private JTrackableComponent insideComponent;
    private MouseEvent mouseEvent;
    private static final RichToolTipManager sharedInstance = new RichToolTipManager();
    private Popup tipWindow;
    private JRichTooltipPanel tip;
    private boolean tipShowing = false;
    private static final String TRACKED_FOR_RICH_TOOLTIP = "flamingo.internal.trackedForRichTooltip";

    private RichToolTipManager() {
        this.initialDelayTimer.setRepeats(false);
        this.dismissTimer = new Timer(20000, new DismissTimerAction());
        this.dismissTimer.setRepeats(false);
    }

    public void setInitialDelay(int milliseconds) {
        this.initialDelayTimer.setInitialDelay(milliseconds);
    }

    public int getInitialDelay() {
        return this.initialDelayTimer.getInitialDelay();
    }

    public void setDismissDelay(int milliseconds) {
        this.dismissTimer.setInitialDelay(milliseconds);
    }

    public int getDismissDelay() {
        return this.dismissTimer.getInitialDelay();
    }

    private void showTipWindow(MouseEvent mouseEvent) {
        boolean isInRibbonBand;
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        Point screenLocation = this.insideComponent.getLocationOnScreen();
        Point location = new Point();
        GraphicsConfiguration gc = this.insideComponent.getGraphicsConfiguration();
        Rectangle sBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        sBounds.x += screenInsets.left;
        sBounds.y += screenInsets.top;
        sBounds.width -= screenInsets.left + screenInsets.right;
        sBounds.height -= screenInsets.top + screenInsets.bottom;
        this.hideTipWindow();
        this.tip = new JRichTooltipPanel(this.insideComponent.getRichTooltip(mouseEvent));
        this.tip.applyComponentOrientation(this.insideComponent.getComponentOrientation());
        Dimension size = this.tip.getPreferredSize();
        AbstractRibbonBand ribbonBand = (AbstractRibbonBand)SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, this.insideComponent);
        boolean ltr = this.tip.getComponentOrientation().isLeftToRight();
        boolean bl = isInRibbonBand = ribbonBand != null;
        if (isInRibbonBand) {
            location.x = ltr ? screenLocation.x : screenLocation.x + this.insideComponent.getWidth() - size.width;
            Point bandLocationOnScreen = ribbonBand.getLocationOnScreen();
            location.y = bandLocationOnScreen.y + ribbonBand.getHeight() + 4;
            if (location.y + size.height > sBounds.y + sBounds.height) {
                location.y = bandLocationOnScreen.y - size.height;
            }
        } else {
            location.x = ltr ? screenLocation.x : screenLocation.x + this.insideComponent.getWidth() - size.width;
            location.y = screenLocation.y + this.insideComponent.getHeight();
            if (location.y + size.height > sBounds.y + sBounds.height) {
                location.y = screenLocation.y - size.height;
            }
        }
        if (location.x < sBounds.x) {
            location.x = sBounds.x;
        } else if (location.x - sBounds.x + size.width > sBounds.width) {
            location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, location.x, location.y);
        this.tipWindow.show();
        this.dismissTimer.start();
        this.tipShowing = true;
    }

    private void hideTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip = null;
            this.dismissTimer.stop();
        }
    }

    public static RichToolTipManager sharedInstance() {
        return sharedInstance;
    }

    public void registerComponent(JTrackableComponent comp) {
        if (Boolean.TRUE.equals(comp.getClientProperty(TRACKED_FOR_RICH_TOOLTIP))) {
            return;
        }
        comp.addMouseListener(this);
        comp.putClientProperty(TRACKED_FOR_RICH_TOOLTIP, Boolean.TRUE);
    }

    public void unregisterComponent(JTrackableComponent comp) {
        comp.removeMouseListener(this);
        comp.putClientProperty(TRACKED_FOR_RICH_TOOLTIP, null);
    }

    public void hideCurrentlyShowingTipIfNecessary() {
        this.hideTipWindow();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    private void initiateToolTip(MouseEvent event) {
        JTrackableComponent component = (JTrackableComponent)event.getSource();
        Point location = event.getPoint();
        if (location.x < 0 || location.x >= component.getWidth() || location.y < 0 || location.y >= component.getHeight()) {
            return;
        }
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() > 0) {
            JPopupPanel popupPanel = popups.get(popups.size() - 1).getPopupPanel();
            boolean ignore = true;
            for (Container c = component; c != null; c = c.getParent()) {
                if (c != popupPanel) continue;
                ignore = false;
                break;
            }
            if (ignore) {
                return;
            }
        }
        if (this.insideComponent != null) {
            this.initialDelayTimer.stop();
        }
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        this.insideComponent = component;
        this.mouseEvent = event;
        this.initialDelayTimer.start();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.initialDelayTimer.stop();
        if (this.insideComponent != null) {
            this.insideComponent.removeMouseMotionListener(this);
        }
        this.insideComponent = null;
        this.richTooltip = null;
        this.mouseEvent = null;
        this.hideTipWindow();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.hideTipWindow();
        this.initialDelayTimer.stop();
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.tipShowing) {
            this.checkForTipChange(event);
        } else {
            this.insideComponent = (JTrackableComponent)event.getSource();
            this.mouseEvent = event;
            this.richTooltip = null;
            this.initialDelayTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent event) {
        boolean isDifferent;
        JTrackableComponent component = (JTrackableComponent)event.getSource();
        RichTooltip newTooltip = component.getRichTooltip(event);
        boolean bl = isDifferent = this.richTooltip != newTooltip;
        if (isDifferent) {
            this.hideTipWindow();
            if (newTooltip != null) {
                this.richTooltip = newTooltip;
                this.initialDelayTimer.restart();
            }
        }
    }

    private class DismissTimerAction
    implements ActionListener {
        private DismissTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RichToolTipManager.this.hideTipWindow();
            RichToolTipManager.this.initialDelayTimer.stop();
            RichToolTipManager.this.insideComponent = null;
            RichToolTipManager.this.mouseEvent = null;
        }
    }

    private class InitialDelayTimerAction
    implements ActionListener {
        private InitialDelayTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RichToolTipManager.this.insideComponent != null && RichToolTipManager.this.insideComponent.isShowing()) {
                if (RichToolTipManager.this.richTooltip == null && RichToolTipManager.this.mouseEvent != null) {
                    RichToolTipManager.this.richTooltip = RichToolTipManager.this.insideComponent.getRichTooltip(RichToolTipManager.this.mouseEvent);
                }
                if (RichToolTipManager.this.richTooltip != null) {
                    boolean showRichTooltip = true;
                    for (PopupPanelManager.PopupInfo pi : PopupPanelManager.defaultManager().getShownPath()) {
                        if (pi.getPopupOriginator() != RichToolTipManager.this.insideComponent) continue;
                        showRichTooltip = false;
                        break;
                    }
                    if (showRichTooltip) {
                        RichToolTipManager.this.showTipWindow(RichToolTipManager.this.mouseEvent);
                    }
                } else {
                    RichToolTipManager.this.insideComponent = null;
                    RichToolTipManager.this.richTooltip = null;
                    RichToolTipManager.this.mouseEvent = null;
                    RichToolTipManager.this.hideTipWindow();
                }
            }
        }
    }

    public static abstract class JTrackableComponent
    extends JComponent {
        public abstract RichTooltip getRichTooltip(MouseEvent var1);
    }
}

