/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.PopupActionListener;
import org.pushingpixels.flamingo.api.common.RichToolTipManager;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.model.ActionRepeatableButtonModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.neon.icon.ResizableIcon;

public class JCommandButton
extends AbstractCommandButton {
    public static final String uiClassID = "CommandButtonUI";
    public static final int DEFAULT_AUTO_REPEAT_INITIAL_INTERVAL_MS = 500;
    public static final int DEFAULT_AUTO_REPEAT_SUBSEQUENT_INTERVAL_MS = 100;
    protected PopupPanelCallback popupCallback;
    protected CommandButtonKind commandButtonKind;
    protected CommandButtonPopupOrientationKind popupOrientationKind;
    protected boolean isAutoRepeatAction;
    protected int autoRepeatInitialInterval;
    protected int autoRepeatSubsequentInterval;
    protected boolean isFireActionOnRollover;
    protected PopupButtonModel popupModel;
    protected PopupHandler popupHandler;
    private RichTooltip popupRichTooltip;
    protected String popupKeyTip;

    public JCommandButton(ResizableIcon icon) {
        this(null, icon);
    }

    public JCommandButton(String title) {
        this(title, null);
    }

    public JCommandButton(String title, ResizableIcon icon) {
        super(title, icon);
        this.setActionModel(new ActionRepeatableButtonModel(this));
        this.popupHandler = new PopupHandler();
        this.setPopupModel(new DefaultPopupButtonModel());
        this.commandButtonKind = CommandButtonKind.ACTION_ONLY;
        this.popupOrientationKind = CommandButtonPopupOrientationKind.DOWNWARD;
        this.isAutoRepeatAction = false;
        this.autoRepeatInitialInterval = 500;
        this.autoRepeatSubsequentInterval = 100;
        this.updateUI();
    }

    public CommandButtonKind getCommandButtonKind() {
        return this.commandButtonKind;
    }

    public void setCommandButtonKind(CommandButtonKind commandButtonKind) {
        CommandButtonKind old = this.commandButtonKind;
        this.commandButtonKind = commandButtonKind;
        if (old != this.commandButtonKind) {
            this.firePropertyChange("commandButtonKind", (Object)old, (Object)this.commandButtonKind);
        }
    }

    public CommandButtonPopupOrientationKind getPopupOrientationKind() {
        return this.popupOrientationKind;
    }

    public void setPopupOrientationKind(CommandButtonPopupOrientationKind popupOrientationKind) {
        CommandButtonPopupOrientationKind old = this.popupOrientationKind;
        this.popupOrientationKind = popupOrientationKind;
        if (old != this.popupOrientationKind) {
            this.firePropertyChange("popupOrientationKind", (Object)old, (Object)this.popupOrientationKind);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandButtonUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public PopupPanelCallback getPopupCallback() {
        return this.popupCallback;
    }

    public void setPopupCallback(PopupPanelCallback popupCallback) {
        this.popupCallback = popupCallback;
    }

    public void setAutoRepeatAction(boolean isAutoRepeatAction) {
        this.isAutoRepeatAction = isAutoRepeatAction;
    }

    public void setAutoRepeatActionIntervals(int initial, int subsequent) {
        this.autoRepeatInitialInterval = initial;
        this.autoRepeatSubsequentInterval = subsequent;
    }

    public boolean isAutoRepeatAction() {
        return this.isAutoRepeatAction;
    }

    public int getAutoRepeatInitialInterval() {
        return this.autoRepeatInitialInterval;
    }

    public int getAutoRepeatSubsequentInterval() {
        return this.autoRepeatSubsequentInterval;
    }

    public void setFireActionOnRollover(boolean isFireActionOnRollover) {
        this.isFireActionOnRollover = isFireActionOnRollover;
    }

    public boolean isFireActionOnRollover() {
        return this.isFireActionOnRollover;
    }

    public PopupButtonModel getPopupModel() {
        return this.popupModel;
    }

    public void setPopupModel(PopupButtonModel newModel) {
        PopupButtonModel oldModel = this.getPopupModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.popupHandler);
            oldModel.removeActionListener(this.popupHandler);
        }
        this.popupModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.popupHandler);
            newModel.addActionListener(this.popupHandler);
        }
        this.firePropertyChange("popupModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (!b && this.popupModel.isRollover()) {
            this.popupModel.setRollover(false);
        }
        super.setEnabled(b);
        this.popupModel.setEnabled(b);
    }

    protected void firePopupActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    boolean hasRichTooltips() {
        return super.hasRichTooltips() || this.popupRichTooltip != null;
    }

    public void setPopupRichTooltip(RichTooltip richTooltip) {
        this.popupRichTooltip = richTooltip;
        RichToolTipManager richToolTipManager = RichToolTipManager.sharedInstance();
        if (this.hasRichTooltips()) {
            richToolTipManager.registerComponent(this);
        } else {
            richToolTipManager.unregisterComponent(this);
        }
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent event) {
        CommandButtonUI ui = this.getUI();
        if (ui.getLayoutInfo().actionClickArea.contains(event.getPoint())) {
            return super.getRichTooltip(event);
        }
        if (ui.getLayoutInfo().popupClickArea.contains(event.getPoint())) {
            return this.popupRichTooltip;
        }
        return null;
    }

    public String getPopupKeyTip() {
        return this.popupKeyTip;
    }

    public void setPopupKeyTip(String popupKeyTip) {
        if (!this.canHaveBothKeyTips() && popupKeyTip != null && this.actionKeyTip != null) {
            throw new IllegalArgumentException("Action *and* popup keytips are not supported at the same time");
        }
        String old = this.popupKeyTip;
        this.popupKeyTip = popupKeyTip;
        this.firePropertyChange("popupKeyTip", old, this.popupKeyTip);
    }

    @Override
    public void setActionKeyTip(String actionKeyTip) {
        if (!this.canHaveBothKeyTips() && this.popupKeyTip != null && this.actionKeyTip != null) {
            throw new IllegalArgumentException("Action *and* popup keytips are not supported at the same time");
        }
        super.setActionKeyTip(actionKeyTip);
    }

    boolean canHaveBothKeyTips() {
        return false;
    }

    public void doPopupClick() {
        Dimension size = this.getSize();
        PopupButtonModel popupModel = this.getPopupModel();
        popupModel.setArmed(true);
        popupModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        popupModel.setPressed(false);
        popupModel.setArmed(false);
        popupModel.setPopupShowing(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
    }

    class PopupHandler
    implements PopupActionListener,
    ChangeListener {
        PopupHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCommandButton.this.fireStateChanged();
            JCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCommandButton.this.firePopupActionPerformed(event);
        }
    }

    private static class DefaultPopupButtonModel
    extends DefaultButtonModel
    implements PopupButtonModel {
        public static final int POPUP_SHOWING = 256;

        @Override
        public void addPopupActionListener(PopupActionListener l) {
            this.listenerList.add(PopupActionListener.class, l);
        }

        @Override
        public void removePopupActionListener(PopupActionListener l) {
            this.listenerList.remove(PopupActionListener.class, l);
        }

        protected void firePopupActionPerformed(ActionEvent e) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PopupActionListener.class) continue;
                ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
            }
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.firePopupActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
            this.fireStateChanged();
        }

        @Override
        public boolean isPopupShowing() {
            return (this.stateMask & 0x100) != 0;
        }

        @Override
        public void setPopupShowing(boolean b) {
            if (this.isPopupShowing() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 0x100) : (this.stateMask &= 0xFFFFFEFF);
            this.fireStateChanged();
        }
    }

    public static enum CommandButtonPopupOrientationKind {
        DOWNWARD,
        SIDEWARD;

    }

    public static enum CommandButtonKind {
        ACTION_ONLY(true, false),
        POPUP_ONLY(false, true),
        ACTION_AND_POPUP_MAIN_ACTION(true, true),
        ACTION_AND_POPUP_MAIN_POPUP(true, true);

        private boolean hasAction;
        private boolean hasPopup;

        private CommandButtonKind(boolean hasAction, boolean hasPopup) {
            this.hasAction = hasAction;
            this.hasPopup = hasPopup;
        }

        public boolean hasAction() {
            return this.hasAction;
        }

        public boolean hasPopup() {
            return this.hasPopup;
        }
    }
}

