/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.FlamingoCommand;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuPrimaryCommand;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicPopupPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.CommandButtonLayoutManagerMenuTileLevel1;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanelSecondary;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public abstract class BasicRibbonApplicationMenuPopupPanelUI
extends BasicPopupPanelUI {
    protected JPanel panelLevel1;
    protected JScrollablePanel<JPanel> panelScrollerLevel2;
    protected JPanel panelLevel2;
    protected JPanel footerPanel;
    protected static final CommandButtonDisplayState MENU_TILE_LEVEL_1 = new CommandButtonDisplayState("Ribbon application menu tile level 1", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerMenuTileLevel1();
        }
    };
    protected JRibbonApplicationMenuPopupPanel applicationMenuPopupPanel;
    protected JPanel mainPanel;

    @Override
    public void installUI(JComponent c) {
        this.applicationMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)c;
        this.popupPanel = (JPopupPanel)c;
        this.applicationMenuPopupPanel.setLayout(new BorderLayout());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.applicationMenuPopupPanel = null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.mainPanel = new JPanel(new BorderLayout());
        this.panelLevel1 = new JPanel();
        this.panelLevel1.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int height = 0;
                int width = 0;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Dimension pref = parent.getComponent(i).getPreferredSize();
                    height += pref.height;
                    width = Math.max(width, pref.width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets ins = parent.getInsets();
                int topY = ins.top;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension pref = comp.getPreferredSize();
                    comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, pref.height);
                    topY += pref.height;
                }
            }
        });
        RibbonApplicationMenu ribbonAppMenu = this.applicationMenuPopupPanel.getRibbonAppMenu();
        if (ribbonAppMenu != null) {
            List<List<RibbonApplicationMenuPrimaryCommand>> primaryEntries = ribbonAppMenu.getPrimaryCommands();
            int primaryGroupCount = primaryEntries.size();
            for (int i = 0; i < primaryGroupCount; ++i) {
                for (RibbonApplicationMenuPrimaryCommand menuEntry : primaryEntries.get(i)) {
                    final JCommandMenuButton commandButton = (JCommandMenuButton)menuEntry.buildMenuButton();
                    if (menuEntry.getSecondaryGroupCount() == 0) {
                        commandButton.addRolloverActionListener(e -> {
                            RibbonApplicationMenuPrimaryCommand.PrimaryRolloverCallback callback = menuEntry.getRolloverCallback();
                            if (callback != null) {
                                callback.menuEntryActivated(this.panelLevel2);
                            } else {
                                RibbonApplicationMenuPrimaryCommand.PrimaryRolloverCallback defaultCallback = ribbonAppMenu.getDefaultCallback();
                                if (defaultCallback != null) {
                                    defaultCallback.menuEntryActivated(this.panelLevel2);
                                } else {
                                    this.panelLevel2.removeAll();
                                    this.panelLevel2.revalidate();
                                    this.panelLevel2.repaint();
                                }
                            }
                            this.panelScrollerLevel2.applyComponentOrientation(this.applicationMenuPopupPanel.getComponentOrientation());
                        });
                    } else {
                        RibbonApplicationMenuPrimaryCommand.PrimaryRolloverCallback coreCallback = targetPanel -> {
                            targetPanel.removeAll();
                            targetPanel.setLayout(new BorderLayout());
                            JRibbonApplicationMenuPopupPanelSecondary secondary = new JRibbonApplicationMenuPopupPanelSecondary(menuEntry){

                                @Override
                                public void removeNotify() {
                                    super.removeNotify();
                                    commandButton.getPopupModel().setPopupShowing(false);
                                }
                            };
                            secondary.applyComponentOrientation(this.applicationMenuPopupPanel.getComponentOrientation());
                            targetPanel.add((Component)secondary, "Center");
                        };
                        commandButton.addRolloverActionListener(e -> {
                            coreCallback.menuEntryActivated(this.panelLevel2);
                            commandButton.getPopupModel().setPopupShowing(true);
                        });
                    }
                    commandButton.setDisplayState(MENU_TILE_LEVEL_1);
                    commandButton.setHorizontalAlignment(10);
                    commandButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                    commandButton.setEnabled(menuEntry.isEnabled());
                    this.panelLevel1.add(commandButton);
                }
                if (i >= primaryGroupCount - 1) continue;
                this.panelLevel1.add(new JPopupMenu.Separator());
            }
        }
        this.mainPanel.add((Component)this.panelLevel1, "Before");
        this.panelLevel2 = new JPanel();
        this.panelScrollerLevel2 = new JScrollablePanel<JPanel>(this.panelLevel2, JScrollablePanel.ScrollType.VERTICALLY);
        this.panelScrollerLevel2.setPreferredSize(new Dimension(30 * this.panelLevel1.getFont().getSize() - 30, 10));
        this.mainPanel.add(this.panelScrollerLevel2, "Center");
        if (ribbonAppMenu != null && ribbonAppMenu.getDefaultCallback() != null) {
            ribbonAppMenu.getDefaultCallback().menuEntryActivated(this.panelLevel2);
        }
        this.applicationMenuPopupPanel.add((Component)this.mainPanel, "Center");
        this.footerPanel = new JPanel(new FlowLayout(4)){

            @Override
            protected void paintComponent(Graphics g) {
                SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(null);
                SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(null, (ComponentState)ComponentState.ENABLED);
                fillPainter.paintContourBackground(g, null, (float)BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getWidth(), (float)BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getHeight(), (Shape)new Rectangle(0, 0, BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getWidth(), BasicRibbonApplicationMenuPopupPanelUI.this.footerPanel.getHeight()), false, baseFillScheme, true);
            }
        };
        if (ribbonAppMenu != null) {
            for (FlamingoCommand footerCommand : ribbonAppMenu.getFooterCommands()) {
                JCommandButton commandFooterButton = (JCommandButton)footerCommand.buildButton();
                commandFooterButton.setDisplayState(CommandButtonDisplayState.MEDIUM);
                commandFooterButton.setFlat(false);
                this.footerPanel.add(commandFooterButton);
            }
        }
        this.applicationMenuPopupPanel.add((Component)this.footerPanel, "South");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    public JPanel getPanelLevel1() {
        return this.panelLevel1;
    }

    public JPanel getPanelLevel2() {
        return this.panelLevel2;
    }
}

