/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonGalleryUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.neon.icon.ResizableIcon;

public abstract class BasicRibbonGalleryUI
extends RibbonGalleryUI {
    protected JRibbonGallery ribbonGallery;
    protected int firstVisibleButtonIndex;
    protected int visibleButtonsInEachRow;
    protected int visibleButtonRowNumber;
    protected JCommandButton scrollDownButton;
    protected JCommandButton scrollUpButton;
    protected ExpandCommandButton expandActionButton;
    protected JCommandButtonStrip buttonStrip;
    protected ActionListener scrollDownListener;
    protected ActionListener scrollUpListener;
    protected ActionListener expandListener;
    protected PopupPanelManager.PopupListener popupListener;
    protected PropertyChangeListener propertyChangeListener;
    protected Insets margin;

    @Override
    public void installUI(JComponent c) {
        this.ribbonGallery = (JRibbonGallery)c;
        this.firstVisibleButtonIndex = 0;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    protected void installComponents() {
        this.buttonStrip = new JButtonStripUIResource(JCommandButtonStrip.StripOrientation.VERTICAL);
        this.buttonStrip.setDisplayState(CommandButtonDisplayState.FIT_TO_ICON);
        this.ribbonGallery.add(this.buttonStrip);
        this.scrollUpButton = this.createScrollUpButton();
        this.scrollDownButton = this.createScrollDownButton();
        this.expandActionButton = this.createExpandButton();
        this.syncExpandKeyTip();
        this.buttonStrip.add(this.scrollUpButton);
        this.buttonStrip.add(this.scrollDownButton);
        this.buttonStrip.add(this.expandActionButton);
    }

    protected JCommandButton createScrollDownButton() {
        JCommandButton result = new JCommandButton(null, null);
        result.setFocusable(false);
        result.setName("RibbonGallery.scrollDownButton");
        result.setFlat(false);
        result.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        result.setAutoRepeatAction(true);
        return result;
    }

    protected JCommandButton createScrollUpButton() {
        JCommandButton result = new JCommandButton(null, null);
        result.setFocusable(false);
        result.setName("RibbonGallery.scrollUpButton");
        result.setFlat(false);
        result.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        result.setAutoRepeatAction(true);
        return result;
    }

    protected ExpandCommandButton createExpandButton() {
        ExpandCommandButton result = new ExpandCommandButton(null);
        result.getActionModel().setFireActionOnPress(true);
        result.setFocusable(false);
        result.setName("RibbonGallery.expandButton");
        result.setFlat(false);
        result.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        return result;
    }

    protected void uninstallComponents() {
        this.buttonStrip.remove(this.scrollUpButton);
        this.buttonStrip.remove(this.scrollDownButton);
        this.buttonStrip.remove(this.expandActionButton);
        this.ribbonGallery.remove(this.buttonStrip);
    }

    protected void installDefaults() {
        this.margin = new Insets(3, 3, 3, 3);
        Border b = this.ribbonGallery.getBorder();
        if (b == null || b instanceof UIResource) {
            this.ribbonGallery.setBorder(new BorderUIResource.EmptyBorderUIResource(2, 2, 2, 2));
        }
        this.ribbonGallery.setOpaque(false);
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.scrollDownListener = e -> {
            this.scrollOneRowDown();
            this.ribbonGallery.revalidate();
        };
        this.scrollDownButton.addActionListener(this.scrollDownListener);
        this.scrollUpListener = e -> {
            this.scrollOneRowUp();
            this.ribbonGallery.revalidate();
        };
        this.scrollUpButton.addActionListener(this.scrollUpListener);
        this.expandListener = e -> {
            PopupPanelManager.defaultManager().hidePopups(this.ribbonGallery);
            SwingUtilities.invokeLater(() -> {
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                JCommandButtonPanel popupButtonPanel = this.ribbonGallery.getPopupButtonPanel();
                final Point loc = this.ribbonGallery.getLocationOnScreen();
                final JCommandPopupMenu popupMenu = new JCommandPopupMenu(popupButtonPanel, this.ribbonGallery.getPreferredPopupMaxButtonColumns(), this.ribbonGallery.getPreferredPopupMaxVisibleButtonRows());
                if (this.ribbonGallery.getPopupCallback() != null) {
                    this.ribbonGallery.getPopupCallback().popupToBeShown(popupMenu);
                }
                popupMenu.applyComponentOrientation(this.ribbonGallery.getComponentOrientation());
                popupMenu.setCustomizer(new JPopupPanel.PopupPanelCustomizer(){

                    @Override
                    public Rectangle getScreenBounds() {
                        Rectangle scrBounds = BasicRibbonGalleryUI.this.ribbonGallery.getGraphicsConfiguration().getBounds();
                        boolean ltr = popupMenu.getComponentOrientation().isLeftToRight();
                        Dimension pref = popupMenu.getPreferredSize();
                        int width = Math.max(pref.width, BasicRibbonGalleryUI.this.ribbonGallery.getWidth());
                        int height = pref.height;
                        int x = ltr ? loc.x : loc.x + width - pref.width;
                        int y = loc.y;
                        if (x + width > scrBounds.x + scrBounds.width) {
                            x = scrBounds.x + scrBounds.width - width;
                        }
                        if (y + height > scrBounds.y + scrBounds.height) {
                            y = scrBounds.y + scrBounds.height - height;
                        }
                        return new Rectangle(x, y, width, height);
                    }
                });
                this.ribbonGallery.setShowingPopupPanel(true);
                Dimension pref = popupMenu.getPreferredSize();
                int width = Math.max(pref.width, this.ribbonGallery.getWidth());
                boolean ltr = this.ribbonGallery.getComponentOrientation().isLeftToRight();
                int x = ltr ? loc.x : loc.x + this.ribbonGallery.getWidth() - width;
                Popup popup = popupFactory.getPopup(this.ribbonGallery, popupMenu, x, loc.y);
                this.ribbonGallery.repaint();
                PopupPanelManager.defaultManager().addPopup(this.ribbonGallery, popup, popupMenu);
                if (popupButtonPanel.getSelectedButton() != null) {
                    Rectangle selectionButtonBounds = popupButtonPanel.getSelectedButton().getBounds();
                    popupButtonPanel.scrollRectToVisible(selectionButtonBounds);
                }
            });
        };
        this.expandActionButton.addActionListener(this.expandListener);
        this.popupListener = new PopupPanelManager.PopupListener(){

            @Override
            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getPopupOriginator() == BasicRibbonGalleryUI.this.ribbonGallery) {
                    for (int i = 0; i < BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount(); ++i) {
                        BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i).getActionModel().setRollover(false);
                    }
                    BasicRibbonGalleryUI.this.ribbonGallery.setShowingPopupPanel(false);
                }
            }

            @Override
            public void popupShown(PopupPanelManager.PopupEvent event) {
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
        this.propertyChangeListener = evt -> {
            if ("selectedButton".equals(evt.getPropertyName())) {
                this.scrollToSelected();
                this.ribbonGallery.revalidate();
            }
            if ("expandKeyTip".equals(evt.getPropertyName())) {
                this.syncExpandKeyTip();
            }
            if ("buttonDisplayState".equals(evt.getPropertyName())) {
                this.firstVisibleButtonIndex = 0;
                this.ribbonGallery.revalidate();
            }
        };
        this.ribbonGallery.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.scrollDownButton.removeActionListener(this.scrollDownListener);
        this.scrollDownListener = null;
        this.scrollUpButton.removeActionListener(this.scrollUpListener);
        this.scrollUpListener = null;
        this.expandActionButton.removeActionListener(this.expandListener);
        this.expandListener = null;
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        this.ribbonGallery.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.ribbonGallery = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonGalleryLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintRibbonGalleryBorder(graphics);
        graphics.dispose();
    }

    protected abstract void paintRibbonGalleryBorder(Graphics var1);

    protected int getLayoutGap() {
        return 4;
    }

    public int getPreferredWidth(int buttonCount, int availableHeight) {
        Insets borderInsets = this.ribbonGallery.getInsets();
        int galleryHeight = availableHeight - this.margin.top - this.margin.bottom;
        int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
        int result = this.margin.left;
        CommandButtonDisplayState galleryButtonDisplayState = this.ribbonGallery.getButtonDisplayState();
        if (galleryButtonDisplayState == CommandButtonDisplayState.SMALL) {
            result += buttonCount * buttonHeight / 3;
        }
        if (galleryButtonDisplayState == JRibbonBand.BIG_FIXED) {
            result += buttonCount * buttonHeight;
        }
        if (galleryButtonDisplayState == JRibbonBand.BIG_FIXED_LANDSCAPE) {
            result += buttonCount * buttonHeight * 5 / 4;
        }
        result += (buttonCount + 1) * this.getLayoutGap();
        result += this.getScrollerButtonWidth();
        return result += this.margin.right;
    }

    private int getScrollerButtonWidth() {
        return FlamingoUtilities.getScaledSize(15, this.scrollDownButton.getFont().getSize(), 1.0, 1);
    }

    protected void scrollOneRowDown() {
        this.firstVisibleButtonIndex += this.visibleButtonsInEachRow;
    }

    protected void scrollOneRowUp() {
        this.firstVisibleButtonIndex -= this.visibleButtonsInEachRow;
    }

    protected void scrollToSelected() {
        JCommandToggleButton selected = this.ribbonGallery.getSelectedButton();
        if (selected == null) {
            return;
        }
        int selIndex = -1;
        for (int i = 0; i < this.ribbonGallery.getCommandCount(); ++i) {
            if (this.ribbonGallery.getButtonAt(i) != selected) continue;
            selIndex = i;
            break;
        }
        if (selIndex < 0) {
            return;
        }
        if (selIndex >= this.firstVisibleButtonIndex && selIndex < this.firstVisibleButtonIndex + this.visibleButtonRowNumber * this.visibleButtonsInEachRow) {
            return;
        }
        if (this.visibleButtonsInEachRow <= 0) {
            return;
        }
        do {
            if (selIndex < this.firstVisibleButtonIndex) {
                this.scrollOneRowUp();
                continue;
            }
            this.scrollOneRowDown();
        } while (selIndex < this.firstVisibleButtonIndex || selIndex >= this.firstVisibleButtonIndex + this.visibleButtonRowNumber * this.visibleButtonsInEachRow);
    }

    protected void syncExpandKeyTip() {
        this.expandActionButton.setActionKeyTip(this.ribbonGallery.getExpandKeyTip());
    }

    @KeyTipManager.HasNextKeyTipChain
    protected static class ExpandCommandButton
    extends JCommandButton {
        public ExpandCommandButton(ResizableIcon icon) {
            super(icon);
        }
    }

    private class RibbonGalleryLayout
    implements LayoutManager {
        private RibbonGalleryLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(BasicRibbonGalleryUI.this.ribbonGallery.getPreferredWidth(BasicRibbonGalleryUI.this.ribbonGallery.getDisplayPriority(), c.getHeight()), c.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            Insets borderInsets = BasicRibbonGalleryUI.this.ribbonGallery.getInsets();
            int galleryHeight = height - BasicRibbonGalleryUI.this.margin.top - BasicRibbonGalleryUI.this.margin.bottom;
            int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
            BasicRibbonGalleryUI.this.visibleButtonRowNumber = 1;
            CommandButtonDisplayState galleryButtonDisplayState = BasicRibbonGalleryUI.this.ribbonGallery.getButtonDisplayState();
            if (galleryButtonDisplayState == CommandButtonDisplayState.SMALL) {
                buttonHeight /= 3;
                BasicRibbonGalleryUI.this.visibleButtonRowNumber = 3;
            }
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            int scrollerButtonHeight = galleryHeight / 3;
            int scrollerButtonWidth = BasicRibbonGalleryUI.this.getScrollerButtonWidth();
            int buttonX = ltr ? width - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.right : BasicRibbonGalleryUI.this.margin.left;
            BasicRibbonGalleryUI.this.scrollDownButton.setPreferredSize(new Dimension(scrollerButtonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.scrollUpButton.setPreferredSize(new Dimension(scrollerButtonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.expandActionButton.setPreferredSize(new Dimension(scrollerButtonWidth, galleryHeight - 2 * scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.setBounds(buttonX, BasicRibbonGalleryUI.this.margin.top, scrollerButtonWidth, galleryHeight);
            BasicRibbonGalleryUI.this.buttonStrip.doLayout();
            if (!BasicRibbonGalleryUI.this.ribbonGallery.isShowingPopupPanel()) {
                int neededSpace;
                int availableButtonsSpace;
                int maxButtonWidth = buttonHeight;
                if (galleryButtonDisplayState == JRibbonBand.BIG_FIXED_LANDSCAPE) {
                    maxButtonWidth = maxButtonWidth * 5 / 4;
                }
                for (int i = 0; i < BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount(); ++i) {
                    JCommandToggleButton currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                    currButton.setVisible(false);
                }
                int gap = BasicRibbonGalleryUI.this.getLayoutGap();
                BasicRibbonGalleryUI.this.visibleButtonsInEachRow = 0;
                int n = availableButtonsSpace = ltr ? buttonX - BasicRibbonGalleryUI.this.margin.left : width - buttonX - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.right;
                while (true) {
                    if ((neededSpace = BasicRibbonGalleryUI.this.visibleButtonsInEachRow * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsInEachRow + 1) * gap) > availableButtonsSpace) {
                        --BasicRibbonGalleryUI.this.visibleButtonsInEachRow;
                        break;
                    }
                    ++BasicRibbonGalleryUI.this.visibleButtonsInEachRow;
                }
                neededSpace = BasicRibbonGalleryUI.this.visibleButtonsInEachRow * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsInEachRow + 1) * gap;
                int startX = ltr ? BasicRibbonGalleryUI.this.margin.left + gap : width - BasicRibbonGalleryUI.this.margin.right - gap;
                int availableWidth = ltr ? buttonX - BasicRibbonGalleryUI.this.margin.right : width - buttonX - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.left;
                int toAddToButtonWidth = (availableWidth - neededSpace) / BasicRibbonGalleryUI.this.visibleButtonsInEachRow;
                int lastVisibleButtonIndex = BasicRibbonGalleryUI.this.firstVisibleButtonIndex + BasicRibbonGalleryUI.this.visibleButtonRowNumber * BasicRibbonGalleryUI.this.visibleButtonsInEachRow - 1;
                lastVisibleButtonIndex = Math.min(lastVisibleButtonIndex, BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() - 1);
                int currCountInRow = 0;
                int buttonY = BasicRibbonGalleryUI.this.margin.top + borderInsets.top;
                int singleButtonWidth = maxButtonWidth + toAddToButtonWidth;
                for (int i = BasicRibbonGalleryUI.this.firstVisibleButtonIndex; i <= lastVisibleButtonIndex; ++i) {
                    JCommandToggleButton currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                    currButton.setVisible(true);
                    if (ltr) {
                        currButton.setBounds(startX, buttonY, singleButtonWidth, buttonHeight);
                        startX += singleButtonWidth + gap;
                    } else {
                        currButton.setBounds(startX - singleButtonWidth, buttonY, singleButtonWidth, buttonHeight);
                        startX -= singleButtonWidth + gap;
                    }
                    if (++currCountInRow != BasicRibbonGalleryUI.this.visibleButtonsInEachRow) continue;
                    currCountInRow = 0;
                    startX = ltr ? BasicRibbonGalleryUI.this.margin.left + gap : width - BasicRibbonGalleryUI.this.margin.right - gap;
                    buttonY += buttonHeight;
                }
                if (BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() == 0) {
                    BasicRibbonGalleryUI.this.scrollDownButton.setEnabled(false);
                    BasicRibbonGalleryUI.this.scrollUpButton.setEnabled(false);
                    BasicRibbonGalleryUI.this.expandActionButton.setEnabled(false);
                } else {
                    BasicRibbonGalleryUI.this.scrollDownButton.setEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() - 1).isVisible());
                    BasicRibbonGalleryUI.this.scrollUpButton.setEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(0).isVisible());
                    BasicRibbonGalleryUI.this.expandActionButton.setEnabled(true);
                }
            }
        }
    }

    protected static class JButtonStripUIResource
    extends JCommandButtonStrip
    implements UIResource {
        public JButtonStripUIResource() {
        }

        public JButtonStripUIResource(JCommandButtonStrip.StripOrientation orientation) {
            super(orientation);
        }
    }
}

