/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorPanelUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorPanel;

public abstract class BasicColorSelectorPanelUI
extends ColorSelectorPanelUI {
    protected JColorSelectorPanel colorSelectorPanel;
    protected JLabel captionLabel;
    protected JPanel colorSelectorContainer;

    @Override
    public void installUI(JComponent c) {
        this.colorSelectorPanel = (JColorSelectorPanel)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.colorSelectorPanel = null;
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.captionLabel = new JLabel(this.colorSelectorPanel.getCaption());
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.colorSelectorContainer = this.colorSelectorPanel.getColorSelectionContainer();
        this.colorSelectorPanel.add(this.captionLabel);
        if (this.colorSelectorContainer != null) {
            this.colorSelectorPanel.add(this.colorSelectorContainer);
        }
        this.colorSelectorPanel.setLayout(new PanelLayout());
    }

    protected void uninstallComponents() {
        this.colorSelectorPanel.remove(this.captionLabel);
        if (this.colorSelectorContainer != null) {
            this.colorSelectorPanel.remove(this.colorSelectorContainer);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color bg = this.colorSelectorPanel.getBackground();
        g.setColor(bg);
        int w = c.getWidth();
        int h = c.getHeight();
        g.fillRect(0, 0, w, h);
        Rectangle captionBackground = this.captionLabel.getBounds();
        this.paintCaptionBackground(g, 0, 0, w, captionBackground.height + 2 * this.getLayoutGap());
        if (this.colorSelectorPanel.isLastPanel()) {
            this.paintBottomDivider(g, 0, 0, w, h);
        }
    }

    protected abstract void paintBottomDivider(Graphics var1, int var2, int var3, int var4, int var5);

    protected abstract void paintCaptionBackground(Graphics var1, int var2, int var3, int var4, int var5);

    protected abstract int getLayoutGap();

    protected class PanelLayout
    implements LayoutManager {
        protected PanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(20, 20);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int layoutGap = BasicColorSelectorPanelUI.this.getLayoutGap();
            Dimension labelPrefSize = BasicColorSelectorPanelUI.this.captionLabel.getPreferredSize();
            Dimension contPrefSize = BasicColorSelectorPanelUI.this.colorSelectorContainer.getPreferredSize();
            return new Dimension(Math.max(labelPrefSize.width, contPrefSize.width), 2 * layoutGap + labelPrefSize.height + contPrefSize.height + (BasicColorSelectorPanelUI.this.colorSelectorPanel.isLastPanel() ? 1 : 0));
        }

        @Override
        public void layoutContainer(Container parent) {
            int layoutGap = BasicColorSelectorPanelUI.this.getLayoutGap();
            Dimension labelPrefSize = BasicColorSelectorPanelUI.this.captionLabel.getPreferredSize();
            int labelWidth = labelPrefSize.width;
            int labelHeight = labelPrefSize.height;
            int y = layoutGap;
            if (BasicColorSelectorPanelUI.this.captionLabel.getComponentOrientation().isLeftToRight()) {
                BasicColorSelectorPanelUI.this.captionLabel.setBounds(layoutGap, y, labelWidth, labelHeight);
            } else {
                BasicColorSelectorPanelUI.this.captionLabel.setBounds(parent.getWidth() - layoutGap - labelWidth, y, labelWidth, labelHeight);
            }
            BasicColorSelectorPanelUI.this.colorSelectorContainer.setBounds(0, y, parent.getWidth(), parent.getHeight() - (y += labelHeight + layoutGap) - (BasicColorSelectorPanelUI.this.colorSelectorPanel.isLastPanel() ? 1 : 0));
        }
    }
}

