/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.flamingo.internal.substance.utils.RibbonTaskToggleButtonBackgroundDelegate;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonTaskToggleButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceRibbonTaskToggleButtonUI
extends BasicRibbonTaskToggleButtonUI
implements TransitionAwareUI {
    protected CommandButtonVisualStateTracker substanceVisualStateTracker;
    private PropertyChangeListener substancePropertyChangeListener;
    private RibbonTaskToggleButtonBackgroundDelegate delegate = new RibbonTaskToggleButtonBackgroundDelegate();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonTaskToggleButtonUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.commandButton.setOpaque(false);
        this.commandButton.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 12, 0, 12);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }
        });
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.commandButton, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.GENERAL);
        SubstanceCortex.ComponentOrParentChainScope.setColorizationFactor((JComponent)this.commandButton, (double)0.25);
    }

    @Override
    protected void uninstallComponents() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.commandButton);
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker = new CommandButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyChangeListener = evt -> {
            if ("contextualGroupHueColor".equals(evt.getPropertyName())) {
                Color newValue = (Color)evt.getNewValue();
                this.commandButton.setBackground(newValue);
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.delegate.updateTaskToggleButtonBackground(g, (JRibbonTaskToggleButton)this.commandButton);
        this.paintText(g);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Component)c);
        this.paint(g2d, c);
        g2d.dispose();
    }

    private void paintText(Graphics g) {
        int strWidth;
        FontMetrics fm = g.getFontMetrics();
        String toPaint = this.commandButton.getText();
        int fullInsets = this.commandButton.getInsets().left;
        int pw = this.getPreferredSize((JComponent)this.commandButton).width;
        int mw = this.getMinimumSize((JComponent)this.commandButton).width;
        int w = this.commandButton.getWidth();
        int h = this.commandButton.getHeight();
        int insets = fullInsets - (pw - w) * (fullInsets - 2) / (pw - mw);
        Rectangle textRect = new Rectangle(insets, 1 + (h - fm.getHeight()) / 2, w - 2 * insets, fm.getHeight());
        while (toPaint.length() != 0 && (strWidth = fm.stringWidth(toPaint)) > textRect.width) {
            toPaint = toPaint.substring(0, toPaint.length() - 1);
        }
        int finalStrWidth = fm.stringWidth(toPaint);
        if (finalStrWidth < textRect.width) {
            int delta = textRect.width - finalStrWidth;
            textRect.x += delta / 2;
            textRect.width -= delta;
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.substanceVisualStateTracker.getActionStateTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)currState);
        Color fgColor = SubstanceRibbonTaskToggleButtonUI.getForegroundColor(this.commandButton, modelStateInfo);
        if (buttonAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
            fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
        }
        SubstanceTextUtilities.paintText((Graphics)g, (JComponent)this.commandButton, (Rectangle)textRect, (String)toPaint, (int)-1, (Font)this.commandButton.getFont(), (Color)fgColor, null);
    }

    private static Color getForegroundColor(AbstractCommandButton button, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        boolean isTextOnParentBackground = SubstanceCoreUtilities.getSkin((Component)button).getTabFadeEnd() <= 0.5;
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map activeStates = modelStateInfo.getStateContributionMap();
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)((button.isFlat() || isTextOnParentBackground) && currState == ComponentState.ENABLED ? button.getParent() : button), (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.TAB, (ComponentState)currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)((button.isFlat() || isTextOnParentBackground) && activeState == ComponentState.ENABLED ? button.getParent() : button), (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.TAB, (ComponentState)activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        JButton dummy = new JButton(button.getText(), (Icon)button.getIcon());
        Dimension result = dummy.getUI().getPreferredSize(dummy);
        Insets borderInsets = button.getBorder().getBorderInsets(button);
        result.width += borderInsets.left + borderInsets.right;
        result.height += borderInsets.top + borderInsets.bottom;
        return result;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }
}

