/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.ui.common.BasicScrollablePanelUI;
import org.pushingpixels.neon.icon.NeonIconUIResource;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceScrollablePanelUI
extends BasicScrollablePanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceScrollablePanelUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g, JComponent c) {
        if (!c.isShowing()) {
            return;
        }
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (c.isOpaque()) {
                BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
                super.paint(g, c);
            } else {
                super.paint(g, c);
            }
        }
    }

    @Override
    public JCommandButton createLeadingScroller() {
        JCommandButton result = super.createLeadingScroller();
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)result);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(result, () -> ((ActionPopupTransitionAwareUI)((Object)result.getUI())).getActionTransitionTracker(), (scheme, width, height) -> {
            NeonIconUIResource doubleArrowIcon = SubstanceImageCreator.getDoubleArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 7 : 1), (SubstanceColorScheme)scheme);
            return doubleArrowIcon;
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        result.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)result, this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(SubstanceSlices.Side.RIGHT) : EnumSet.of(SubstanceSlices.Side.BOTTOM));
        result.setHorizontalAlignment(0);
        result.setFlat(true);
        return result;
    }

    @Override
    public JCommandButton createTrailingScroller() {
        JCommandButton result = super.createTrailingScroller();
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)result);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(result, () -> ((ActionPopupTransitionAwareUI)((Object)result.getUI())).getActionTransitionTracker(), (scheme, width, height) -> {
            NeonIconUIResource doubleArrowIcon = SubstanceImageCreator.getDoubleArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 3 : 5), (SubstanceColorScheme)scheme);
            return doubleArrowIcon;
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        result.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)result, this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(SubstanceSlices.Side.LEFT) : EnumSet.of(SubstanceSlices.Side.TOP));
        result.setHorizontalAlignment(0);
        result.setFlat(true);
        return result;
    }
}

