/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandButtonUI;
import org.pushingpixels.flamingo.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceCommandMenuButtonUI
extends SubstanceCommandButtonUI {
    protected MouseListener rolloverMenuMouseListener;

    public static ComponentUI createUI(JComponent c) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)c);
        SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)c, EnumSet.allOf(SubstanceSlices.Side.class));
        return new SubstanceCommandMenuButtonUI((JCommandMenuButton)c);
    }

    public SubstanceCommandMenuButtonUI(JCommandMenuButton button) {
        super(button);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.rolloverMenuMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SubstanceCommandMenuButtonUI.this.commandButton.isEnabled()) {
                    int modifiers = 0;
                    AWTEvent currentEvent = EventQueue.getCurrentEvent();
                    if (currentEvent instanceof InputEvent) {
                        modifiers = ((InputEvent)currentEvent).getModifiers();
                    } else if (currentEvent instanceof ActionEvent) {
                        modifiers = ((ActionEvent)currentEvent).getModifiers();
                    }
                    SubstanceCommandMenuButtonUI.this.fireRolloverActionPerformed(new ActionEvent(this, 1001, SubstanceCommandMenuButtonUI.this.commandButton.getActionModel().getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                    SubstanceCommandMenuButtonUI.this.processPopupAction();
                }
            }
        };
        this.commandButton.addMouseListener(this.rolloverMenuMouseListener);
    }

    @Override
    protected void uninstallListeners() {
        this.commandButton.removeMouseListener(this.rolloverMenuMouseListener);
        this.rolloverMenuMouseListener = null;
        super.uninstallListeners();
    }

    protected void fireRolloverActionPerformed(ActionEvent e) {
        RolloverActionListener[] listeners = (RolloverActionListener[])this.commandButton.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(e);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        JCommandMenuButton menuButton = (JCommandMenuButton)c;
        KeyTipRenderingUtilities.renderMenuButtonKeyTips(g, menuButton, this.layoutManager);
    }
}

