/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.flamingo.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.neon.AsynchronousLoadListener;
import org.pushingpixels.neon.AsynchronousLoading;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class JRibbonFrame
extends JFrame {
    private JRibbon ribbon;
    private boolean wasSetIconImagesCalled;

    public JRibbonFrame() throws HeadlessException {
        this.initRibbon();
    }

    public JRibbonFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initRibbon();
    }

    public JRibbonFrame(String title) throws HeadlessException {
        super(title);
        this.initRibbon();
    }

    public JRibbonFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initRibbon();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        LayoutManager currManager;
        if (manager.getClass() != RibbonFrameLayout.class && (currManager = this.getLayout()) != null) {
            throw new IllegalArgumentException("Can't set a custom layout manager on JRibbonFrame");
        }
        super.setLayout(manager);
    }

    @Override
    public void setJMenuBar(JMenuBar menubar) {
        throw new IllegalArgumentException("Can't set a menu bar on JRibbonFrame");
    }

    @Override
    public void setContentPane(Container contentPane) {
        throw new IllegalArgumentException("Can't set the content pane on JRibbonFrame");
    }

    private void initRibbon() {
        this.setLayout(new RibbonFrameLayout());
        this.ribbon = new JRibbon(this);
        this.add((Component)this.ribbon, "North");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private boolean prevAltModif = false;

            @Override
            public void eventDispatched(AWTEvent event) {
                Component c;
                Object src = event.getSource();
                if (src instanceof Component && ((c = (Component)src) == JRibbonFrame.this || SwingUtilities.getWindowAncestor(c) == JRibbonFrame.this)) {
                    if (event instanceof KeyEvent) {
                        KeyEvent keyEvent = (KeyEvent)event;
                        switch (keyEvent.getID()) {
                            case 401: {
                                break;
                            }
                            case 402: {
                                boolean wasAltModif = this.prevAltModif;
                                boolean bl = this.prevAltModif = keyEvent.getModifiersEx() == 512;
                                if (wasAltModif && keyEvent.getKeyCode() == 18) break;
                                char keyChar = keyEvent.getKeyChar();
                                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                                    KeyTipManager.defaultManager().handleKeyPress(keyChar);
                                }
                                if (keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 121) {
                                    if (keyEvent.getModifiers() != 0 || keyEvent.getModifiersEx() != 0) break;
                                    boolean hadPopups = !PopupPanelManager.defaultManager().getShownPath().isEmpty();
                                    PopupPanelManager.defaultManager().hidePopups(null);
                                    if (hadPopups || KeyTipManager.defaultManager().isShowingKeyTips()) {
                                        KeyTipManager.defaultManager().hideAllKeyTips();
                                    } else {
                                        KeyTipManager.defaultManager().showRootKeyTipChain(JRibbonFrame.this);
                                    }
                                }
                                if (keyEvent.getKeyCode() != 27) break;
                                KeyTipManager.defaultManager().showPreviousChain();
                            }
                        }
                    }
                    if (event instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)event;
                        switch (mouseEvent.getID()) {
                            case 500: 
                            case 501: 
                            case 502: 
                            case 506: {
                                KeyTipManager.defaultManager().hideAllKeyTips();
                            }
                        }
                    }
                }
            }
        }, 24L);
        final KeyTipLayer keyTipLayer = new KeyTipLayer();
        JRootPane rootPane = this.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        final LayoutManager currLM = rootPane.getLayout();
        rootPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                currLM.addLayoutComponent(name, comp);
            }

            @Override
            public void layoutContainer(Container parent) {
                currLM.layoutContainer(parent);
                JRibbonFrame ribbonFrame = JRibbonFrame.this;
                if (ribbonFrame.getRootPane().getWindowDecorationStyle() != 0) {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getBounds());
                } else {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getContentPane().getBounds());
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return currLM.minimumLayoutSize(parent);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return currLM.preferredLayoutSize(parent);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                currLM.removeLayoutComponent(comp);
            }
        });
        layeredPane.add((Component)keyTipLayer, (Object)(JLayeredPane.DEFAULT_LAYER + 60));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                KeyTipManager keyTipManager = KeyTipManager.defaultManager();
                if (keyTipManager.isShowingKeyTips()) {
                    keyTipManager.hideAllKeyTips();
                }
            }
        });
        KeyTipManager.defaultManager().addKeyTipListener(new KeyTipManager.KeyTipListener(){

            @Override
            public void keyTipsHidden(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(false);
                }
            }

            @Override
            public void keyTipsShown(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(true);
                }
            }
        });
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        super.setIconImages(Arrays.asList(SubstanceCoreUtilities.getBlankImage((int)16, (int)16)));
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }

    @Override
    protected JRootPane createRootPane() {
        JRibbonRootPane rp = new JRibbonRootPane();
        rp.setOpaque(true);
        return rp;
    }

    @Override
    public synchronized void setIconImages(List<? extends Image> icons) {
        super.setIconImages(icons);
        this.wasSetIconImagesCalled = true;
    }

    public synchronized void setApplicationIcon(ResizableIcon icon) {
        new Thread(() -> {
            AsynchronousLoading async;
            if (icon instanceof AsynchronousLoading && (async = (AsynchronousLoading)icon).isLoading()) {
                CountDownLatch latch = new CountDownLatch(1);
                boolean[] status = new boolean[1];
                AsynchronousLoadListener all = success -> {
                    status[0] = success;
                    latch.countDown();
                };
                async.addAsynchronousLoadListener(all);
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                async.removeAsynchronousLoadListener(all);
            }
            this.setApplicationAndMenuButtonIcon(icon);
        }).start();
    }

    private void setApplicationAndMenuButtonIcon(ResizableIcon icon) {
        if (NeonCortex.getPlatform() == NeonCortex.Platform.MACOS) {
            Image image16 = JRibbonFrame.getImage(icon, 16);
            Image image128 = JRibbonFrame.getImage(icon, 128);
            SwingUtilities.invokeLater(() -> {
                if (image16 != null) {
                    this.setLegacyIconImages(Arrays.asList(image16));
                }
                if (image128 != null) {
                    try {
                        Class<?> appClass = Class.forName("com.apple.eawt.Application");
                        if (appClass != null) {
                            Object appInstance = appClass.newInstance();
                            Method setDockImageMethod = appClass.getDeclaredMethod("setDockIconImage", Image.class);
                            if (setDockImageMethod != null) {
                                setDockImageMethod.invoke(appInstance, image128);
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        } else {
            Image icon64;
            Image icon32;
            ArrayList<Image> images = new ArrayList<Image>();
            Image icon16 = JRibbonFrame.getImage(icon, 16);
            if (icon16 != null) {
                images.add(icon16);
            }
            if ((icon32 = JRibbonFrame.getImage(icon, 32)) != null) {
                images.add(icon32);
            }
            if ((icon64 = JRibbonFrame.getImage(icon, 64)) != null) {
                images.add(icon64);
            }
            SwingUtilities.invokeLater(() -> {
                if (!images.isEmpty()) {
                    this.setLegacyIconImages(images);
                }
            });
        }
    }

    private void setLegacyIconImages(List<Image> images) {
        if (this.wasSetIconImagesCalled) {
            return;
        }
        super.setIconImages(images);
    }

    private static Image getImage(ResizableIcon icon, int size) {
        AsynchronousLoading async;
        icon.setDimension(new Dimension(size, size));
        if (icon instanceof AsynchronousLoading && (async = (AsynchronousLoading)icon).isLoading()) {
            CountDownLatch latch = new CountDownLatch(1);
            boolean[] status = new boolean[1];
            AsynchronousLoadListener all = success -> {
                status[0] = success;
                latch.countDown();
            };
            async.addAsynchronousLoadListener(all);
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            async.removeAsynchronousLoadListener(all);
            if (!status[0]) {
                return null;
            }
            if (async.isLoading()) {
                return null;
            }
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)size, (int)size);
        Graphics2D g2d = (Graphics2D)((Image)result).getGraphics().create();
        icon.paintIcon(null, (Graphics)g2d, 0, 0);
        g2d.dispose();
        return result;
    }

    public boolean isShowingKeyTips() {
        return KeyTipManager.defaultManager().isShowingKeyTips();
    }

    private class KeyTipLayer
    extends JComponent {
        public KeyTipLayer() {
            this.setOpaque(false);
            try {
                Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
                Method mSetComponentMixing = awtUtilitiesClass.getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
                mSetComponentMixing.invoke(null, this, new Rectangle());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener l) {
        }

        @Override
        public synchronized void addKeyListener(KeyListener l) {
        }

        @Override
        protected void paintComponent(Graphics g) {
            JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(this);
            if (!ribbonFrame.isShowingKeyTips()) {
                return;
            }
            if (!ribbonFrame.isActive()) {
                return;
            }
            Collection<KeyTipManager.KeyTipLink> keyTips = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
            if (keyTips != null) {
                Graphics2D g2d = (Graphics2D)g.create();
                NeonCortex.installDesktopHints((Graphics2D)g2d, (Component)this);
                for (KeyTipManager.KeyTipLink keyTip : keyTips) {
                    if (SwingUtilities.getAncestorOfClass(JPopupPanel.class, keyTip.comp) != null) continue;
                    Rectangle compBounds = keyTip.comp.getBounds();
                    if (!keyTip.comp.isShowing() || compBounds.getWidth() == 0.0 || compBounds.getHeight() == 0.0) continue;
                    Dimension pref = KeyTipRenderingUtilities.getPrefSize(g2d.getFontMetrics(), keyTip.keyTipString);
                    Point prefCenter = keyTip.prefAnchorPoint;
                    Point loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, this);
                    Container bandControlPanel = SwingUtilities.getAncestorOfClass(AbstractBandControlPanel.class, keyTip.comp);
                    if (bandControlPanel != null) {
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.topRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = 0;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.midRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight() / 2;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.bottomRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight();
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                    }
                    KeyTipRenderingUtilities.renderKeyTip(g2d, this, new Rectangle(loc.x - pref.width / 2, loc.y - pref.height / 2, pref.width, pref.height), keyTip.keyTipString, keyTip.enabled);
                }
                g2d.dispose();
            }
        }

        private boolean hasClientPropertySetToTrue(Component c, String clientPropName) {
            while (c != null) {
                JComponent jc;
                if (c instanceof JComponent && Boolean.TRUE.equals((jc = (JComponent)c).getClientProperty(clientPropName))) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        @Override
        public boolean contains(int x, int y) {
            return false;
        }
    }

    private class RibbonFrameLayout
    extends BorderLayout {
        private RibbonFrameLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints != null && constraints.equals("North")) {
                if (this.getLayoutComponent("North") != null) {
                    throw new IllegalArgumentException("Already has a NORTH JRibbon component");
                }
                if (!(comp instanceof JRibbon)) {
                    throw new IllegalArgumentException("Can't add non-JRibbon component to NORTH location");
                }
            }
            super.addLayoutComponent(comp, constraints);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp instanceof JRibbon) {
                throw new IllegalArgumentException("Can't remove JRibbon component");
            }
            super.removeLayoutComponent(comp);
        }
    }
}

