/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.HorizontalAlignment;
import org.pushingpixels.flamingo.api.common.RichToolTipManager;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceRibbonComponentUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonComponentUI;
import org.pushingpixels.neon.icon.ResizableIcon;

public class JRibbonComponent
extends RichToolTipManager.JTrackableComponent {
    private ResizableIcon icon;
    private String caption;
    private JComponent mainComponent;
    private boolean isSimpleWrapper;
    private String keyTip;
    private RichTooltip richTooltip;
    private HorizontalAlignment horizontalAlignment;
    private RibbonElementPriority displayPriority;
    private boolean isResizingAware;
    public static final String uiClassID = "RibbonComponentUI";

    public JRibbonComponent(JComponent mainComponent) {
        if (mainComponent == null) {
            throw new IllegalArgumentException("All parameters must be non-null");
        }
        this.mainComponent = mainComponent;
        this.isSimpleWrapper = true;
        this.horizontalAlignment = HorizontalAlignment.LEADING;
        this.isResizingAware = false;
        this.displayPriority = RibbonElementPriority.TOP;
        this.updateUI();
    }

    public JRibbonComponent(ResizableIcon icon, String caption, JComponent mainComponent) {
        if (caption == null) {
            throw new IllegalArgumentException("Caption must be non-null");
        }
        if (mainComponent == null) {
            throw new IllegalArgumentException("Main component must be non-null");
        }
        this.icon = icon;
        this.caption = caption;
        this.mainComponent = mainComponent;
        this.isSimpleWrapper = false;
        this.horizontalAlignment = HorizontalAlignment.TRAILING;
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceRibbonComponentUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public RibbonComponentUI getUI() {
        return (RibbonComponentUI)this.ui;
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        if (this.isSimpleWrapper) {
            throw new IllegalArgumentException("Cannot set caption on a simple component");
        }
        if (caption == null) {
            throw new IllegalArgumentException("Caption must be non-null");
        }
        String old = this.caption;
        this.caption = caption;
        this.firePropertyChange("caption", old, this.caption);
    }

    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public boolean isSimpleWrapper() {
        return this.isSimpleWrapper;
    }

    public String getKeyTip() {
        return this.keyTip;
    }

    public void setKeyTip(String keyTip) {
        String old = this.keyTip;
        this.keyTip = keyTip;
        this.firePropertyChange("keyTip", old, this.keyTip);
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.richTooltip;
    }

    public void setRichTooltip(RichTooltip richTooltip) {
        this.richTooltip = richTooltip;
        RichToolTipManager richToolTipManager = RichToolTipManager.sharedInstance();
        if (richTooltip != null) {
            richToolTipManager.registerComponent(this);
        } else {
            richToolTipManager.unregisterComponent(this);
        }
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public RibbonElementPriority getDisplayPriority() {
        return this.displayPriority;
    }

    public void setDisplayPriority(RibbonElementPriority displayPriority) {
        RibbonElementPriority old = this.displayPriority;
        this.displayPriority = displayPriority;
        if (old != displayPriority) {
            this.firePropertyChange("displayPriority", (Object)old, (Object)this.displayPriority);
        }
    }

    public boolean isResizingAware() {
        return this.isResizingAware;
    }

    public void setResizingAware(boolean isResizingAware) {
        this.isResizingAware = isResizingAware;
    }
}

