/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.layout;

import java.awt.Container;
import java.awt.LayoutManager;
import org.pushingpixels.flamingo.api.layout.TransitionLayout;

public class TransitionLayoutManager {
    private static TransitionLayoutManager instance;

    private TransitionLayoutManager() {
    }

    public static synchronized TransitionLayoutManager getInstance() {
        if (instance == null) {
            instance = new TransitionLayoutManager();
        }
        return instance;
    }

    public void track(Container container, boolean doImmediateRepaint) {
        LayoutManager currLayout = container.getLayout();
        if (currLayout instanceof TransitionLayout) {
            return;
        }
        TransitionLayout layout = new TransitionLayout(container, container.getLayout());
        layout.setDoImmediateRepaint(doImmediateRepaint);
        container.setLayout(layout);
    }

    public void untrack(Container container) {
        LayoutManager layout = container.getLayout();
        if (layout instanceof TransitionLayout) {
            TransitionLayout tLayout = (TransitionLayout)layout;
            container.setLayout(tLayout.getDelegate());
        }
    }
}

