/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandButtonPanelUI;

public class JCommandButtonPanel
extends JPanel
implements Scrollable {
    public static final String uiClassID = "CommandButtonPanelUI";
    protected List<String> groupTitles;
    protected List<List<AbstractCommandButton>> buttons = new ArrayList<List<AbstractCommandButton>>();
    protected int maxButtonColumns = -1;
    protected int maxButtonRows = -1;
    protected boolean isSingleSelectionMode = false;
    protected boolean toShowGroupLabels = true;
    protected CommandToggleButtonGroup buttonGroup;
    protected int currDimension;
    protected CommandButtonDisplayState currState;
    protected LayoutKind layoutKind;

    protected JCommandButtonPanel() {
        this.groupTitles = new ArrayList<String>();
        this.setLayoutKind(LayoutKind.ROW_FILL);
    }

    public JCommandButtonPanel(int startingDimension) {
        this();
        this.currDimension = startingDimension;
        this.currState = CommandButtonDisplayState.FIT_TO_ICON;
        this.updateUI();
    }

    public JCommandButtonPanel(CommandButtonDisplayState startingState) {
        this();
        this.currDimension = -1;
        this.currState = startingState;
        this.updateUI();
    }

    public void addButtonGroup(String buttonGroupName, int groupIndex) {
        this.groupTitles.add(groupIndex, buttonGroupName);
        ArrayList list = new ArrayList();
        this.buttons.add(groupIndex, list);
        this.fireStateChanged();
    }

    public void addButtonGroup(String buttonGroupName) {
        this.addButtonGroup(buttonGroupName, this.groupTitles.size());
    }

    public void removeButtonGroup(String buttonGroupName) {
        int groupIndex = this.groupTitles.indexOf(buttonGroupName);
        if (groupIndex < 0) {
            return;
        }
        this.groupTitles.remove(groupIndex);
        List<AbstractCommandButton> list = this.buttons.get(groupIndex);
        if (list != null) {
            for (AbstractCommandButton button : list) {
                this.remove(button);
                if (!this.isSingleSelectionMode || !(button instanceof JCommandToggleButton)) continue;
                this.buttonGroup.remove((JCommandToggleButton)button);
            }
        }
        this.buttons.remove(groupIndex);
        this.fireStateChanged();
    }

    public int addButtonToLastGroup(AbstractCommandButton commandButton) {
        if (this.groupTitles.size() == 0) {
            return -1;
        }
        int groupIndex = this.groupTitles.size() - 1;
        return this.addButtonToGroup(this.groupTitles.get(groupIndex), this.buttons.get(groupIndex).size(), commandButton);
    }

    public int addButtonToGroup(String buttonGroupName, AbstractCommandButton commandButton) {
        int groupIndex = this.groupTitles.indexOf(buttonGroupName);
        if (groupIndex < 0) {
            return -1;
        }
        return this.addButtonToGroup(buttonGroupName, this.buttons.get(groupIndex).size(), commandButton);
    }

    public int addButtonToGroup(String buttonGroupName, int indexInGroup, AbstractCommandButton commandButton) {
        int groupIndex = this.groupTitles.indexOf(buttonGroupName);
        if (groupIndex < 0) {
            return -1;
        }
        commandButton.updateCustomDimension(this.currDimension);
        commandButton.setDisplayState(this.currState);
        this.add(commandButton);
        this.buttons.get(groupIndex).add(indexInGroup, commandButton);
        if (this.isSingleSelectionMode && commandButton instanceof JCommandToggleButton) {
            this.buttonGroup.add((JCommandToggleButton)commandButton);
        }
        this.fireStateChanged();
        return indexInGroup;
    }

    public void removeButtonFromGroup(String buttonGroupName, int indexInGroup) {
        int groupIndex = this.groupTitles.indexOf(buttonGroupName);
        if (groupIndex < 0) {
            return;
        }
        AbstractCommandButton removed = this.buttons.get(groupIndex).remove(indexInGroup);
        this.remove(removed);
        if (this.isSingleSelectionMode && removed instanceof JCommandToggleButton) {
            this.buttonGroup.remove((JCommandToggleButton)removed);
        }
        this.fireStateChanged();
    }

    public void removeAllGroups() {
        for (List<AbstractCommandButton> ljcb : this.buttons) {
            for (AbstractCommandButton jcb : ljcb) {
                if (this.isSingleSelectionMode && jcb instanceof JCommandToggleButton) {
                    this.buttonGroup.remove((JCommandToggleButton)jcb);
                }
                this.remove(jcb);
            }
        }
        this.buttons.clear();
        this.groupTitles.clear();
        this.fireStateChanged();
    }

    public int getGroupCount() {
        if (this.groupTitles == null) {
            return 0;
        }
        return this.groupTitles.size();
    }

    public int getButtonCount() {
        int result = 0;
        for (List<AbstractCommandButton> ljcb : this.buttons) {
            result += ljcb.size();
        }
        return result;
    }

    public String getGroupTitleAt(int index) {
        return this.groupTitles.get(index);
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandButtonPanelUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setMaxButtonColumns(int maxButtonColumns) {
        if (maxButtonColumns != this.maxButtonColumns) {
            int oldValue = this.maxButtonColumns;
            this.maxButtonColumns = maxButtonColumns;
            this.firePropertyChange("maxButtonColumns", oldValue, this.maxButtonColumns);
        }
    }

    public int getMaxButtonColumns() {
        return this.maxButtonColumns;
    }

    public void setMaxButtonRows(int maxButtonRows) {
        if (maxButtonRows != this.maxButtonRows) {
            int oldValue = this.maxButtonRows;
            this.maxButtonRows = maxButtonRows;
            this.firePropertyChange("maxButtonRows", oldValue, this.maxButtonRows);
        }
    }

    public int getMaxButtonRows() {
        return this.maxButtonRows;
    }

    public List<AbstractCommandButton> getGroupButtons(int groupIndex) {
        return Collections.unmodifiableList(this.buttons.get(groupIndex));
    }

    public void setSingleSelectionMode(boolean isSingleSelectionMode) {
        if (this.isSingleSelectionMode == isSingleSelectionMode) {
            return;
        }
        this.isSingleSelectionMode = isSingleSelectionMode;
        if (this.isSingleSelectionMode) {
            this.buttonGroup = new CommandToggleButtonGroup();
            for (List<AbstractCommandButton> ljrb : this.buttons) {
                for (AbstractCommandButton jrb : ljrb) {
                    if (!(jrb instanceof JCommandToggleButton)) continue;
                    this.buttonGroup.add((JCommandToggleButton)jrb);
                }
            }
        } else {
            for (List<AbstractCommandButton> ljrb : this.buttons) {
                for (AbstractCommandButton jrb : ljrb) {
                    if (!(jrb instanceof JCommandToggleButton)) continue;
                    this.buttonGroup.remove((JCommandToggleButton)jrb);
                }
            }
            this.buttonGroup = null;
        }
    }

    public void setToShowGroupLabels(boolean toShowGroupLabels) {
        if (this.layoutKind == LayoutKind.COLUMN_FILL && toShowGroupLabels) {
            throw new IllegalArgumentException("Column fill layout is not supported when group labels are shown");
        }
        if (this.toShowGroupLabels != toShowGroupLabels) {
            boolean oldValue = this.toShowGroupLabels;
            this.toShowGroupLabels = toShowGroupLabels;
            this.firePropertyChange("toShowGroupLabels", oldValue, this.toShowGroupLabels);
        }
    }

    public boolean isToShowGroupLabels() {
        return this.toShowGroupLabels;
    }

    public void setIconDimension(int dimension) {
        this.currDimension = dimension;
        this.currState = CommandButtonDisplayState.FIT_TO_ICON;
        for (List<AbstractCommandButton> buttonList : this.buttons) {
            for (AbstractCommandButton button : buttonList) {
                button.updateCustomDimension(dimension);
            }
        }
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    public void setIconState(CommandButtonDisplayState state) {
        this.currDimension = -1;
        this.currState = state;
        for (List<AbstractCommandButton> ljrb : this.buttons) {
            for (AbstractCommandButton jrb : ljrb) {
                jrb.setDisplayState(state);
                jrb.revalidate();
                jrb.doLayout();
            }
        }
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    public JCommandToggleButton getSelectedButton() {
        if (this.isSingleSelectionMode) {
            for (List<AbstractCommandButton> ljrb : this.buttons) {
                for (AbstractCommandButton jrb : ljrb) {
                    JCommandToggleButton jctb;
                    if (!(jrb instanceof JCommandToggleButton) || !(jctb = (JCommandToggleButton)jrb).getActionModel().isSelected()) continue;
                    return jctb;
                }
            }
        }
        return null;
    }

    public LayoutKind getLayoutKind() {
        return this.layoutKind;
    }

    public void setLayoutKind(LayoutKind layoutKind) {
        if (layoutKind == null) {
            throw new IllegalArgumentException("Layout kind cannot be null");
        }
        if (layoutKind == LayoutKind.COLUMN_FILL && this.isToShowGroupLabels()) {
            throw new IllegalArgumentException("Column fill layout is not supported when group labels are shown");
        }
        if (layoutKind != this.layoutKind) {
            LayoutKind old = this.layoutKind;
            this.layoutKind = layoutKind;
            this.firePropertyChange("layoutKind", (Object)old, (Object)this.layoutKind);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.layoutKind == LayoutKind.COLUMN_FILL;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.layoutKind == LayoutKind.ROW_FILL;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public static enum LayoutKind {
        ROW_FILL,
        COLUMN_FILL;

    }
}

