/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.StringValuePair;

public class BreadcrumbFileSelector
extends JBreadcrumbBar<File> {
    private boolean useNativeIcons;

    public BreadcrumbFileSelector() {
        this(true);
    }

    public BreadcrumbFileSelector(boolean useNativeIcons) {
        this(FileSystemView.getFileSystemView(), useNativeIcons);
    }

    public BreadcrumbFileSelector(FileSystemView fileSystemView, boolean useNativeIcons) {
        super(null);
        this.model = new BreadcrumbBarModel();
        this.useNativeIcons = useNativeIcons;
        this.callback = new DirCallback(fileSystemView);
        this.callback.setup();
        this.updateUI();
    }

    public void setUseNativeIcons(boolean useNativeIcons) {
        this.useNativeIcons = useNativeIcons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(File dir) {
        FileSystemView fsv;
        FileSystemView fileSystemView = fsv = FileSystemView.getFileSystemView();
        synchronized (fileSystemView) {
            if (dir == null || !dir.isDirectory()) {
                dir = fsv.getHomeDirectory();
            }
            ArrayList path = new ArrayList();
            File parent = dir;
            BreadcrumbItem<File> bci = new BreadcrumbItem<File>(fsv.getSystemDisplayName(dir), dir);
            bci.setIcon(fsv.getSystemIcon(dir));
            path.add(bci);
            while ((parent = fsv.getParentDirectory(parent)) != null) {
                bci = new BreadcrumbItem<File>(fsv.getSystemDisplayName(parent), parent);
                bci.setIcon(fsv.getSystemIcon(parent));
                path.add(bci);
            }
            Collections.reverse(path);
            this.setPath(path);
        }
    }

    private class DirCallback
    extends BreadcrumbBarCallBack<File> {
        private FileSystemView fsv;

        public DirCallback() {
            this(FileSystemView.getFileSystemView());
        }

        public DirCallback(FileSystemView fileSystemView) {
            this.fsv = fileSystemView;
        }

        @Override
        public void setup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StringValuePair<File>> getPathChoices(List<BreadcrumbItem<File>> path) {
            FileSystemView fileSystemView = this.fsv;
            synchronized (fileSystemView) {
                if (path == null) {
                    LinkedList<StringValuePair<File>> bRoots = new LinkedList<StringValuePair<File>>();
                    for (File root : this.fsv.getRoots()) {
                        if (this.fsv.isHiddenFile(root)) continue;
                        String systemName = this.fsv.getSystemDisplayName(root);
                        if (systemName.length() == 0) {
                            systemName = root.getAbsolutePath();
                        }
                        StringValuePair<File> rootPair = new StringValuePair<File>(systemName, root);
                        if (BreadcrumbFileSelector.this.useNativeIcons) {
                            rootPair.set("icon", this.fsv.getSystemIcon(root));
                        }
                        bRoots.add(rootPair);
                    }
                    return bRoots;
                }
                if (path.size() == 0) {
                    return null;
                }
                File lastInPath = path.get(path.size() - 1).getData();
                if (!lastInPath.exists()) {
                    return new ArrayList<StringValuePair<File>>();
                }
                if (!lastInPath.isDirectory()) {
                    return null;
                }
                LinkedList<StringValuePair<File>> lResult = new LinkedList<StringValuePair<File>>();
                for (File child : lastInPath.listFiles()) {
                    if (!child.isDirectory() || this.fsv.isHiddenFile(child)) continue;
                    String childFileName = this.fsv.getSystemDisplayName(child);
                    if (childFileName == null || childFileName.isEmpty()) {
                        childFileName = child.getName();
                    }
                    StringValuePair<File> pair = new StringValuePair<File>(childFileName, child);
                    if (BreadcrumbFileSelector.this.useNativeIcons) {
                        pair.set("icon", this.fsv.getSystemIcon(child));
                    }
                    lResult.add(pair);
                }
                Collections.sort(lResult, new Comparator<StringValuePair<File>>(){

                    @Override
                    public int compare(StringValuePair<File> o1, StringValuePair<File> o2) {
                        String key1 = DirCallback.this.fsv.isFileSystemRoot((File)o1.getValue()) ? ((File)o1.getValue()).getAbsolutePath() : (String)o1.getKey();
                        String key2 = DirCallback.this.fsv.isFileSystemRoot((File)o2.getValue()) ? ((File)o2.getValue()).getAbsolutePath() : (String)o2.getKey();
                        return key1.toLowerCase().compareTo(key2.toLowerCase());
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return super.equals(obj);
                    }
                });
                return lResult;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<StringValuePair<File>> getLeafs(List<BreadcrumbItem<File>> path) {
            FileSystemView fileSystemView = this.fsv;
            synchronized (fileSystemView) {
                if (path == null || path.size() == 0) {
                    return null;
                }
                File lastInPath = path.get(path.size() - 1).getData();
                if (!lastInPath.exists()) {
                    return new ArrayList<StringValuePair<File>>();
                }
                if (!lastInPath.isDirectory()) {
                    return null;
                }
                LinkedList<StringValuePair<File>> lResult = new LinkedList<StringValuePair<File>>();
                for (File child : lastInPath.listFiles()) {
                    if (child.isDirectory() || this.fsv.isHiddenFile(child)) continue;
                    String childFileName = this.fsv.getSystemDisplayName(child);
                    if (childFileName == null || childFileName.isEmpty()) {
                        childFileName = child.getName();
                    }
                    StringValuePair<File> pair = new StringValuePair<File>(childFileName, child);
                    if (BreadcrumbFileSelector.this.useNativeIcons) {
                        pair.set("icon", this.fsv.getSystemIcon(child));
                    }
                    lResult.add(pair);
                }
                Collections.sort(lResult, new Comparator<StringValuePair<File>>(){

                    @Override
                    public int compare(StringValuePair<File> o1, StringValuePair<File> o2) {
                        return ((String)o1.getKey()).toLowerCase().compareTo(((String)o2.getKey()).toLowerCase());
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return super.equals(obj);
                    }
                });
                return lResult;
            }
        }

        @Override
        public InputStream getLeafContent(File leaf) {
            try {
                return new FileInputStream(leaf);
            }
            catch (FileNotFoundException fnfe) {
                return null;
            }
        }
    }
}

