/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;

public class JBandControlPanel
extends AbstractBandControlPanel
implements UIResource {
    private Map<String, JRibbonGallery> galleryNameMap;
    private LinkedList<ControlPanelGroup> controlPanelGroups = new LinkedList();
    public static final List<AbstractCommandButton> EMPTY_GALLERY_BUTTONS_LIST = new LinkedList<AbstractCommandButton>();
    public static final List<JRibbonGallery> EMPTY_RIBBON_GALLERIES_LIST = new LinkedList<JRibbonGallery>();
    public static final String uiClassID = "BandControlPanelUI";

    public JBandControlPanel() {
        this.galleryNameMap = new HashMap<String, JRibbonGallery>();
    }

    public void setUI(BandControlPanelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(new SubstanceBandControlPanelUI());
    }

    @Override
    public BandControlPanelUI getUI() {
        return (BandControlPanelUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized void addCommandButton(AbstractCommandButton ribbonButton, RibbonElementPriority priority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().addCommandButton(ribbonButton, priority);
        super.add(ribbonButton);
    }

    public synchronized void addRibbonGallery(JRibbonGallery ribbonGallery, RibbonElementPriority priority) {
        String galleryName = ribbonGallery.getName();
        if (galleryName == null || galleryName.isEmpty()) {
            throw new IllegalArgumentException("Ribbon gallery name null or empty");
        }
        if (this.galleryNameMap.containsKey(galleryName)) {
            throw new IllegalArgumentException("Another riboon gallery with the same name already exists");
        }
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().addRibbonGallery(ribbonGallery, priority);
        this.galleryNameMap.put(galleryName, ribbonGallery);
        super.add(ribbonGallery);
    }

    public synchronized void setPriority(JCommandButton ribbonButton, RibbonElementPriority newPriority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().setPriority(ribbonButton, newPriority);
    }

    public synchronized void setPriority(JRibbonGallery ribbonGallery, RibbonElementPriority newPriority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().setPriority(ribbonGallery, newPriority);
    }

    public void addRibbonComponent(JRibbonComponent comp) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().addRibbonComponent(comp);
        super.add(comp);
    }

    public List<ControlPanelGroup> getControlPanelGroups() {
        return Collections.unmodifiableList(this.controlPanelGroups);
    }

    public int getControlPanelGroupCount() {
        if (this.controlPanelGroups == null) {
            return 1;
        }
        return this.controlPanelGroups.size();
    }

    public String getControlPanelGroupTitle(int controlPanelGroupIndex) {
        if (this.controlPanelGroups == null) {
            return null;
        }
        return this.controlPanelGroups.get(controlPanelGroupIndex).groupTitle;
    }

    public int startGroup() {
        return this.startGroup(null);
    }

    public int startGroup(String groupTitle) {
        ControlPanelGroup controlPanelGroup = new ControlPanelGroup(groupTitle);
        this.controlPanelGroups.addLast(controlPanelGroup);
        this.fireChanged();
        return this.controlPanelGroups.size() - 1;
    }

    public void setGroupTitle(int groupIndex, String groupTitle) {
        this.controlPanelGroups.get(groupIndex).setGroupTitle(groupTitle);
        this.fireChanged();
    }

    public JRibbonGallery getRibbonGallery(String galleryName) {
        return this.galleryNameMap.get(galleryName);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(ce);
        }
    }

    public List<JRibbonComponent> getRibbonComponents(int groupIndex) {
        return Collections.unmodifiableList(this.controlPanelGroups.get(groupIndex).getRibbonComps());
    }

    public static class ControlPanelGroup {
        private String groupTitle;
        private boolean hasGalleries;
        private int galleryCount;
        private Map<RibbonElementPriority, List<JRibbonGallery>> ribbonGalleries;
        private Map<JRibbonGallery, RibbonElementPriority> ribbonGalleriesPriorities;
        private Map<RibbonElementPriority, List<AbstractCommandButton>> ribbonButtons;
        private Map<AbstractCommandButton, RibbonElementPriority> ribbonButtonsPriorities;
        private List<JRibbonComponent> coreComps;

        public ControlPanelGroup(String groupTitle) {
            this.groupTitle = groupTitle;
            this.ribbonButtons = new HashMap<RibbonElementPriority, List<AbstractCommandButton>>();
            this.ribbonButtonsPriorities = new HashMap<AbstractCommandButton, RibbonElementPriority>();
            this.ribbonGalleries = new HashMap<RibbonElementPriority, List<JRibbonGallery>>();
            this.ribbonGalleriesPriorities = new HashMap<JRibbonGallery, RibbonElementPriority>();
            this.hasGalleries = false;
            this.galleryCount = 0;
            this.coreComps = new ArrayList<JRibbonComponent>();
        }

        public String getGroupTitle() {
            return this.groupTitle;
        }

        public void setGroupTitle(String newTitle) {
            if (this.groupTitle == null && newTitle != null) {
                throw new IllegalArgumentException("Cannot set a title for an unnamed group");
            }
            if (this.groupTitle != null && newTitle == null) {
                throw new IllegalArgumentException("Cannot remove a title from a named group");
            }
            this.groupTitle = newTitle;
        }

        public boolean isCoreContent() {
            return !this.coreComps.isEmpty();
        }

        public synchronized void addCommandButton(AbstractCommandButton ribbonButton, RibbonElementPriority priority) {
            if (this.groupTitle != null) {
                throw new UnsupportedOperationException("Can't add command buttons to ribbon band group with non-null title");
            }
            if (this.isCoreContent()) {
                throw new UnsupportedOperationException("Ribbon band groups do not support mixing JRibbonComponents and custom Flamingo components");
            }
            if (!this.ribbonButtons.containsKey((Object)priority)) {
                this.ribbonButtons.put(priority, new LinkedList());
            }
            List<AbstractCommandButton> al = this.ribbonButtons.get((Object)priority);
            al.add(ribbonButton);
            this.ribbonButtonsPriorities.put(ribbonButton, priority);
            ribbonButton.setDisplayState(CommandButtonDisplayState.BIG);
        }

        public synchronized void addRibbonGallery(JRibbonGallery ribbonGallery, RibbonElementPriority priority) {
            if (this.groupTitle != null) {
                throw new UnsupportedOperationException("Can't add galleries to ribbon band group with non-null title");
            }
            if (this.isCoreContent()) {
                throw new UnsupportedOperationException("Ribbon band groups do not support mixing JRibbonComponents and custom Flamingo components");
            }
            if (!this.ribbonGalleries.containsKey((Object)priority)) {
                this.ribbonGalleries.put(priority, new LinkedList());
            }
            List<JRibbonGallery> al = this.ribbonGalleries.get((Object)priority);
            al.add(ribbonGallery);
            this.ribbonGalleriesPriorities.put(ribbonGallery, priority);
            ribbonGallery.setDisplayPriority(RibbonElementPriority.TOP);
            this.hasGalleries = true;
            ++this.galleryCount;
        }

        public synchronized void setPriority(JCommandButton ribbonButton, RibbonElementPriority newPriority) {
            RibbonElementPriority oldPriority = this.ribbonButtonsPriorities.get(ribbonButton);
            if (newPriority == oldPriority) {
                return;
            }
            this.ribbonButtons.get((Object)oldPriority).remove(ribbonButton);
            if (!this.ribbonButtons.containsKey((Object)newPriority)) {
                this.ribbonButtons.put(newPriority, new ArrayList());
            }
            this.ribbonButtons.get((Object)newPriority).add(ribbonButton);
        }

        public synchronized void setPriority(JRibbonGallery ribbonGallery, RibbonElementPriority newPriority) {
            RibbonElementPriority oldPriority = this.ribbonGalleriesPriorities.get(ribbonGallery);
            if (newPriority == oldPriority) {
                return;
            }
            this.ribbonGalleries.get((Object)oldPriority).remove(ribbonGallery);
            if (!this.ribbonGalleries.containsKey((Object)newPriority)) {
                this.ribbonGalleries.put(newPriority, new ArrayList());
            }
            this.ribbonGalleries.get((Object)newPriority).add(ribbonGallery);
        }

        public void addRibbonComponent(JRibbonComponent comp) {
            if (!this.ribbonButtonsPriorities.isEmpty() || !this.ribbonGalleries.isEmpty()) {
                throw new UnsupportedOperationException("Ribbon band groups do not support mixing JRibbonComponents and custom Flamingo components");
            }
            comp.setOpaque(false);
            this.coreComps.add(comp);
        }

        public List<AbstractCommandButton> getRibbonButtons(RibbonElementPriority priority) {
            List<AbstractCommandButton> result = this.ribbonButtons.get((Object)priority);
            if (result == null) {
                return EMPTY_GALLERY_BUTTONS_LIST;
            }
            return result;
        }

        public List<JRibbonGallery> getRibbonGalleries(RibbonElementPriority priority) {
            List<JRibbonGallery> result = this.ribbonGalleries.get((Object)priority);
            if (result == null) {
                return EMPTY_RIBBON_GALLERIES_LIST;
            }
            return result;
        }

        public boolean hasRibbonGalleries() {
            return this.hasGalleries;
        }

        public int getRibbonGalleriesCount() {
            return this.galleryCount;
        }

        public List<JRibbonComponent> getRibbonComps() {
            return this.coreComps;
        }
    }
}

