/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorComponent;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public abstract class BasicColorSelectorComponentUI
extends ColorSelectorComponentUI {
    protected JColorSelectorComponent colorSelectorComponent;
    protected ButtonModel buttonModel;
    protected MouseListener mouseListener;
    protected ChangeListener modelChangeListener;
    protected ActionListener actionListener;
    protected Timeline rolloverTimeline;
    protected float rollover;

    @Override
    public void installUI(JComponent c) {
        this.colorSelectorComponent = (JColorSelectorComponent)c;
        this.buttonModel = new DefaultButtonModel();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.colorSelectorComponent = null;
    }

    protected void installListeners() {
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!BasicColorSelectorComponentUI.this.buttonModel.isRollover()) {
                    BasicColorSelectorComponentUI.this.colorSelectorComponent.onColorRollover(BasicColorSelectorComponentUI.this.colorSelectorComponent.getColor());
                    BasicColorSelectorComponentUI.this.rolloverTimeline.play();
                }
                BasicColorSelectorComponentUI.this.buttonModel.setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (BasicColorSelectorComponentUI.this.buttonModel.isRollover()) {
                    BasicColorSelectorComponentUI.this.colorSelectorComponent.onColorRollover(null);
                    BasicColorSelectorComponentUI.this.rolloverTimeline.playReverse();
                }
                BasicColorSelectorComponentUI.this.buttonModel.setRollover(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BasicColorSelectorComponentUI.this.buttonModel.setArmed(true);
                BasicColorSelectorComponentUI.this.buttonModel.setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BasicColorSelectorComponentUI.this.buttonModel.setPressed(false);
                BasicColorSelectorComponentUI.this.buttonModel.setArmed(false);
            }
        };
        this.colorSelectorComponent.addMouseListener(this.mouseListener);
        this.modelChangeListener = e -> this.colorSelectorComponent.repaint();
        this.buttonModel.addChangeListener(this.modelChangeListener);
        this.actionListener = e -> {
            this.colorSelectorComponent.onColorSelected(this.colorSelectorComponent.getColor());
            PopupPanelManager.defaultManager().hidePopups(null);
        };
        this.buttonModel.addActionListener(this.actionListener);
    }

    protected void uninstallListeners() {
        this.buttonModel.removeActionListener(this.actionListener);
        this.actionListener = null;
        this.buttonModel.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        this.colorSelectorComponent.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
    }

    protected void installDefaults() {
        this.rolloverTimeline = new Timeline((Object)this);
        this.rolloverTimeline.addPropertyToInterpolate("rollover", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
        this.rolloverTimeline.addCallback((TimelineCallback)new SwingRepaintCallback((Component)this.colorSelectorComponent));
        this.rolloverTimeline.setDuration(150L);
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    public void setRollover(float rollover) {
        this.rollover = rollover;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        int w = this.colorSelectorComponent.getWidth();
        int h = this.colorSelectorComponent.getHeight();
        Graphics2D g2d = (Graphics2D)g.create();
        Color fillColor = this.colorSelectorComponent.getColor();
        g2d.setColor(fillColor);
        g2d.fillRect(0, 0, w, h);
        float[] hsb = new float[3];
        Color.RGBtoHSB(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), hsb);
        float brightness = hsb[2] * 0.7f;
        g2d.setColor(new Color(brightness, brightness, brightness));
        float borderThickness = 1.0f / (float)NeonCortex.getScaleFactor();
        float ty = this.colorSelectorComponent.isTopOpen() ? borderThickness : 0.0f;
        float by = this.colorSelectorComponent.isBottomOpen() ? borderThickness : 0.0f;
        g2d.setStroke(new BasicStroke(borderThickness, 1, 1));
        g2d.draw(new Rectangle2D.Double(0.0, -ty, (float)w - borderThickness, (float)h - borderThickness + ty + by));
        if (this.rollover > 0.0f) {
            this.paintRolloverIndication(g2d);
        }
        g2d.dispose();
    }

    protected abstract void paintRolloverIndication(Graphics var1);
}

