/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.icon.ResizableIcon;

public class CommandButtonLayoutManagerSmall
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize(AbstractCommandButton commandButton) {
        return FlamingoUtilities.getScaledSize(16, commandButton.getFont().getSize(), 1.0, 4);
    }

    @Override
    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        boolean hasIcon = commandButton.getIcon() != null;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        int prefIconSize = hasIcon ? this.getPreferredIconSize(commandButton) : 0;
        int width = borderInsets.left;
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        if (hasPopupIcon) {
            width += 2 * layoutHGap;
            width += 1 + fm.getHeight() / 2;
            width += 2 * layoutHGap;
        }
        if (commandButton instanceof JCommandButton) {
            JCommandButton jcb = (JCommandButton)commandButton;
            JCommandButton.CommandButtonKind buttonKind = jcb.getCommandButtonKind();
            if (hasIcon && buttonKind.hasAction() && buttonKind.hasPopup()) {
                width += new JSeparator((int)1).getPreferredSize().width;
            }
        }
        width += borderInsets.right;
        return new Dimension(width -= 2 * layoutHGap, by + Math.max(prefIconSize, fm.getAscent() + fm.getDescent()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
        Insets ins = commandButton.getInsets();
        int height = commandButton.getHeight();
        ResizableIcon buttonIcon = commandButton.getIcon();
        if (buttonIcon != null) {
            return new Point(ins.left + buttonIcon.getIconWidth(), (height + buttonIcon.getIconHeight()) / 2);
        }
        return new Point(ins.left, 3 * height / 4);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
        ResizableIcon buttonIcon;
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int prefWidth = this.getPreferredSize((AbstractCommandButton)commandButton).width;
        int shiftX = 0;
        if (commandButton.getHorizontalAlignment() == 0 && width > prefWidth) {
            shiftX = (width - prefWidth) / 2;
        }
        boolean hasIcon = (buttonIcon = commandButton.getIcon()) != null;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton instanceof JCommandButton ? ((JCommandButton)commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        if (ltr) {
            int x = ins.left + shiftX - layoutHGap;
            if (hasIcon) {
                int iconHeight = buttonIcon.getIconHeight();
                int iconWidth = buttonIcon.getIconWidth();
                result.iconRect.x = x += layoutHGap;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x += iconWidth + layoutHGap;
            }
            if (hasPopupIcon) {
                result.popupActionRect.x = x += 2 * layoutHGap;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
                x += result.popupActionRect.width;
                x += 2 * layoutHGap;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: 
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.iconRect.x + result.iconRect.width + layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        } else {
            int x = width - ins.right - shiftX + layoutHGap;
            if (hasIcon) {
                int iconHeight = buttonIcon.getIconHeight();
                int iconWidth = buttonIcon.getIconWidth();
                result.iconRect.x = (x -= layoutHGap) - iconWidth;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x -= iconWidth + layoutHGap;
            }
            if (hasPopupIcon) {
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.x = (x -= 2 * layoutHGap) - result.popupActionRect.width;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.height = labelHeight + 2;
                x -= result.popupActionRect.width;
                x -= 2 * layoutHGap;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: 
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.iconRect.x - layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        }
        return result;
    }
}

