/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonStripUI;

public class BasicCommandButtonStripUI
extends CommandButtonStripUI {
    protected JCommandButtonStrip buttonStrip;
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandButtonStripUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.buttonStrip = (JCommandButtonStrip)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.buttonStrip = null;
    }

    protected void installListeners() {
        this.changeListener = e -> {
            if (this.buttonStrip.getButtonCount() == 1) {
                this.buttonStrip.getButton(0).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.ONLY);
            } else {
                this.buttonStrip.getButton(0).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.FIRST);
                for (int i = 1; i < this.buttonStrip.getButtonCount() - 1; ++i) {
                    this.buttonStrip.getButton(i).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE);
                }
                this.buttonStrip.getButton(this.buttonStrip.getButtonCount() - 1).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.LAST);
            }
        };
        this.buttonStrip.addChangeListener(this.changeListener);
    }

    protected void uninstallListeners() {
        this.buttonStrip.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    protected void installDefaults() {
        this.buttonStrip.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.buttonStrip.setLayout(this.createLayoutManager());
    }

    protected void uninstallComponents() {
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonStripLayout();
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private ButtonStripLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int i;
            int width = 0;
            int height = 0;
            if (BasicCommandButtonStripUI.this.buttonStrip.getOrientation() == JCommandButtonStrip.StripOrientation.HORIZONTAL) {
                for (i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    width += BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width;
                    height = Math.max(height, BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height);
                }
            } else {
                for (i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    height += BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height;
                    width = Math.max(width, BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width);
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            if (BasicCommandButtonStripUI.this.buttonStrip.getButtonCount() == 0) {
                return;
            }
            Insets ins = c.getInsets();
            int height = c.getHeight() - ins.top - ins.bottom;
            int width = c.getWidth() - ins.left - ins.right;
            if (BasicCommandButtonStripUI.this.buttonStrip.getOrientation() == JCommandButtonStrip.StripOrientation.HORIZONTAL) {
                int totalPreferredWidth = 0;
                for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredWidth += currButton.getPreferredSize().width;
                }
                int deltaX = (width - totalPreferredWidth) / BasicCommandButtonStripUI.this.buttonStrip.getButtonCount();
                if (BasicCommandButtonStripUI.this.buttonStrip.getComponentOrientation().isLeftToRight()) {
                    int x = ins.left;
                    for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                        AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                        currButton.setBounds(x, ins.top, currButton.getPreferredSize().width + deltaX, height);
                        x += currButton.getPreferredSize().width + deltaX;
                    }
                } else {
                    int x = c.getWidth() - ins.right;
                    for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                        AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                        int buttonWidth = currButton.getPreferredSize().width + deltaX;
                        currButton.setBounds(x - buttonWidth, ins.top, buttonWidth, height);
                        x -= buttonWidth;
                    }
                }
            } else {
                int totalPreferredHeight = 0;
                for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredHeight += currButton.getPreferredSize().height;
                }
                float deltaY = (float)(height - totalPreferredHeight) / (float)BasicCommandButtonStripUI.this.buttonStrip.getButtonCount();
                float y = ins.top;
                for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    float buttonHeight = (float)currButton.getPreferredSize().height + deltaY;
                    currButton.setBounds(ins.left, (int)y, width, (int)Math.ceil(buttonHeight));
                    y += buttonHeight;
                }
            }
        }
    }
}

