/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;

public class SubstanceRibbonFrameTitlePane
extends SubstanceTitlePane {
    protected Map<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> taskComponentMap = new HashMap<RibbonContextualTaskGroup, SubstanceContextualGroupComponent>();
    protected ChangeListener ribbonFrameChangeListener;
    protected TaskbarPanel taskbarPanel = new TaskbarPanel();

    public SubstanceRibbonFrameTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        super(root, ui);
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent((JComponent)this.taskbarPanel, (SubstanceTitlePaneUtilities.ExtraComponentKind)SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING);
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.taskbarPanel, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.HEADER);
        this.add(this.taskbarPanel);
    }

    protected LayoutManager createLayout() {
        return new RibbonFrameTitlePaneLayout();
    }

    public void addNotify() {
        super.addNotify();
        JRibbon ribbon = this.getRibbon();
        this.syncRibbonState();
        this.ribbonFrameChangeListener = e -> this.syncRibbonState();
        ribbon.addChangeListener(this.ribbonFrameChangeListener);
    }

    public void removeNotify() {
        JRibbon ribbon = this.getRibbon();
        for (SubstanceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        ribbon.removeChangeListener(this.ribbonFrameChangeListener);
        this.ribbonFrameChangeListener = null;
        super.removeNotify();
    }

    protected void syncRibbonState() {
        for (SubstanceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        this.taskComponentMap.clear();
        JRibbon ribbon = this.getRibbon();
        for (int i = 0; i < ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup group = ribbon.getContextualTaskGroup(i);
            if (!ribbon.isVisible(group)) continue;
            SubstanceContextualGroupComponent taskGroupComponent = new SubstanceContextualGroupComponent(group);
            taskGroupComponent.applyComponentOrientation(this.getRibbon().getComponentOrientation());
            this.add(taskGroupComponent);
            this.taskComponentMap.put(group, taskGroupComponent);
            SubstanceTitlePaneUtilities.markTitlePaneExtraComponent((JComponent)taskGroupComponent, (SubstanceTitlePaneUtilities.ExtraComponentKind)SubstanceTitlePaneUtilities.ExtraComponentKind.TRAILING);
        }
        this.taskbarPanel.removeAll();
        this.taskbarPanel.setPreferredSize(null);
        for (Component taskbarComp : ribbon.getTaskbarComponents()) {
            this.taskbarPanel.add(taskbarComp);
        }
    }

    private JRibbon getRibbon() {
        JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
        JRibbon ribbon = ribbonFrame.getRibbon();
        return ribbon;
    }

    private int getTaskBarLayoutGap(Container c) {
        return SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)c), (int)1, (int)6, (int)1, (boolean)false);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        if (SubstanceCortex.ComponentScope.getCurrentSkin((Component)((Object)this)).getOverlayPainters(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE).isEmpty()) {
            SubstanceColorScheme compScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)((Object)this), (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.ENABLED);
            Color sepColor = compScheme.isDark() ? SeparatorPainterUtils.getSeparatorShadowColor((SubstanceColorScheme)compScheme) : SeparatorPainterUtils.getSeparatorDarkColor((SubstanceColorScheme)compScheme);
            g2d.setColor(sepColor);
            float separatorThickness = SubstanceSizeUtils.getBorderStrokeWidth();
            float separatorY = (float)this.getHeight() - separatorThickness;
            g2d.setStroke(new BasicStroke(separatorThickness, 0, 1));
            g2d.draw(new Line2D.Double(0.0, separatorY, this.getWidth(), separatorY));
        }
        g2d.dispose();
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            for (Component regComp : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, c.getParent().getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            boolean ltr = SubstanceRibbonFrameTitlePane.this.getComponentOrientation().isLeftToRight();
            int x = ltr ? ins.left : c.getWidth() - ins.right;
            for (Component regComp : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                int pw = regComp.getPreferredSize().width;
                if (ltr) {
                    regComp.setBounds(x, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                    x += pw + gap;
                    continue;
                }
                regComp.setBounds(x - pw, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                x -= pw + gap;
            }
        }
    }

    protected class RibbonFrameTitlePaneLayout
    extends SubstanceTitlePane.TitlePaneLayout {
        protected RibbonFrameTitlePaneLayout() {
            super((SubstanceTitlePane)SubstanceRibbonFrameTitlePane.this);
        }

        public void layoutContainer(Container c) {
            super.layoutContainer(c);
            JRibbon ribbon = SubstanceRibbonFrameTitlePane.this.getRibbon();
            boolean ltr = ribbon.getComponentOrientation().isLeftToRight();
            RibbonUI ribbonUI = ribbon.getUI();
            if (ltr) {
                for (Map.Entry<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> entry : SubstanceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds(entry.getKey());
                    int minTrailingX = c.getWidth();
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        SubstanceTitlePaneUtilities.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (SubstanceTitlePaneUtilities.ExtraComponentKind)((JComponent)child).getClientProperty("substancelaf.internal.titlePane.extraComponentKind")) == SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING || child instanceof SubstanceContextualGroupComponent) continue;
                        minTrailingX = Math.min(child.getX(), minTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    if (taskGroupBounds.x + width > minTrailingX - 5) {
                        width = minTrailingX - 5 - taskGroupBounds.x;
                    }
                    entry.getValue().setBounds(new Rectangle(taskGroupBounds.x, 0, width, c.getHeight()));
                    entry.getValue().setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = SubstanceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                    if (pref.width == 0) {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() + SubstanceRibbonFrameTitlePane.this.menuBar.getWidth(), 0, pref.width, c.getHeight());
                    } else {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() + SubstanceRibbonFrameTitlePane.this.menuBar.getWidth() + 5, 0, pref.width, c.getHeight());
                    }
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.doLayout();
                }
                SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
            } else {
                for (Map.Entry<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> entry : SubstanceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds(entry.getKey());
                    int maxTrailingX = 0;
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        SubstanceTitlePaneUtilities.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (SubstanceTitlePaneUtilities.ExtraComponentKind)((JComponent)child).getClientProperty("substancelaf.internal.titlePane.extraComponentKind")) == SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING || child instanceof SubstanceContextualGroupComponent) continue;
                        maxTrailingX = Math.max(child.getX() + child.getWidth(), maxTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    int x = taskGroupBounds.x;
                    if (taskGroupBounds.x < maxTrailingX + 5) {
                        int diff = maxTrailingX + 5 - taskGroupBounds.x;
                        x += diff;
                        width -= diff;
                    }
                    entry.getValue().setBounds(new Rectangle(x, 0, width, c.getHeight()));
                    entry.getValue().setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = SubstanceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                    if (pref.width == 0) {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX(), 0, pref.width, c.getHeight());
                    } else {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() - 5 - pref.width, 0, pref.width, c.getHeight());
                    }
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.doLayout();
                }
                SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
            }
        }
    }

    private class TaskbarPanel
    extends JPanel {
        public TaskbarPanel() {
            super(new TaskbarLayout());
            this.setOpaque(false);
            int insets = SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this), (int)2, (int)3, (int)1, (boolean)false);
            this.setBorder(new EmptyBorder(2, insets, 2, insets));
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return new Dimension(result.width + result.height / 2, result.height);
        }
    }

    private class SubstanceContextualGroupComponent
    extends JComponent {
        RibbonContextualTaskGroup taskGroup;

        public SubstanceContextualGroupComponent(RibbonContextualTaskGroup taskGroup) {
            this.taskGroup = taskGroup;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Color hueColor = this.taskGroup.getHueColor();
            Graphics2D g2d = (Graphics2D)g.create();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor((Color)hueColor, (int)0), 0.0f, height, SubstanceColorUtilities.getAlphaColor((Color)hueColor, (int)63));
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setColor(hueColor);
            g2d.drawLine(1, height - 1, width, height - 1);
            JRibbon ribbon = SubstanceRibbonFrameTitlePane.this.getRibbon();
            SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin((Component)SubstanceRibbonFrameTitlePane.this.rootPane).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
            FontMetrics fm = this.getFontMetrics(ribbon.getFont());
            int yOffset = (height - fm.getHeight()) / 2;
            NeonCortex.installDesktopHints((Graphics2D)g2d, (Component)this);
            int offset = SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this), (int)5, (int)2, (int)1, (boolean)false);
            if (this.getComponentOrientation().isLeftToRight()) {
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)this, (Rectangle)new Rectangle(offset, yOffset, width, height - yOffset), (String)this.taskGroup.getTitle(), (int)-1, (Font)ribbon.getFont(), (Color)SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)scheme), null);
            } else {
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)this, (Rectangle)new Rectangle(width - offset - g2d.getFontMetrics().stringWidth(this.taskGroup.getTitle()), yOffset, width, height - yOffset), (String)this.taskGroup.getTitle(), (int)-1, (Font)ribbon.getFont(), (Color)SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)scheme), null);
            }
            SeparatorPainterUtils.paintSeparator((Component)ribbon, (Graphics)g2d, (int)2, (int)height, (int)1, (boolean)false, (int)(height / 3), (int)0, (boolean)true);
            g2d.translate(width - 1, 0);
            SeparatorPainterUtils.paintSeparator((Component)ribbon, (Graphics)g2d, (int)2, (int)height, (int)1, (boolean)false, (int)(height / 3), (int)0, (boolean)true);
            g2d.dispose();
        }
    }
}

