/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.internal.substance.common.GlowingResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.flamingo.internal.substance.utils.SubstanceDisabledResizableIcon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandToggleButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.ResizableIconUIResource;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener;

public class SubstanceCommandToggleButtonUI
extends BasicCommandToggleButtonUI
implements ActionPopupTransitionAwareUI {
    protected ButtonBackgroundDelegate backgroundDelegate = new ButtonBackgroundDelegate();
    protected PropertyChangeListener substancePropertyListener;
    private GhostingListener substanceModelChangeListener;
    protected CommandButtonVisualStateTracker substanceVisualStateTracker = new CommandButtonVisualStateTracker();
    protected GlowingResizableIcon glowingIcon;

    public static ComponentUI createUI(JComponent c) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)c);
        return new SubstanceCommandToggleButtonUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentScope.setButtonShaper((JComponent)this.commandButton, (SubstanceButtonShaper)ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            Insets extra = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
            double hgapScaleFactor = this.commandButton.getHGapScaleFactor();
            double vgapScaleFactor = this.commandButton.getVGapScaleFactor();
            int top = 1 + (int)(vgapScaleFactor * (double)extra.top);
            int left = 2 + (int)(hgapScaleFactor * (double)(1 + extra.left));
            int bottom = 0 + (int)(vgapScaleFactor * (double)extra.bottom);
            int right = 2 + (int)(hgapScaleFactor * (double)(1 + extra.right));
            this.commandButton.setBorder(new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyListener = evt -> {
            if ("model".equals(evt.getPropertyName())) {
                if (this.substanceModelChangeListener != null) {
                    this.substanceModelChangeListener.unregisterListeners();
                }
                this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
                this.substanceModelChangeListener.registerListeners();
            }
            if ("icon".equals(evt.getPropertyName())) {
                this.trackGlowingIcon();
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
        this.substanceModelChangeListener.registerListeners();
        this.trackGlowingIcon();
    }

    @Override
    protected void uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceModelChangeListener.unregisterListeners();
        this.substanceModelChangeListener = null;
        super.uninstallListeners();
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        JCommandToggleButton jctb = (JCommandToggleButton)this.commandButton;
        ResizableIcon regular = jctb.getIcon();
        if (this.toUseDisabledIcon() && jctb.getDisabledIcon() != null && regular != null && !regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular = jctb.getDisabledIcon();
        }
        if (iconRect == null || regular == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        if (regular != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            GhostPaintingUtils.paintGhostIcon((Graphics2D)g2d, (Component)jctb, (Icon)regular, (Rectangle)iconRect);
            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)jctb, (Graphics)g));
            CommandButtonBackgroundDelegate.paintCommandButtonIcon(g2d, iconRect, jctb, (Icon)regular, this.glowingIcon, jctb.getActionModel(), this.substanceVisualStateTracker.getActionStateTransitionTracker());
            g2d.dispose();
        }
    }

    @Override
    protected boolean isPaintingBackground() {
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.getActionTransitionTracker().getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected boolean isPaintingSeparators() {
        return false;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(this.commandButton.getFont());
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        this.commandButton.putClientProperty("icon", this.commandButton.getIcon());
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.substanceVisualStateTracker.getActionStateTransitionTracker().getModelStateInfo();
        Color fgColor = this.getForegroundColor(modelStateInfo);
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)mainTextLayoutInfo.textRect, (String)mainTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)fgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            Color disabledFgColor = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED).getForegroundColor();
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
            if (modelStateInfo.getCurrModelState().isDisabled()) {
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)SubstanceColorUtilities.getBackgroundFillColor((Component)c), (double)0.5);
            }
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)extraTextLayoutInfo.textRect, (String)extraTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)disabledFgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect);
        }
        g2d.dispose();
    }

    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)modelStateInfo.getCurrModelState());
            fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)this.commandButton, (String)this.commandButton.getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfo, (float)buttonAlpha);
        }
        return fgColor;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((Component)button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getDisplayState() == CommandButtonDisplayState.MEDIUM && SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, button) == null) {
            JButton dummy = new JButton(button.getText(), (Icon)button.getIcon());
            return shaper.getPreferredSize((AbstractButton)dummy, superPref);
        }
        return superPref;
    }

    protected void trackGlowingIcon() {
        ResizableIcon currIcon = this.commandButton.getIcon();
        if (currIcon instanceof GlowingResizableIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingResizableIcon(currIcon, this.substanceVisualStateTracker.getActionStateTransitionTracker().getIconGlowTracker());
    }

    private void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        if (SubstanceCoreUtilities.isButtonNeverPainted((JComponent)this.commandButton)) {
            return;
        }
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)this.commandButton);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.commandButton);
        boolean ignoreSelections = this.commandButton instanceof JCommandToggleMenuButton;
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(this.commandButton, actionModel, fillPainter, borderPainter, this.commandButton.getWidth(), this.commandButton.getHeight(), this.getActionTransitionTracker(), ignoreSelections);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getActionTransitionTracker().getModelStateInfo();
        Map activeStates = ignoreSelections ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap();
        boolean isFlat = this.commandButton.isFlat();
        boolean isSpecial = isFlat || !this.commandButton.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
            } else {
                ComponentState actionAreaState = ComponentState.getState((ButtonModel)actionModel, (JComponent)this.commandButton);
                if (actionAreaState.isDisabled()) {
                    extraAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)actionAreaState);
                }
            }
        }
        if ((extraAlpha = Math.min(1.0f, extraAlpha)) > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.commandButton, (float)extraAlpha, (Graphics)graphics));
            NeonCortex.drawImage((Graphics)g2d, (Image)fullAlphaBackground, (int)0, (int)0);
            g2d.dispose();
        }
    }

    @Override
    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource && !currDisabledIcon.getClass().isAnnotationPresent(TransitionAware.class)) {
            if (icon != null) {
                this.commandButton.setDisabledIcon(new ResizableIconUIResource(new SubstanceDisabledResizableIcon(icon)));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.substanceVisualStateTracker.getPopupStateTransitionTracker();
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    public boolean isInside(MouseEvent me) {
        return this.getLayoutInfo().actionClickArea.contains(me.getPoint());
    }
}

