/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicCommandPopupMenuUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstanceCommandPopupMenuUI
extends BasicColorSelectorPopupMenuUI {
    private DecorationPainterUtils.PopupInvokerLink popupInvokerLink;

    public static ComponentUI createUI(JComponent c) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)c);
        return new SubstanceCommandPopupMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.popupInvokerLink = () -> ((JCommandPopupMenu)c).getInvoker();
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.popupMenu.putClientProperty("substancelaf.internal.popupInvokerLink", this.popupInvokerLink);
    }

    @Override
    protected void uninstallDefaults() {
        this.popupMenu.putClientProperty("substancelaf.internal.popupInvokerLink", null);
        super.uninstallDefaults();
    }

    @Override
    protected JPanel createMenuPanel() {
        SubstanceMenuPanel result = new SubstanceMenuPanel();
        result.putClientProperty("substancelaf.internal.popupInvokerLink", this.popupInvokerLink);
        return result;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
    }

    @Override
    public int getColorSelectorCellSize() {
        return SubstanceSizeUtils.getComponentFontSize((Component)this.popupPanel);
    }

    @Override
    public int getColorSelectorCellGap() {
        return (int)SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this.popupPanel), (float)4.0f, (int)1, (float)0.25f);
    }

    protected static class SubstanceMenuPanel
    extends BasicCommandPopupMenuUI.MenuPanel {
        protected SubstanceMenuPanel() {
        }

        @Override
        protected void paintIconGutterBackground(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            SubstanceSlices.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
            if (fillKind != SubstanceSlices.MenuGutterFillKind.NONE) {
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this, (ComponentState)ComponentState.ENABLED);
                Color extraLight = SubstanceMenuBackgroundDelegate.getGutterHardFillColor((SubstanceColorScheme)scheme);
                Color ultraLight = SubstanceMenuBackgroundDelegate.getGutterSoftFillColor((SubstanceColorScheme)scheme);
                Color leftColor = fillKind == SubstanceSlices.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.HARD ? ultraLight : extraLight;
                Color rightColor = fillKind == SubstanceSlices.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.SOFT ? ultraLight : extraLight;
                g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this, (float)0.7f, (Graphics)g));
                int sepX = this.getSeparatorX();
                if (this.getComponentOrientation().isLeftToRight()) {
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, sepX + 2, 0.0f, rightColor);
                    g2d.setPaint(gp);
                    g2d.fillRect(0, 0, sepX, this.getHeight());
                } else {
                    GradientPaint gp = new GradientPaint(sepX, 0.0f, leftColor, this.getWidth(), 0.0f, rightColor);
                    g2d.setPaint(gp);
                    g2d.fillRect(sepX + 2, 0, this.getWidth() - sepX, this.getHeight());
                }
            }
            g2d.dispose();
        }
    }
}

