/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.api.common.FlamingoCommand;

public class RibbonApplicationMenuPrimaryCommand
extends FlamingoCommand {
    private PrimaryRolloverCallback rolloverCallback;
    private List<String> groupTitles;
    private List<List<FlamingoCommand>> groupEntries;

    RibbonApplicationMenuPrimaryCommand() {
    }

    public int getSecondaryGroupCount() {
        return this.groupTitles.size();
    }

    public String getSecondaryGroupTitleAt(int groupIndex) {
        return this.groupTitles.get(groupIndex);
    }

    public List<FlamingoCommand> getSecondaryGroupCommands(int groupIndex) {
        return Collections.unmodifiableList(this.groupEntries.get(groupIndex));
    }

    public PrimaryRolloverCallback getRolloverCallback() {
        return this.rolloverCallback;
    }

    @Override
    protected boolean hasAction() {
        return super.hasAction() || this.getRolloverCallback() != null;
    }

    @Override
    protected boolean hasPopup() {
        return super.hasPopup() || this.getSecondaryGroupCount() > 0;
    }

    public static class RibbonApplicationMenuPrimaryCommandBuilder
    extends FlamingoCommand.BaseFlamingoCommandBuilder<RibbonApplicationMenuPrimaryCommand, RibbonApplicationMenuPrimaryCommandBuilder> {
        private PrimaryRolloverCallback rolloverCallback;
        private List<String> groupTitles = new ArrayList<String>();
        private List<List<FlamingoCommand>> groupEntries = new ArrayList<List<FlamingoCommand>>();

        public synchronized RibbonApplicationMenuPrimaryCommandBuilder addSecondaryMenuGroup(String groupTitle, FlamingoCommand ... secondaryCommands) {
            this.groupTitles.add(groupTitle);
            ArrayList<FlamingoCommand> entryList = new ArrayList<FlamingoCommand>();
            this.groupEntries.add(entryList);
            for (FlamingoCommand entry : secondaryCommands) {
                entryList.add(entry);
            }
            return this;
        }

        public synchronized RibbonApplicationMenuPrimaryCommandBuilder addSecondaryMenuGroup(String groupTitle, Iterable<FlamingoCommand> secondaryCommands) {
            this.groupTitles.add(groupTitle);
            ArrayList<FlamingoCommand> entryList = new ArrayList<FlamingoCommand>();
            this.groupEntries.add(entryList);
            for (FlamingoCommand entry : secondaryCommands) {
                entryList.add(entry);
            }
            return this;
        }

        public RibbonApplicationMenuPrimaryCommandBuilder setRolloverCallback(PrimaryRolloverCallback rolloverCallback) {
            this.rolloverCallback = rolloverCallback;
            return this;
        }

        public synchronized RibbonApplicationMenuPrimaryCommandBuilder setSecondaryGroupTitle(int groupIndex, String newTitle) {
            this.groupTitles.set(groupIndex, newTitle);
            return this;
        }

        public RibbonApplicationMenuPrimaryCommand build() {
            RibbonApplicationMenuPrimaryCommand command = new RibbonApplicationMenuPrimaryCommand();
            this.configureBaseCommand(command);
            command.groupTitles = this.groupTitles;
            command.groupEntries = this.groupEntries;
            command.rolloverCallback = this.rolloverCallback;
            return command;
        }
    }

    public static class PrimaryClearRolloverCallback
    implements PrimaryRolloverCallback {
        @Override
        public void menuEntryActivated(JPanel targetPanel) {
            targetPanel.removeAll();
            targetPanel.revalidate();
            targetPanel.repaint();
        }
    }

    public static interface PrimaryRolloverCallback {
        public void menuEntryActivated(JPanel var1);
    }
}

