/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.FlamingoCommand;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.internal.ui.ribbon.CommandButtonLayoutManagerBigFixed;
import org.pushingpixels.flamingo.internal.ui.ribbon.CommandButtonLayoutManagerBigFixedLandscape;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.neon.icon.ResizableIcon;

public class JRibbonBand
extends AbstractRibbonBand {
    public static final CommandButtonDisplayState BIG_FIXED_LANDSCAPE = new CommandButtonDisplayState("Big Fixed Landscape", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton button) {
            return new CommandButtonLayoutManagerBigFixedLandscape();
        }
    };
    public static final CommandButtonDisplayState BIG_FIXED = new CommandButtonDisplayState("Big Fixed", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton button) {
            return new CommandButtonLayoutManagerBigFixed();
        }
    };

    public JRibbonBand(String title, ResizableIcon icon) {
        this(title, icon, null);
    }

    public JRibbonBand(String title, ResizableIcon icon, ActionListener expandActionListener) {
        super(title, icon, expandActionListener, new JBandControlPanel());
        this.resizePolicies = Collections.unmodifiableList(CoreRibbonResizePolicies.getCorePoliciesPermissive(this));
        this.updateUI();
    }

    public AbstractCommandButton addRibbonCommand(FlamingoCommand ribbonCommand, RibbonElementPriority priority) {
        AbstractCommandButton commandButton = ribbonCommand.buildButton();
        commandButton.setHorizontalAlignment(10);
        ((JBandControlPanel)this.getControlPanel()).addCommandButton(commandButton, priority);
        return commandButton;
    }

    public void addRibbonGallery(String galleryName, List<StringValuePair<List<FlamingoCommand>>> commands, Map<RibbonElementPriority, Integer> preferredVisibleCommandCounts, int preferredPopupMaxCommandColumns, int preferredPopupMaxVisibleCommandRows, RibbonElementPriority priority) {
        this.addRibbonGallery(galleryName, commands, preferredVisibleCommandCounts, preferredPopupMaxCommandColumns, preferredPopupMaxVisibleCommandRows, BIG_FIXED_LANDSCAPE, priority);
    }

    public void addRibbonGallery(String galleryName, List<StringValuePair<List<FlamingoCommand>>> commands, Map<RibbonElementPriority, Integer> preferredVisibleCommandCounts, int preferredPopupMaxCommandColumns, int preferredPopupMaxVisibleCommandRows, CommandButtonDisplayState commandDisplayState, RibbonElementPriority priority) {
        JRibbonGallery gallery = new JRibbonGallery();
        gallery.setCommandDisplayState(commandDisplayState);
        gallery.setName(galleryName);
        for (Map.Entry<RibbonElementPriority, Integer> prefCountEntry : preferredVisibleCommandCounts.entrySet()) {
            gallery.setPreferredVisibleButtonCount(prefCountEntry.getKey(), prefCountEntry.getValue());
        }
        gallery.setGroupMapping(commands);
        gallery.setPreferredPopupPanelDimension(preferredPopupMaxCommandColumns, preferredPopupMaxVisibleCommandRows);
        ((JBandControlPanel)this.getControlPanel()).addRibbonGallery(gallery, priority);
    }

    public void addRibbonGalleryCommands(String galleryName, String commandGroupName, FlamingoCommand ... commands) {
        JRibbonGallery gallery = ((JBandControlPanel)this.getControlPanel()).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.addRibbonGalleryCommands(commandGroupName, commands);
    }

    public void removeRibbonGalleryCommands(String galleryName, FlamingoCommand ... commands) {
        JRibbonGallery gallery = ((JBandControlPanel)this.getControlPanel()).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.removeRibbonGalleryCommands(commands);
    }

    public void setSelectedRibbonGalleryCommand(String galleryName, FlamingoCommand commandToSelect) {
        JRibbonGallery gallery = ((JBandControlPanel)this.getControlPanel()).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setSelectedCommand(commandToSelect);
    }

    public void setRibbonGalleryCommandDisplayState(String galleryName, CommandButtonDisplayState displayState) {
        JRibbonGallery gallery = ((JBandControlPanel)this.getControlPanel()).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setCommandDisplayState(displayState);
    }

    public void setRibbonGalleryPopupCallback(String galleryName, RibbonGalleryPopupCallback popupCallback) {
        JRibbonGallery gallery = ((JBandControlPanel)this.getControlPanel()).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setPopupCallback(popupCallback);
    }

    public void setRibbonGalleryExpandKeyTip(String galleryName, String expandKeyTip) {
        JRibbonGallery gallery = ((JBandControlPanel)this.getControlPanel()).getRibbonGallery(galleryName);
        if (gallery == null) {
            return;
        }
        gallery.setExpandKeyTip(expandKeyTip);
    }

    public void addRibbonComponent(JRibbonComponent comp) {
        ((JBandControlPanel)this.getControlPanel()).addRibbonComponent(comp);
    }

    public int startGroup() {
        return ((JBandControlPanel)this.getControlPanel()).startGroup();
    }

    public int startGroup(String groupTitle) {
        return ((JBandControlPanel)this.getControlPanel()).startGroup(groupTitle);
    }

    public void setGroupTitle(int groupIndex, String groupTitle) {
        ((JBandControlPanel)this.getControlPanel()).setGroupTitle(groupIndex, groupTitle);
    }

    public List<JRibbonComponent> getRibbonComponents(int groupIndex) {
        return ((JBandControlPanel)this.getControlPanel()).getRibbonComponents(groupIndex);
    }

    @Override
    public AbstractRibbonBand cloneBand() {
        JRibbonBand result = new JRibbonBand(this.getTitle(), this.getIcon(), this.getExpandActionListener());
        result.applyComponentOrientation(this.getComponentOrientation());
        return result;
    }

    public static interface RibbonGalleryPopupCallback {
        public void popupToBeShown(JCommandPopupMenu var1);
    }
}

