/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb.core;

import java.awt.Component;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.StringValuePair;

public class BreadcrumbTreeAdapterSelector<T>
extends JBreadcrumbBar<T> {
    public BreadcrumbTreeAdapterSelector(TreeModel treeModel, TreeAdapter treeAdapter, boolean isRootVisible) {
        super(null);
        this.model = new BreadcrumbBarModel();
        this.callback = new TreeCallback(treeModel, treeAdapter, isRootVisible);
        this.callback.setup();
        this.updateUI();
    }

    public BreadcrumbTreeAdapterSelector(JTree tree, TreeAdapter treeAdapter) {
        this(tree.getModel(), treeAdapter, tree.isRootVisible());
    }

    public BreadcrumbTreeAdapterSelector(final JTree tree) {
        this(tree, new TreeAdapter(){

            private JLabel getRenderer(Object node) {
                Component renderer = tree.getCellRenderer().getTreeCellRendererComponent(tree, node, false, false, tree.getModel().isLeaf(node), 0, false);
                if (renderer instanceof JLabel) {
                    return (JLabel)renderer;
                }
                return null;
            }

            public String toString(Object node) {
                JLabel label = this.getRenderer(node);
                if (label != null) {
                    return label.getText();
                }
                return null;
            }

            public Icon getIcon(Object node) {
                JLabel label = this.getRenderer(node);
                if (label != null) {
                    return label.getIcon();
                }
                return null;
            }
        });
    }

    private class TreeCallback
    extends BreadcrumbBarCallBack<T> {
        private TreeModel treeModel;
        private TreeAdapter treeAdapter;
        private boolean isRootVisible;

        private TreeCallback(TreeModel treeModel, TreeAdapter treeAdapter, boolean isRootVisible) {
            this.treeModel = treeModel;
            this.treeAdapter = treeAdapter;
            this.isRootVisible = isRootVisible;
        }

        @Override
        public List<StringValuePair<T>> getPathChoices(List<BreadcrumbItem<T>> path) {
            if (path == null) {
                Object root = this.treeModel.getRoot();
                LinkedList bRoots = new LinkedList();
                if (this.isRootVisible) {
                    StringValuePair<Object> rootPair = new StringValuePair<Object>(this.treeAdapter.toString(root), root);
                    rootPair.set("icon", this.treeAdapter.getIcon(root));
                    bRoots.add(rootPair);
                } else {
                    for (int i = 0; i < this.treeModel.getChildCount(root); ++i) {
                        Object rootChild = this.treeModel.getChild(root, i);
                        StringValuePair<Object> rootPair = new StringValuePair<Object>(this.treeAdapter.toString(rootChild), rootChild);
                        rootPair.set("icon", this.treeAdapter.getIcon(rootChild));
                        bRoots.add(rootPair);
                    }
                }
                return bRoots;
            }
            if (path.size() == 0) {
                return null;
            }
            Object lastInPath = path.get(path.size() - 1).getData();
            if (this.treeModel.isLeaf(lastInPath)) {
                return null;
            }
            LinkedList lResult = new LinkedList();
            for (int i = 0; i < this.treeModel.getChildCount(lastInPath); ++i) {
                Object child = this.treeModel.getChild(lastInPath, i);
                if (this.treeModel.isLeaf(child)) continue;
                StringValuePair<Object> pair = new StringValuePair<Object>(this.treeAdapter.toString(child), child);
                pair.set("icon", this.treeAdapter.getIcon(child));
                lResult.add(pair);
            }
            return lResult;
        }

        @Override
        public List<StringValuePair<T>> getLeafs(List<BreadcrumbItem<T>> path) {
            Object lastInPath = path.get(path.size() - 1).getData();
            if (this.treeModel.isLeaf(lastInPath)) {
                return null;
            }
            LinkedList lResult = new LinkedList();
            for (int i = 0; i < this.treeModel.getChildCount(lastInPath); ++i) {
                Object child = this.treeModel.getChild(lastInPath, i);
                if (!this.treeModel.isLeaf(child)) continue;
                StringValuePair<Object> pair = new StringValuePair<Object>(this.treeAdapter.toString(child), child);
                pair.set("icon", this.treeAdapter.getIcon(child));
                lResult.add(pair);
            }
            return lResult;
        }

        @Override
        public InputStream getLeafContent(T leaf) {
            return null;
        }
    }

    public static interface TreeAdapter<T> {
        public String toString(T var1);

        default public Icon getIcon(T node) {
            return null;
        }
    }
}

