/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class CommandButtonLayoutManagerBigFixedLandscape
implements CommandButtonLayoutManager {
    @Override
    public Dimension getPreferredIconSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        Font presentationFont = presentationModel.getFont();
        if (presentationFont == null) {
            presentationFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        int size = ComponentUtilities.getScaledSize(32, presentationFont.getSize(), 2.0, 4);
        return new Dimension(size, size);
    }

    @Override
    public Dimension getPreferredSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        Insets borderInsets = presentationModel.getContentPadding();
        Font presentationFont = presentationModel.getFont();
        if (presentationFont == null) {
            presentationFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor(null), (Font)presentationFont);
        JSeparator jsep = new JSeparator(1);
        int layoutVGap = ComponentUtilities.getVLayoutGap(presentationModel);
        int fillTitleWidth = fm.stringWidth(command.getText());
        int widthFull = Math.max(this.getPreferredIconSize((BaseCommand)command, (BaseCommandButtonPresentationModel)presentationModel).width, fillTitleWidth);
        int heightFull = by + this.getPreferredIconSize((BaseCommand)command, (BaseCommandButtonPresentationModel)presentationModel).height + layoutVGap + jsep.getPreferredSize().width;
        if (command.getText() != null) {
            heightFull += fm.getHeight();
        }
        widthFull = Math.max(widthFull, heightFull * 5 / 4);
        return new Dimension(bx + widthFull, heightFull);
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        return new Point(layoutInfo.actionClickArea.x + layoutInfo.actionClickArea.width / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        return new Point(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int y = ins.top;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        CommandButtonLayoutManager.CommandButtonKind buttonKind = this.getCommandButtonKind(commandButton);
        result.isTextInActionArea = false;
        if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
        }
        Dimension iconSize = this.getPreferredIconSize(commandButton.getContentModel(), commandButton.getPresentationModel());
        int iconWidth = iconSize.width;
        int iconHeight = iconSize.height;
        String buttonText = commandButton.getContentModel().getText();
        if (buttonText == null) {
            y = ins.top + (height - ins.top - ins.bottom - iconHeight) / 2;
        }
        result.iconRect.x = (width - iconWidth) / 2;
        result.iconRect.y = y;
        result.iconRect.width = iconWidth;
        result.iconRect.height = iconHeight;
        y += iconHeight;
        y += new JSeparator((int)0).getPreferredSize().height;
        CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
        lineLayoutInfo.text = buttonText;
        lineLayoutInfo.textRect = new Rectangle();
        int labelWidth = fm.stringWidth(buttonText);
        lineLayoutInfo.textRect.x = ins.left + (width - labelWidth - ins.left - ins.right) / 2;
        lineLayoutInfo.textRect.y = y;
        lineLayoutInfo.textRect.width = labelWidth;
        lineLayoutInfo.textRect.height = labelHeight;
        result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
        result.textLayoutInfoList.add(lineLayoutInfo);
        return result;
    }
}

