/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.ribbon.JRibbon;
import org.pushingpixels.radiance.component.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public abstract class BasicRibbonTaskToggleButtonUI
extends BasicCommandButtonUI {
    private PopupPanelManager.PopupListener popupListener;

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupListener = new PopupPanelManager.PopupListener(){

            @Override
            public void popupShown(PopupPanelManager.PopupEvent event) {
                if (event.getSource() == BasicRibbonTaskToggleButtonUI.this.commandButton) {
                    BasicRibbonTaskToggleButtonUI.this.commandButton.getActionModel().setSelected(this.isTaskSelected());
                }
            }

            @Override
            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getSource() == BasicRibbonTaskToggleButtonUI.this.commandButton) {
                    BasicRibbonTaskToggleButtonUI.this.commandButton.getActionModel().setSelected(this.isTaskSelected());
                }
            }

            private boolean isTaskSelected() {
                JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, BasicRibbonTaskToggleButtonUI.this.commandButton);
                if (ribbon == null) {
                    return false;
                }
                return ribbon.getSelectedTask() == ((JRibbonTaskToggleButton)BasicRibbonTaskToggleButtonUI.this.commandButton).getRibbonTask();
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
    }

    @Override
    protected void uninstallListeners() {
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        super.uninstallListeners();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        RadianceIcon icon = this.icon;
        String text = "Www";
        Font font = this.commandButton.getFont();
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)this.commandButton), (Font)font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int horizontalAlignment = 10;
        switch (this.horizontalAlignment) {
            case CENTER: {
                horizontalAlignment = 0;
                break;
            }
            case TRAILING: {
                horizontalAlignment = 11;
            }
        }
        SwingUtilities.layoutCompoundLabel(this.commandButton, fm, text, (Icon)icon, 0, horizontalAlignment, 0, 0, viewR, iconR, textR, text == null ? 0 : 6);
        Rectangle r = iconR.union(textR);
        Insets insets = this.commandButton.getInsets();
        r.width += 4;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }
}

