/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.icon.CommandButtonFollowColorSchemeIcon;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandGroup;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandStripProjection;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.model.RibbonGalleryContentModel;
import org.pushingpixels.radiance.component.api.ribbon.model.RibbonGalleryPresentationModel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonGalleryUI;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public abstract class BasicRibbonGalleryUI
extends RibbonGalleryUI {
    public static final String RIBBON_GALLERY_EXPAND_BUTTON = "radiance.internal.ribbon.galleryExpandButton";
    protected JRibbonGallery ribbonGallery;
    private int firstVisibleButtonIndex;
    private int visibleButtonsInEachRow;
    private int visibleButtonRowNumber;
    private Command scrollDownCommand;
    private Command scrollUpCommand;
    private Command expandCommand;
    private CommandGroup galleryScrollerCommands;
    private JComponent buttonStrip;
    private CommandMenuContentModel expandedGalleryContentModel;
    private RibbonGalleryContentModel.GalleryCommandAction galleryCommandSelectionListener;
    private ChangeListener galleryModelChangeListener;
    private ChangeListener expandedGalleryModelChangeListener;
    protected Insets margin;

    @Override
    public void installUI(JComponent c) {
        this.ribbonGallery = (JRibbonGallery)c;
        this.firstVisibleButtonIndex = 0;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    protected void installComponents() {
        int fontSize = RadianceSizeUtils.getComponentFontSize((Component)this.ribbonGallery);
        int arrowIconHeight = (int)RadianceSizeUtils.getSmallArrowIconHeight((int)fontSize);
        int arrowDoubleIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        this.scrollUpCommand = ((Command.Builder)((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            this.scrollOneRowUp();
            this.ribbonGallery.revalidate();
        })).setIconFactory(() -> new CommandButtonFollowColorSchemeIcon((g, scheme, width, height) -> BladeArrowIconUtils.drawArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)1, (RadianceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight)))).build();
        this.scrollDownCommand = ((Command.Builder)((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            this.scrollOneRowDown();
            this.ribbonGallery.revalidate();
        })).setIconFactory(() -> new CommandButtonFollowColorSchemeIcon((g, scheme, width, height) -> BladeArrowIconUtils.drawArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)5, (RadianceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight)))).build();
        this.expandedGalleryContentModel = JRibbonGallery.getExpandPopupMenuContentModel(this.ribbonGallery.getProjection());
        this.expandCommand = ((Command.Builder)((Command.Builder)Command.builder().setSecondaryContentModel(this.expandedGalleryContentModel)).setIconFactory(() -> new CommandButtonFollowColorSchemeIcon((g, scheme, width, height) -> BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)5, (RadianceColorScheme)scheme), new Dimension(arrowIconWidth, arrowDoubleIconHeight)))).build();
        HashMap<Command, BaseCommandButtonPresentationModel.Overlay> galleryScrollerOverlays = new HashMap<Command, BaseCommandButtonPresentationModel.Overlay>();
        galleryScrollerOverlays.put(this.scrollUpCommand, CommandButtonPresentationModel.overlay().setIconDimension(new Dimension(arrowIconWidth, arrowIconHeight)).setSides(RadianceThemingSlices.Sides.builder().setStraightSides(EnumSet.of(RadianceThemingSlices.Side.LEADING, RadianceThemingSlices.Side.BOTTOM)).build()).setAutoRepeatAction(true).setAutoRepeatActionIntervals(200, 50));
        galleryScrollerOverlays.put(this.scrollDownCommand, CommandButtonPresentationModel.overlay().setIconDimension(new Dimension(arrowIconWidth, arrowIconHeight)).setSides(RadianceThemingSlices.Sides.builder().setStraightSides(EnumSet.of(RadianceThemingSlices.Side.LEADING, RadianceThemingSlices.Side.TOP, RadianceThemingSlices.Side.BOTTOM)).setOpenSides(EnumSet.of(RadianceThemingSlices.Side.TOP)).build()).setAutoRepeatAction(true).setAutoRepeatActionIntervals(200, 50));
        galleryScrollerOverlays.put(this.expandCommand, CommandButtonPresentationModel.overlay().setIconDimension(new Dimension(arrowIconWidth, arrowDoubleIconHeight)).setSides(RadianceThemingSlices.Sides.builder().setStraightSides(EnumSet.of(RadianceThemingSlices.Side.LEADING, RadianceThemingSlices.Side.TOP)).setOpenSides(EnumSet.of(RadianceThemingSlices.Side.TOP)).build()).setShowPopupIcon(false).setPopupKeyTip(((RibbonGalleryPresentationModel)this.ribbonGallery.getProjection().getPresentationModel()).getExpandKeyTip()).setPopupMenuPresentationModel(JRibbonGallery.getExpandPopupMenuPresentationModel(this.ribbonGallery.getProjection())).setPopupPlacementStrategy((RadianceThemingSlices.PopupPlacementStrategy)RadianceThemingSlices.PopupPlacementStrategy.Downward.HALIGN_START).setPopupAnchorBoundsProvider(() -> {
            Point loc = this.ribbonGallery.getLocationOnScreen();
            return new Rectangle(loc.x, loc.y - this.ribbonGallery.getHeight(), this.ribbonGallery.getWidth(), this.ribbonGallery.getHeight());
        }));
        galleryScrollerOverlays.putAll(this.ribbonGallery.getProjection().getCommandOverlays());
        this.galleryScrollerCommands = new CommandGroup(this.scrollUpCommand, this.scrollDownCommand, this.expandCommand);
        CommandStripProjection projection = new CommandStripProjection(this.galleryScrollerCommands, CommandStripPresentationModel.builder().setOrientation(CommandStripPresentationModel.StripOrientation.VERTICAL).setCommandPresentationState(CommandButtonPresentationState.SMALL_FIT_TO_ICON).setCommandContentPadding(new Insets(0, 0, 0, 0)).setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy.ALWAYS).setToDismissPopupsOnActivation(false).build());
        projection.setCommandOverlays(galleryScrollerOverlays);
        this.buttonStrip = projection.buildComponent();
        this.ribbonGallery.add(this.buttonStrip);
    }

    protected void uninstallComponents() {
        this.expandedGalleryContentModel = null;
        this.galleryScrollerCommands.removeAllCommands();
        this.buttonStrip.removeAll();
        this.ribbonGallery.remove(this.buttonStrip);
    }

    protected void installDefaults() {
        this.margin = new Insets(3, 3, 3, 3);
        Border b = this.ribbonGallery.getBorder();
        if (b == null || b instanceof UIResource) {
            this.ribbonGallery.setBorder(new BorderUIResource.EmptyBorderUIResource(2, 2, 2, 2));
        }
        this.ribbonGallery.setOpaque(false);
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.galleryCommandSelectionListener = activated -> SwingUtilities.invokeLater(() -> {
            if (this.ribbonGallery != null) {
                this.scrollToSelected();
                this.ribbonGallery.revalidate();
            }
        });
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).addCommandActivationListener(this.galleryCommandSelectionListener);
        this.galleryModelChangeListener = changeEvent -> this.ribbonGallery.revalidate();
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).addChangeListener(this.galleryModelChangeListener);
        this.expandedGalleryModelChangeListener = e -> {
            Command selectedCommandInPopupMenu = this.expandedGalleryContentModel.getPanelContentModel().getSelectedCommand();
            ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).setSelectedCommand(selectedCommandInPopupMenu);
        };
        this.expandedGalleryContentModel.addChangeListener(this.expandedGalleryModelChangeListener);
    }

    protected void uninstallListeners() {
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).removeCommandActivationListener(this.galleryCommandSelectionListener);
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).removeChangeListener(this.galleryModelChangeListener);
        this.expandedGalleryContentModel.removeChangeListener(this.expandedGalleryModelChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.ribbonGallery = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonGalleryLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintRibbonGalleryBorder(graphics);
        graphics.dispose();
    }

    protected abstract void paintRibbonGalleryBorder(Graphics var1);

    protected int getLayoutGap() {
        return 4;
    }

    public int getPreferredWidth(int buttonCount, int availableHeight) {
        Insets borderInsets = this.ribbonGallery.getInsets();
        int galleryHeight = availableHeight - this.margin.top - this.margin.bottom;
        int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
        int result = this.margin.left;
        CommandButtonPresentationState galleryButtonPresentationState = ((RibbonGalleryPresentationModel)this.ribbonGallery.getProjection().getPresentationModel()).getCommandPresentationState();
        if (galleryButtonPresentationState == CommandButtonPresentationState.SMALL) {
            result += buttonCount * buttonHeight / 3;
        }
        if (galleryButtonPresentationState == JRibbonBand.BIG_FIXED) {
            result += buttonCount * buttonHeight;
        }
        if (galleryButtonPresentationState == JRibbonBand.BIG_FIXED_LANDSCAPE) {
            result += buttonCount * buttonHeight * 5 / 4;
        }
        result += (buttonCount + 1) * this.getLayoutGap();
        result += this.getScrollerButtonWidth();
        return result += this.margin.right;
    }

    private int getScrollerButtonWidth() {
        return ComponentUtilities.getScaledSize(15, RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont().getSize(), 1.0, 1);
    }

    private void scrollOneRowDown() {
        this.firstVisibleButtonIndex += this.visibleButtonsInEachRow;
    }

    private void scrollOneRowUp() {
        this.firstVisibleButtonIndex -= this.visibleButtonsInEachRow;
    }

    private void scrollToSelected() {
        JCommandButton selected = this.ribbonGallery.getSelectedButton();
        if (selected == null) {
            return;
        }
        int selIndex = -1;
        for (int i = 0; i < this.ribbonGallery.getCommandCount(); ++i) {
            if (this.ribbonGallery.getButtonAt(i) != selected) continue;
            selIndex = i;
            break;
        }
        if (selIndex < 0) {
            return;
        }
        if (selIndex >= this.firstVisibleButtonIndex && selIndex < this.firstVisibleButtonIndex + this.visibleButtonRowNumber * this.visibleButtonsInEachRow) {
            return;
        }
        if (this.visibleButtonsInEachRow <= 0) {
            return;
        }
        do {
            if (selIndex < this.firstVisibleButtonIndex) {
                this.scrollOneRowUp();
                continue;
            }
            this.scrollOneRowDown();
        } while (selIndex < this.firstVisibleButtonIndex || selIndex >= this.firstVisibleButtonIndex + this.visibleButtonRowNumber * this.visibleButtonsInEachRow);
    }

    private class RibbonGalleryLayout
    implements LayoutManager {
        private RibbonGalleryLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(BasicRibbonGalleryUI.this.ribbonGallery.getPreferredWidth(BasicRibbonGalleryUI.this.ribbonGallery.getPresentationPriority(), c.getHeight()), c.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int i;
            int neededSpace;
            int availableButtonsSpace;
            int width = c.getWidth();
            int height = c.getHeight();
            Insets borderInsets = BasicRibbonGalleryUI.this.ribbonGallery.getInsets();
            int galleryHeight = height - BasicRibbonGalleryUI.this.margin.top - BasicRibbonGalleryUI.this.margin.bottom;
            int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
            BasicRibbonGalleryUI.this.visibleButtonRowNumber = 1;
            CommandButtonPresentationState galleryButtonPresentationState = ((RibbonGalleryPresentationModel)BasicRibbonGalleryUI.this.ribbonGallery.getProjection().getPresentationModel()).getCommandPresentationState();
            if (galleryButtonPresentationState == CommandButtonPresentationState.SMALL) {
                buttonHeight /= 3;
                BasicRibbonGalleryUI.this.visibleButtonRowNumber = 3;
            }
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            int scrollerButtonHeight = galleryHeight / 3;
            int scrollerButtonWidth = BasicRibbonGalleryUI.this.getScrollerButtonWidth();
            int buttonX = ltr ? width - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.right : BasicRibbonGalleryUI.this.margin.left;
            BasicRibbonGalleryUI.this.buttonStrip.getComponent(0).setPreferredSize(new Dimension(scrollerButtonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.getComponent(1).setPreferredSize(new Dimension(scrollerButtonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.getComponent(2).setPreferredSize(new Dimension(scrollerButtonWidth, galleryHeight - 2 * scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.setBounds(buttonX, BasicRibbonGalleryUI.this.margin.top, scrollerButtonWidth, galleryHeight);
            BasicRibbonGalleryUI.this.buttonStrip.doLayout();
            int maxButtonWidth = buttonHeight;
            if (galleryButtonPresentationState == JRibbonBand.BIG_FIXED_LANDSCAPE) {
                maxButtonWidth = maxButtonWidth * 5 / 4;
            }
            int gap = BasicRibbonGalleryUI.this.getLayoutGap();
            BasicRibbonGalleryUI.this.visibleButtonsInEachRow = 0;
            int n = availableButtonsSpace = ltr ? buttonX - BasicRibbonGalleryUI.this.margin.left : width - buttonX - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.right;
            while (true) {
                if ((neededSpace = BasicRibbonGalleryUI.this.visibleButtonsInEachRow * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsInEachRow + 1) * gap) > availableButtonsSpace) break;
                BasicRibbonGalleryUI.this.visibleButtonsInEachRow++;
            }
            BasicRibbonGalleryUI.this.visibleButtonsInEachRow--;
            neededSpace = BasicRibbonGalleryUI.this.visibleButtonsInEachRow * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsInEachRow + 1) * gap;
            int startX = ltr ? BasicRibbonGalleryUI.this.margin.left + gap : width - BasicRibbonGalleryUI.this.margin.right - gap;
            int availableWidth = ltr ? buttonX - BasicRibbonGalleryUI.this.margin.right : width - buttonX - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.left;
            int toAddToButtonWidth = (availableWidth - neededSpace) / BasicRibbonGalleryUI.this.visibleButtonsInEachRow;
            int lastVisibleButtonIndex = BasicRibbonGalleryUI.this.firstVisibleButtonIndex + BasicRibbonGalleryUI.this.visibleButtonRowNumber * BasicRibbonGalleryUI.this.visibleButtonsInEachRow - 1;
            lastVisibleButtonIndex = Math.min(lastVisibleButtonIndex, BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() - 1);
            int currCountInRow = 0;
            int buttonY = BasicRibbonGalleryUI.this.margin.top + borderInsets.top;
            int singleButtonWidth = maxButtonWidth + toAddToButtonWidth;
            for (i = 0; i < BasicRibbonGalleryUI.this.firstVisibleButtonIndex; ++i) {
                BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i).setVisible(false);
            }
            if (lastVisibleButtonIndex >= 0) {
                for (i = lastVisibleButtonIndex + 1; i < BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount(); ++i) {
                    BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i).setVisible(false);
                }
            }
            for (i = BasicRibbonGalleryUI.this.firstVisibleButtonIndex; i <= lastVisibleButtonIndex; ++i) {
                JCommandButton currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                currButton.setVisible(true);
                if (ltr) {
                    currButton.setBounds(startX, buttonY, singleButtonWidth, buttonHeight);
                    startX += singleButtonWidth + gap;
                } else {
                    currButton.setBounds(startX - singleButtonWidth, buttonY, singleButtonWidth, buttonHeight);
                    startX -= singleButtonWidth + gap;
                }
                if (++currCountInRow != BasicRibbonGalleryUI.this.visibleButtonsInEachRow) continue;
                currCountInRow = 0;
                startX = ltr ? BasicRibbonGalleryUI.this.margin.left + gap : width - BasicRibbonGalleryUI.this.margin.right - gap;
                buttonY += buttonHeight;
            }
            if (BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() == 0) {
                BasicRibbonGalleryUI.this.scrollDownCommand.setActionEnabled(false);
                BasicRibbonGalleryUI.this.scrollUpCommand.setActionEnabled(false);
                BasicRibbonGalleryUI.this.expandCommand.setActionEnabled(false);
            } else {
                BasicRibbonGalleryUI.this.scrollDownCommand.setActionEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() - 1).isVisible());
                BasicRibbonGalleryUI.this.scrollUpCommand.setActionEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(0).isVisible());
                BasicRibbonGalleryUI.this.expandCommand.setActionEnabled(true);
            }
        }
    }
}

