/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.pushingpixels.radiance.component.api.common.popup.JColorSelectorPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.radiance.component.internal.ui.common.popup.BasicColorSelectorPopupMenuPanelUI;
import org.pushingpixels.radiance.component.internal.ui.common.popup.JColorSelectorComponent;

public class ColorSelectorPopupMenuMultiRowSelector
extends JPanel {
    private final int columnCount;
    private final int derivedCount;

    public ColorSelectorPopupMenuMultiRowSelector(final JColorSelectorPopupMenuPanel colorSelectorPopupMenu, final int derivedCount, final Color ... colors) {
        this.derivedCount = derivedCount;
        this.columnCount = colors.length;
        ColorSelectorPopupMenuContentModel contentModel = (ColorSelectorPopupMenuContentModel)colorSelectorPopupMenu.getProjection().getContentModel();
        final JColorSelectorComponent[][] comps = new JColorSelectorComponent[colors.length][1 + derivedCount];
        for (int i = 0; i < colors.length; ++i) {
            Color primary = colors[i];
            comps[i][0] = new JColorSelectorComponent(primary, contentModel.getColorPreviewListener(), contentModel.getColorActivationListener());
            comps[i][0].addColorActivationListener(JColorSelectorPopupMenuPanel::addColorToRecentlyUsed);
            this.add(comps[i][0]);
            float[] primaryHsb = new float[3];
            Color.RGBtoHSB(primary.getRed(), primary.getGreen(), primary.getBlue(), primaryHsb);
            for (int row = 1; row <= derivedCount; ++row) {
                float bFactor = (float)(row - 1) / (float)derivedCount;
                bFactor = (float)Math.pow(bFactor, 1.4f);
                float brightness = 1.0f - bFactor;
                if (primaryHsb[1] == 0.0f) {
                    float max = 0.5f + 0.5f * primaryHsb[2];
                    brightness = max * (float)(derivedCount - row + 1) / (float)derivedCount;
                }
                Color secondary = new Color(Color.HSBtoRGB(primaryHsb[0], primaryHsb[1] * (float)(row + 1) / (float)(derivedCount + 1), brightness));
                comps[i][row] = new JColorSelectorComponent(secondary, contentModel.getColorPreviewListener(), contentModel.getColorActivationListener());
                comps[i][row].setTopOpen(row > 1);
                comps[i][row].setBottomOpen(row < derivedCount);
                comps[i][row].addColorActivationListener(JColorSelectorPopupMenuPanel::addColorToRecentlyUsed);
                this.add(comps[i][row]);
            }
        }
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(10, 10);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                BasicColorSelectorPopupMenuPanelUI ui = (BasicColorSelectorPopupMenuPanelUI)colorSelectorPopupMenu.getUI();
                int gap = ui.getColorSelectorCellGap();
                int size = ui.getColorSelectorCellSize();
                return new Dimension(colors.length * size + (colors.length + 1) * gap, gap + size + gap + derivedCount * size + gap);
            }

            @Override
            public void layoutContainer(Container parent) {
                BasicColorSelectorPopupMenuPanelUI ui = (BasicColorSelectorPopupMenuPanelUI)colorSelectorPopupMenu.getUI();
                int gap = ui.getColorSelectorCellGap();
                int size = ui.getColorSelectorCellSize();
                if (parent.getComponentOrientation().isLeftToRight()) {
                    int y = gap;
                    for (int row = 0; row <= derivedCount; ++row) {
                        int x = gap;
                        for (int i = 0; i < colors.length; ++i) {
                            comps[i][row].setBounds(x, y, size, size);
                            x += size + gap;
                        }
                        y += size;
                        if (row != 0) continue;
                        y += gap;
                    }
                } else {
                    int y = gap;
                    for (int row = 0; row <= derivedCount; ++row) {
                        int x = ColorSelectorPopupMenuMultiRowSelector.this.getWidth() - gap;
                        for (int i = 0; i < colors.length; ++i) {
                            comps[i][row].setBounds(x - size, y, size, size);
                            x -= size + gap;
                        }
                        y += size;
                        if (row != 0) continue;
                        y += gap;
                    }
                }
            }
        });
    }

    public void focusOn(int row, int column) {
        this.getComponent(column * (this.derivedCount + 1) + row).requestFocus();
    }

    private boolean focusMove(FocusMoveDirection focusMoveDirection) {
        for (int row = 0; row <= this.derivedCount; ++row) {
            for (int column = 0; column < this.columnCount; ++column) {
                if (!this.getComponent(column * (this.derivedCount + 1) + row).hasFocus()) continue;
                switch (focusMoveDirection) {
                    case UP: {
                        if (row > 0) {
                            this.focusOn(row - 1, column);
                            return true;
                        }
                        return false;
                    }
                    case DOWN: {
                        if (row < this.derivedCount) {
                            this.focusOn(row + 1, column);
                            return true;
                        }
                        return false;
                    }
                    case LEFT: {
                        if (column > 0) {
                            this.focusOn(row, column - 1);
                            return true;
                        }
                        return false;
                    }
                    case RIGHT: {
                        if (column < this.columnCount - 1) {
                            this.focusOn(row, column + 1);
                            return true;
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public boolean focusUp() {
        return this.focusMove(FocusMoveDirection.UP);
    }

    public boolean focusDown() {
        return this.focusMove(FocusMoveDirection.DOWN);
    }

    public boolean focusRight() {
        return this.focusMove(FocusMoveDirection.RIGHT);
    }

    public boolean focusLeft() {
        return this.focusMove(FocusMoveDirection.LEFT);
    }

    public int getRowCount() {
        return 1 + this.derivedCount;
    }

    private static enum FocusMoveDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

