/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JCommandButtonPanel;
import org.pushingpixels.radiance.component.api.common.JScrollablePanel;
import org.pushingpixels.radiance.component.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandPopupMenuPanelPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelLayoutSpec;
import org.pushingpixels.radiance.component.api.common.model.panel.PanelRowFillSpec;
import org.pushingpixels.radiance.component.api.common.popup.AbstractPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.JColorSelectorPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.JCommandPopupMenuPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.radiance.component.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.internal.ui.common.BasicCommandButtonPanelUI;
import org.pushingpixels.radiance.component.internal.ui.common.popup.BasicPopupPanelUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public abstract class BasicCommandPopupMenuPanelUI
extends BasicPopupPanelUI {
    protected AbstractPopupMenuPanel popupMenuPanel;
    private ChangeListener popupMenuPanelChangeListener;
    private PopupPanelManager.PopupListener popupListener;
    private ScrollableCommandButtonPanel commandButtonPanel;
    protected JScrollablePanel<JPanel> menuItemsPanel;
    public static final String FORCE_ICON = "radiance.component.internal.commandPopupMenuPanel.forceIcon";

    @Override
    public void installUI(JComponent c) {
        this.popupMenuPanel = (AbstractPopupMenuPanel)c;
        super.installUI(this.popupMenuPanel);
        this.popupMenuPanel.setLayout(this.createLayoutManager());
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncComponents();
    }

    protected boolean hasLeadingButtonPanel() {
        return ((JCommandPopupMenuPanel)this.popupMenuPanel).hasCommandButtonPanel();
    }

    protected int getMaxVisibleMenuCommands() {
        return ((CommandPopupMenuPresentationModel)((JCommandPopupMenuPanel)this.popupMenuPanel).getProjection().getPresentationModel()).getMaxVisibleMenuCommands();
    }

    protected void syncComponents() {
        if (this.hasLeadingButtonPanel()) {
            this.commandButtonPanel = this.createScrollableButtonPanel();
            this.popupMenuPanel.add(this.commandButtonPanel);
        }
        final JPanel menuPanel = this.createMenuPanel();
        menuPanel.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int height = 0;
                int width = 0;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Dimension pref = parent.getComponent(i).getPreferredSize();
                    height += pref.height;
                    width = Math.max(width, pref.width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets ins = parent.getInsets();
                int topY = ins.top;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension pref = comp.getPreferredSize();
                    comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, pref.height);
                    topY += pref.height;
                }
            }
        });
        this.popupMenuPanel.putClientProperty(FORCE_ICON, null);
        List<Component> menuComponents = this.popupMenuPanel.getMenuComponents();
        if (menuComponents != null) {
            for (Component menuComponent : menuComponents) {
                menuPanel.add(menuComponent);
            }
            boolean atLeastOneButtonHasIcon = false;
            for (Component menuComponent : menuComponents) {
                JCommandButton menuButton;
                if (!(menuComponent instanceof JCommandButton) || !(menuButton = (JCommandButton)menuComponent).getPresentationModel().isForceAllocateSpaceForIcon()) continue;
                atLeastOneButtonHasIcon = true;
            }
            this.popupMenuPanel.putClientProperty(FORCE_ICON, atLeastOneButtonHasIcon ? Boolean.TRUE : null);
        }
        this.menuItemsPanel = new JScrollablePanel<JPanel>(menuPanel, JScrollablePanel.ScrollType.VERTICALLY);
        final LayoutManager scrollableLm = this.menuItemsPanel.getLayout();
        this.menuItemsPanel.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                scrollableLm.addLayoutComponent(name, comp);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                scrollableLm.removeLayoutComponent(comp);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension result = menuPanel.getPreferredSize();
                int maxMenuButtonCount = BasicCommandPopupMenuPanelUI.this.getMaxVisibleMenuCommands();
                if (maxMenuButtonCount < 0 || maxMenuButtonCount >= menuPanel.getComponentCount()) {
                    return result;
                }
                int singleHeight = menuPanel.getComponent((int)0).getPreferredSize().height;
                int width = 0;
                for (int i = 0; i < menuPanel.getComponentCount(); ++i) {
                    width = Math.max(width, menuPanel.getComponent((int)i).getPreferredSize().width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, singleHeight * (maxMenuButtonCount + 2) + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                scrollableLm.layoutContainer(parent);
            }
        });
        this.popupMenuPanel.add(this.menuItemsPanel);
    }

    protected ScrollableCommandButtonPanel createScrollableButtonPanel() {
        CommandPopupMenuPanelPresentationModel panelPresentationModel = ((CommandPopupMenuPresentationModel)((JCommandPopupMenuPanel)this.popupMenuPanel).getProjection().getPresentationModel()).getPanelPresentationModel();
        return new ScrollableCommandButtonPanel(((JCommandPopupMenuPanel)this.popupMenuPanel).getMainButtonPanel(), panelPresentationModel.getLayoutSpec().getColumnCount(), panelPresentationModel.getLayoutSpec().getVisibleRowCount());
    }

    @Override
    protected void uninstallComponents() {
        this.popupMenuPanel.removeAll();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenuPanelChangeListener = changeEvent -> {
            this.popupMenuPanel.removeAll();
            this.syncComponents();
        };
        this.popupMenuPanel.addChangeListener(this.popupMenuPanelChangeListener);
        this.popupListener = new PopupPanelManager.PopupListener(){

            @Override
            public void popupShown(PopupPanelManager.PopupEvent event) {
            }

            @Override
            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getSource() instanceof JColorSelectorPopupMenuPanel) {
                    ((ColorSelectorPopupMenuContentModel)((JColorSelectorPopupMenuPanel)event.getSource()).getProjection().getContentModel()).getColorPreviewListener().onColorPreviewCanceled();
                }
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
    }

    @Override
    protected void uninstallListeners() {
        this.popupMenuPanel.removeChangeListener(this.popupMenuPanelChangeListener);
        this.popupMenuPanelChangeListener = null;
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        super.uninstallListeners();
    }

    protected abstract JPanel createMenuPanel();

    protected LayoutManager createLayoutManager() {
        return new PopupMenuLayoutManager();
    }

    private void focusAndScrollToMenuItem(Component popupMenuComponent) {
        popupMenuComponent.requestFocus();
        this.menuItemsPanel.scrollToIfNecessary(popupMenuComponent.getY(), popupMenuComponent.getHeight());
    }

    @Override
    public void focusFirst() {
        if (this.commandButtonPanel != null && this.commandButtonPanel.buttonPanel.getUI().focusFirst()) {
            return;
        }
        List<Component> popupMenuComponents = this.popupMenuPanel.getMenuComponents();
        if (!popupMenuComponents.isEmpty()) {
            this.focusAndScrollToMenuItem(popupMenuComponents.get(0));
        }
    }

    @Override
    public void focusLast() {
        List<Component> popupMenuComponents = this.popupMenuPanel.getMenuComponents();
        if (!popupMenuComponents.isEmpty()) {
            this.focusAndScrollToMenuItem(popupMenuComponents.get(popupMenuComponents.size() - 1));
        }
    }

    private int getFocusedIndex(List<Component> components) {
        if (components != null) {
            for (int i = 0; i < components.size(); ++i) {
                if (!components.get(i).hasFocus()) continue;
                return i;
            }
        }
        return -1;
    }

    private Component findFirstFocusableAfter(List<Component> components, int index) {
        if (components == null) {
            return null;
        }
        if (index == -1) {
            return null;
        }
        for (int i = index + 1; i < components.size(); ++i) {
            if (!components.get(i).isFocusable()) continue;
            return components.get(i);
        }
        return null;
    }

    private Component findLastFocusableBefore(List<Component> components, int index) {
        if (components == null) {
            return null;
        }
        if (index == -1) {
            return null;
        }
        for (int i = index - 1; i >= 0; --i) {
            if (!components.get(i).isFocusable()) continue;
            return components.get(i);
        }
        return null;
    }

    @Override
    public void focusDown() {
        if (this.commandButtonPanel != null && this.commandButtonPanel.buttonPanel.getUI().focusDown()) {
            return;
        }
        List<Component> popupMenuComponents = this.popupMenuPanel.getMenuComponents();
        int focusedIndex = this.getFocusedIndex(popupMenuComponents);
        if (focusedIndex < 0) {
            if (this.commandButtonPanel != null && !this.commandButtonPanel.buttonPanel.getUI().hasFocus() && this.commandButtonPanel.buttonPanel.getUI().focusFirst()) {
                return;
            }
            if (!popupMenuComponents.isEmpty()) {
                this.focusAndScrollToMenuItem(popupMenuComponents.get(0));
            }
        } else {
            Component nextFocus = this.findFirstFocusableAfter(popupMenuComponents, focusedIndex);
            if (nextFocus != null) {
                this.focusAndScrollToMenuItem(nextFocus);
            } else if (this.commandButtonPanel != null) {
                this.commandButtonPanel.buttonPanel.getUI().focusFirst();
            }
        }
    }

    @Override
    public void focusUp() {
        if (this.commandButtonPanel != null && this.commandButtonPanel.buttonPanel.getUI().focusUp()) {
            return;
        }
        List<Component> popupMenuComponents = this.popupMenuPanel.getMenuComponents();
        int focusedIndex = this.getFocusedIndex(popupMenuComponents);
        if (focusedIndex < 0) {
            this.focusLast();
        } else {
            Component prevFocus = this.findLastFocusableBefore(popupMenuComponents, focusedIndex);
            if (prevFocus != null) {
                this.focusAndScrollToMenuItem(prevFocus);
            } else if (this.commandButtonPanel != null) {
                this.commandButtonPanel.buttonPanel.getUI().focusLast();
            }
        }
    }

    private boolean maybeMoveFocusToAnotherPopup() {
        for (Component popupMenuComponent : this.popupMenuPanel.getMenuComponents()) {
            if (!popupMenuComponent.hasFocus()) continue;
            List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
            for (PopupPanelManager.PopupInfo popup : popups) {
                if (popup.getPopupOriginator() != popupMenuComponent) continue;
                popup.getPopupPanel().getUI().focusFirst();
                return true;
            }
        }
        return false;
    }

    @Override
    public void focusRight() {
        if (this.commandButtonPanel != null) {
            this.commandButtonPanel.buttonPanel.getUI().focusRight();
        } else if (this.popupMenuPanel.getComponentOrientation().isLeftToRight()) {
            this.maybeMoveFocusToAnotherPopup();
        }
    }

    @Override
    public void focusLeft() {
        if (this.commandButtonPanel != null) {
            this.commandButtonPanel.buttonPanel.getUI().focusLeft();
        } else if (!this.popupMenuPanel.getComponentOrientation().isLeftToRight()) {
            this.maybeMoveFocusToAnotherPopup();
        }
    }

    protected static abstract class MenuPanel
    extends JPanel {
        protected MenuPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            AbstractPopupMenuPanel menu = (AbstractPopupMenuPanel)SwingUtilities.getAncestorOfClass(AbstractPopupMenuPanel.class, this);
            if (Boolean.TRUE.equals(menu.getClientProperty(BasicCommandPopupMenuPanelUI.FORCE_ICON))) {
                this.paintIconGutterBackground(g);
            }
        }

        protected int getSeparatorX() {
            AbstractPopupMenuPanel menu = (AbstractPopupMenuPanel)SwingUtilities.getAncestorOfClass(AbstractPopupMenuPanel.class, this);
            if (!Boolean.TRUE.equals(menu.getClientProperty(BasicCommandPopupMenuPanelUI.FORCE_ICON))) {
                return -1;
            }
            List<Component> menuComponents = menu.getMenuComponents();
            if (menuComponents != null) {
                for (Component menuComponent : menuComponents) {
                    JCommandButton button;
                    if (!(menuComponent instanceof JCommandButton) || !(button = (JCommandButton)menuComponent).getPresentationModel().isForceAllocateSpaceForIcon()) continue;
                    boolean ltr = button.getComponentOrientation().isLeftToRight();
                    CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = button.getUI().getLayoutInfo();
                    if (ltr) {
                        int iconRight = layoutInfo.iconRect.x + layoutInfo.iconRect.width;
                        int textLeft = button.getWidth();
                        for (CommandButtonLayoutManager.TextLayoutInfo tli : layoutInfo.textLayoutInfoList) {
                            textLeft = Math.min(textLeft, tli.textRect.x);
                        }
                        return (iconRight + textLeft) / 2;
                    }
                    int iconLeft = layoutInfo.iconRect.x;
                    int textRight = 0;
                    for (CommandButtonLayoutManager.TextLayoutInfo tli : layoutInfo.textLayoutInfoList) {
                        textRight = Math.max(textRight, tli.textRect.x + tli.textRect.width);
                    }
                    return (iconLeft + textRight) / 2;
                }
            }
            throw new IllegalStateException("Menu marked to show icons but no menu buttons in it");
        }

        protected abstract void paintIconGutterBackground(Graphics var1);
    }

    protected class PopupMenuLayoutManager
    implements LayoutManager {
        protected PopupMenuLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int width = 0;
            if (BasicCommandPopupMenuPanelUI.this.commandButtonPanel != null) {
                width = ((BasicCommandPopupMenuPanelUI)BasicCommandPopupMenuPanelUI.this).commandButtonPanel.getPreferredSize().width;
                height = ((BasicCommandPopupMenuPanelUI)BasicCommandPopupMenuPanelUI.this).commandButtonPanel.getPreferredSize().height;
            }
            Dimension menuItemsPref = BasicCommandPopupMenuPanelUI.this.getMaxVisibleMenuCommands() > 0 ? BasicCommandPopupMenuPanelUI.this.menuItemsPanel.getPreferredSize() : BasicCommandPopupMenuPanelUI.this.menuItemsPanel.getView().getPreferredSize();
            width = Math.max(menuItemsPref.width, width);
            Insets ins = parent.getInsets();
            return new Dimension(width + ins.left + ins.right, (height += menuItemsPref.height) + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets ins = parent.getInsets();
            int bottomY = parent.getHeight() - ins.bottom;
            Dimension menuItemsPref = BasicCommandPopupMenuPanelUI.this.getMaxVisibleMenuCommands() > 0 ? BasicCommandPopupMenuPanelUI.this.menuItemsPanel.getPreferredSize() : BasicCommandPopupMenuPanelUI.this.menuItemsPanel.getView().getPreferredSize();
            BasicCommandPopupMenuPanelUI.this.menuItemsPanel.setBounds(ins.left, bottomY - menuItemsPref.height, parent.getWidth() - ins.left - ins.right, menuItemsPref.height);
            BasicCommandPopupMenuPanelUI.this.menuItemsPanel.doLayout();
            bottomY -= menuItemsPref.height;
            if (BasicCommandPopupMenuPanelUI.this.commandButtonPanel != null) {
                BasicCommandPopupMenuPanelUI.this.commandButtonPanel.setBounds(ins.left, ins.top, parent.getWidth() - ins.left - ins.right, bottomY - ins.top);
                BasicCommandPopupMenuPanelUI.this.commandButtonPanel.invalidate();
                BasicCommandPopupMenuPanelUI.this.commandButtonPanel.validate();
                BasicCommandPopupMenuPanelUI.this.commandButtonPanel.doLayout();
            }
        }
    }

    protected static class ScrollableCommandButtonPanel
    extends JComponent {
        private Dimension maxDimension;
        private JCommandButtonPanel buttonPanel;
        private int maxVisibleButtonRows;
        private JScrollPane scroll;

        private ScrollableCommandButtonPanel(JCommandButtonPanel iconPanel, int maxButtonColumns, int maxVisibleButtonRows) {
            this.buttonPanel = iconPanel;
            ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).setLayoutSpec(new PanelLayoutSpec.RowFill(new PanelRowFillSpec.Fixed(maxButtonColumns)));
            this.maxVisibleButtonRows = maxVisibleButtonRows;
            this.updateMaxDimension();
            this.scroll = new JScrollPane(this.buttonPanel, 22, 31);
            this.scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.buttonPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.scroll.setOpaque(false);
            this.scroll.getViewport().setOpaque(false);
            this.setLayout(new IconPopupLayout());
            this.add(this.scroll);
            this.setBorder(new Border(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(0, 0, 1, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(RadianceColorSchemeUtilities.getColorScheme((Component)c, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.FILL, (ComponentState)ComponentState.ENABLED).getDarkColor());
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            });
        }

        public void updateMaxDimension() {
            if (this.buttonPanel == null) {
                return;
            }
            this.buttonPanel.setPreferredSize(null);
            Dimension prefIconPanelDim = this.buttonPanel.getPreferredSize();
            BasicCommandButtonPanelUI panelUI = (BasicCommandButtonPanelUI)this.buttonPanel.getUI();
            int titlePanelCount = ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).isToShowGroupLabels() ? 1 : 0;
            this.maxDimension = new Dimension(prefIconPanelDim.width, panelUI.getPreferredHeight(this.maxVisibleButtonRows, titlePanelCount));
            this.setPreferredSize(null);
        }

        protected class IconPopupLayout
        implements LayoutManager {
            protected IconPopupLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                int left = insets.left;
                int right = insets.right;
                int top = insets.top;
                int bottom = insets.bottom;
                ScrollableCommandButtonPanel.this.scroll.setBounds(left, top, parent.getWidth() - left - right, parent.getHeight() - top - bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Insets insets = parent.getInsets();
                int left = insets.left;
                int right = insets.right;
                int top = insets.top;
                int bottom = insets.bottom;
                Dimension controlPanelDim = ScrollableCommandButtonPanel.this.buttonPanel.getPreferredSize();
                if (controlPanelDim == null) {
                    controlPanelDim = new Dimension(0, 0);
                }
                int w = Math.min(controlPanelDim.width, ((ScrollableCommandButtonPanel)ScrollableCommandButtonPanel.this).maxDimension.width) + left + right;
                int h = Math.min(controlPanelDim.height, ((ScrollableCommandButtonPanel)ScrollableCommandButtonPanel.this).maxDimension.height) + top + bottom;
                if (h == ((ScrollableCommandButtonPanel)ScrollableCommandButtonPanel.this).maxDimension.height + top + bottom) {
                    int scrollBarWidth = RadianceSizeUtils.getScrollBarWidth((int)RadianceSizeUtils.getControlFontSize());
                    w += scrollBarWidth;
                }
                return new Dimension(w, h);
            }
        }
    }
}

