/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.CommandButtonLayoutManager;
import org.pushingpixels.radiance.component.api.common.HorizontalAlignment;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.model.BaseCommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;

public class CommandButtonLayoutManagerMedium
implements CommandButtonLayoutManager {
    @Override
    public Dimension getPreferredIconSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        Font presentationFont = presentationModel.getFont();
        if (presentationFont == null) {
            presentationFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        int size = ComponentUtilities.getCommandButtonSmallIconSize(presentationFont.getSize());
        return new Dimension(size, size);
    }

    protected float getIconTextGapFactor() {
        return 1.0f;
    }

    @Override
    public Dimension getPreferredSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
        Insets borderInsets = presentationModel.getContentPadding();
        Font presentationFont = presentationModel.getFont();
        if (presentationFont == null) {
            presentationFont = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        }
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor(null), (Font)presentationFont);
        String buttonText = command.getText();
        int layoutHGap = ComponentUtilities.getHLayoutGap(presentationModel);
        boolean hasIcon = command.getIconFactory() != null || presentationModel.isForceAllocateSpaceForIcon();
        boolean hasText = buttonText != null;
        boolean hasPopupIcon = command.hasSecondaryContent();
        int prefIconWidth = hasIcon ? this.getPreferredIconSize((BaseCommand)command, (BaseCommandButtonPresentationModel)presentationModel).width : 0;
        int prefIconHeight = hasIcon ? this.getPreferredIconSize((BaseCommand)command, (BaseCommandButtonPresentationModel)presentationModel).height : 0;
        int width = borderInsets.left;
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconWidth;
            width += layoutHGap;
        }
        if (hasText) {
            width = hasIcon ? (width += (int)((float)layoutHGap * this.getIconTextGapFactor())) : (width += layoutHGap);
            width += fm.stringWidth(buttonText);
            width += layoutHGap;
        }
        if (hasPopupIcon && presentationModel.isShowPopupIcon()) {
            if (hasText || hasIcon) {
                width += layoutHGap;
            }
            width += presentationModel.getPopupIcon().getIconWidth();
            width += layoutHGap;
        }
        CommandButtonLayoutManager.CommandButtonKind buttonKind = this.getCommandButtonKind(command, presentationModel);
        boolean hasSeparator = false;
        if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION && (hasIcon || hasText)) {
            hasSeparator = true;
        }
        if (buttonKind == CommandButtonLayoutManager.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP && hasIcon) {
            hasSeparator = true;
        }
        if (hasSeparator) {
            width += new JSeparator((int)1).getPreferredSize().width;
        }
        width += borderInsets.right;
        return new Dimension(width -= 2 * layoutHGap, by + Math.max(prefIconHeight, fm.getAscent() + fm.getDescent()));
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        boolean hasIcon = commandButton.getContentModel().getIconFactory() != null || commandButton.getPresentationModel().isForceAllocateSpaceForIcon();
        int height = commandButton.getHeight();
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            int x = hasIcon ? layoutInfo.iconRect.x + layoutInfo.iconRect.width : layoutInfo.actionClickArea.x + layoutInfo.actionClickArea.width;
            return new Point(x, (height + layoutInfo.actionClickArea.height) / 2);
        }
        int x = hasIcon ? layoutInfo.iconRect.x : layoutInfo.actionClickArea.x;
        return new Point(x, (height + layoutInfo.actionClickArea.height) / 2);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        int height = commandButton.getHeight();
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width, (height + layoutInfo.popupClickArea.height) / 2);
        }
        return new Point(layoutInfo.popupClickArea.x, (height + layoutInfo.popupClickArea.height) / 2);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        BaseCommandButtonPresentationModel<BaseCommandPopupMenuPresentationModel, BaseCommandButtonPresentationModel<?, ?>> presentationModel = commandButton.getPresentationModel();
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        String buttonText = commandButton.getContentModel().getText();
        Dimension iconSize = this.getPreferredIconSize(commandButton.getContentModel(), commandButton.getPresentationModel());
        int iconWidth = iconSize.width;
        int iconHeight = iconSize.height;
        boolean hasIcon = commandButton.getContentModel().getIconFactory() != null || commandButton.getPresentationModel().isForceAllocateSpaceForIcon();
        boolean hasText = buttonText != null;
        boolean hasPopupIcon = commandButton.getContentModel().hasSecondaryContent();
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        int prefWidth = this.getPreferredSize(commandButton.getContentModel(), commandButton.getPresentationModel()).width;
        int shiftX = 0;
        if (width > prefWidth) {
            switch (presentationModel.getHorizontalAlignment()) {
                case LEADING: 
                case FILL: {
                    break;
                }
                case CENTER: {
                    shiftX = (width - prefWidth) / 2;
                    break;
                }
                case TRAILING: {
                    shiftX = width - prefWidth;
                }
            }
        }
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)commandButton), (Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        CommandButtonLayoutManager.CommandButtonKind buttonKind = this.getCommandButtonKind(commandButton);
        int layoutHGap = ComponentUtilities.getHLayoutGap(commandButton);
        if (ltr) {
            int x = ins.left + shiftX - layoutHGap;
            if (hasIcon) {
                result.iconRect.x = x += layoutHGap;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x += iconWidth + layoutHGap;
            }
            if (hasText) {
                x = hasIcon ? (x += (int)((float)layoutHGap * this.getIconTextGapFactor())) : (x += layoutHGap);
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                lineLayoutInfo.text = buttonText;
                lineLayoutInfo.textRect = new Rectangle();
                result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.textLayoutInfoList.add(lineLayoutInfo);
                lineLayoutInfo.textRect.x = x;
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
                lineLayoutInfo.textRect.width = fm.stringWidth(buttonText);
                lineLayoutInfo.textRect.height = labelHeight;
                x += lineLayoutInfo.textRect.width;
                x += layoutHGap;
            }
            if (hasPopupIcon && presentationModel.isShowPopupIcon()) {
                int popupIconWidth = presentationModel.getPopupIcon().getIconWidth();
                int popupIconHeight = presentationModel.getPopupIcon().getIconHeight();
                if (hasText || hasIcon) {
                    x = presentationModel.getHorizontalAlignment() == HorizontalAlignment.FILL ? width - ins.right - layoutHGap - popupIconWidth : (x += layoutHGap);
                }
                if (!hasText && !hasIcon) {
                    x += (width - 2 * layoutHGap - popupIconWidth) / 2;
                }
                result.popupActionRect.x = x;
                result.popupActionRect.y = (height - popupIconHeight) / 2;
                result.popupActionRect.width = popupIconWidth;
                result.popupActionRect.height = popupIconHeight;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: {
                    if (hasText || hasIcon) {
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.popupActionRect.x - layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        if (result.textLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : result.textLayoutInfoList) {
                                textLayoutInfo.textRect.x += verticalSeparatorWidth;
                            }
                        }
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.iconRect.x + result.iconRect.width + layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = false;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        } else {
            int x = width - ins.right - shiftX + layoutHGap;
            if (hasIcon) {
                result.iconRect.x = (x -= layoutHGap) - iconWidth;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x -= iconWidth + layoutHGap;
            }
            if (hasText) {
                x = hasIcon ? (x -= (int)((float)layoutHGap * this.getIconTextGapFactor())) : (x -= layoutHGap);
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                lineLayoutInfo.text = buttonText;
                lineLayoutInfo.textRect = new Rectangle();
                result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.textLayoutInfoList.add(lineLayoutInfo);
                lineLayoutInfo.textRect.width = fm.stringWidth(buttonText);
                lineLayoutInfo.textRect.x = x - lineLayoutInfo.textRect.width;
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
                lineLayoutInfo.textRect.height = labelHeight;
                x -= lineLayoutInfo.textRect.width;
                x -= layoutHGap;
            }
            if (hasPopupIcon && presentationModel.isShowPopupIcon()) {
                int popupIconWidth = presentationModel.getPopupIcon().getIconWidth();
                int popupIconHeight = presentationModel.getPopupIcon().getIconHeight();
                if (hasText || hasIcon) {
                    x = presentationModel.getHorizontalAlignment() == HorizontalAlignment.FILL ? ins.left + layoutHGap : (x -= 2 * layoutHGap);
                }
                if (!hasText && !hasIcon) {
                    x -= (width - 2 * layoutHGap - popupIconWidth) / 2;
                }
                result.popupActionRect.width = popupIconWidth;
                result.popupActionRect.x = x - result.popupActionRect.width;
                result.popupActionRect.y = (height - popupIconHeight) / 2;
                result.popupActionRect.height = popupIconHeight;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: {
                    if (hasText || hasIcon) {
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.popupActionRect.x + result.popupActionRect.width + layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        if (result.textLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : result.textLayoutInfoList) {
                                textLayoutInfo.textRect.x -= verticalSeparatorWidth;
                            }
                        }
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.iconRect.x - layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = false;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        }
        return result;
    }

    public static class FitToIcon
    extends CommandButtonLayoutManagerMedium {
        @Override
        public Dimension getPreferredIconSize(BaseCommand command, BaseCommandButtonPresentationModel presentationModel) {
            Dimension preferredIconDimension = presentationModel.getIconDimension();
            if (preferredIconDimension != null) {
                return preferredIconDimension;
            }
            return super.getPreferredIconSize(command, presentationModel);
        }
    }
}

