/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.model.TriStateButtonModel;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionChangeEvent;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionChangeListener;
import org.pushingpixels.radiance.common.api.model.TriStateSelectionCycler;
import org.pushingpixels.radiance.component.api.common.JTriStateCheckBox;
import org.pushingpixels.radiance.component.api.common.model.TriStateCheckBoxContentModel;
import org.pushingpixels.radiance.component.internal.theming.common.tristate.RolloverTriStateListener;
import org.pushingpixels.radiance.component.internal.ui.common.TriStateCheckBoxUI;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public abstract class BasicTriStateCheckBoxUI
extends TriStateCheckBoxUI
implements TransitionAwareUI {
    protected JTriStateCheckBox triStateCheckBox;
    private PropertyChangeListener componentPropertyChangeListener;
    private PropertyChangeListener projectionPropertyChangeListener;
    private TriStateSelectionChangeListener selectionChangeListener;
    private RolloverTriStateListener basicButtonListener;
    protected StateTransitionTracker stateTransitionTracker;
    protected Rectangle viewRect = new Rectangle();
    protected Rectangle iconRect = new Rectangle();
    protected Rectangle textRect = new Rectangle();
    protected int iconTextGap = 0;
    protected Icon radianceIcon;

    public BasicTriStateCheckBoxUI(JTriStateCheckBox triStateCheckBox) {
        this.triStateCheckBox = triStateCheckBox;
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)this.triStateCheckBox, this.triStateCheckBox.getTriStateButtonModel());
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(c);
        this.triStateCheckBox = null;
    }

    protected void installDefaults() {
        Border border = this.triStateCheckBox.getBorder();
        if (border == null || border instanceof UIResource) {
            this.triStateCheckBox.setBorder(RadianceSizeUtils.getCheckBoxBorder((int)RadianceSizeUtils.getComponentFontSize((Component)this.triStateCheckBox), (boolean)this.triStateCheckBox.getComponentOrientation().isLeftToRight()));
        }
        this.iconTextGap = RadianceSizeUtils.getTextIconGap((int)RadianceSizeUtils.getComponentFontSize((Component)this.triStateCheckBox));
        this.updateIcon();
    }

    protected void installListeners() {
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.basicButtonListener = new RolloverTriStateListener(this.triStateCheckBox, this.stateTransitionTracker);
        this.triStateCheckBox.addMouseListener(this.basicButtonListener);
        this.triStateCheckBox.addMouseMotionListener(this.basicButtonListener);
        this.triStateCheckBox.addFocusListener(this.basicButtonListener);
        this.triStateCheckBox.addChangeListener(this.basicButtonListener);
        this.componentPropertyChangeListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(this.triStateCheckBox::updateUI);
            }
        };
        this.triStateCheckBox.addPropertyChangeListener(this.componentPropertyChangeListener);
        this.projectionPropertyChangeListener = propertyChangeEvent -> {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.triStateCheckBox.getTriStateButtonModel().setEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
            if ("selectionState".equals(propertyChangeEvent.getPropertyName())) {
                this.triStateCheckBox.getTriStateButtonModel().setSelectionState((TriStateButtonModel.SelectionState)propertyChangeEvent.getNewValue());
            }
            if ("selectionCycler".equals(propertyChangeEvent.getPropertyName())) {
                this.triStateCheckBox.getTriStateButtonModel().setSelectionCycler((TriStateSelectionCycler)propertyChangeEvent.getNewValue());
            }
            this.triStateCheckBox.invalidate();
            this.triStateCheckBox.revalidate();
            this.triStateCheckBox.repaint();
        };
        ((TriStateCheckBoxContentModel)this.triStateCheckBox.getProjection().getContentModel()).addPropertyChangeListener(this.projectionPropertyChangeListener);
        this.selectionChangeListener = new TriStateSelectionChangeListener(){

            public void itemTriStateSelectionChanged(TriStateSelectionChangeEvent e) {
                TriStateSelectionChangeListener selectionChangeListener = ((TriStateCheckBoxContentModel)BasicTriStateCheckBoxUI.this.triStateCheckBox.getProjection().getContentModel()).getSelectionChangeListener();
                if (selectionChangeListener != null) {
                    selectionChangeListener.itemTriStateSelectionChanged(new TriStateSelectionChangeEvent((Object)BasicTriStateCheckBoxUI.this.triStateCheckBox, 701, (Object)this, e.getSelectionStateChange()));
                }
            }
        };
        this.triStateCheckBox.getTriStateButtonModel().addSelectionChangeListener(this.selectionChangeListener);
    }

    protected void installKeyboardActions() {
        this.basicButtonListener.installKeyboardActions();
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.triStateCheckBox);
    }

    protected void uninstallKeyboardActions() {
        this.basicButtonListener.uninstallKeyboardActions();
    }

    protected void uninstallListeners() {
        this.triStateCheckBox.getTriStateButtonModel().removeSelectionChangeListener(this.selectionChangeListener);
        this.selectionChangeListener = null;
        this.triStateCheckBox.removePropertyChangeListener(this.componentPropertyChangeListener);
        this.componentPropertyChangeListener = null;
        ((TriStateCheckBoxContentModel)this.triStateCheckBox.getProjection().getContentModel()).removePropertyChangeListener(this.projectionPropertyChangeListener);
        this.projectionPropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.triStateCheckBox.removeMouseListener(this.basicButtonListener);
        this.triStateCheckBox.removeMouseMotionListener(this.basicButtonListener);
        this.triStateCheckBox.removeFocusListener(this.basicButtonListener);
        this.triStateCheckBox.removeChangeListener(this.basicButtonListener);
        this.basicButtonListener = null;
    }

    protected void uninstallComponents() {
    }

    protected abstract void updateIcon();

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String text = ((TriStateCheckBoxContentModel)this.triStateCheckBox.getProjection().getContentModel()).getText();
        Icon buttonIcon = this.radianceIcon;
        FontMetrics fm = RadianceMetricsUtilities.getFontMetrics((double)RadianceCommonCortex.getScaleFactor((Component)this.triStateCheckBox), (Font)this.triStateCheckBox.getFont());
        this.iconRect.setRect(0.0, 0.0, 0.0, 0.0);
        this.textRect.setRect(0.0, 0.0, 0.0, 0.0);
        this.viewRect.setRect(0.0, 0.0, 32767.0, 32767.0);
        SwingUtilities.layoutCompoundLabel(this.triStateCheckBox, fm, text, buttonIcon, 0, 0, 0, 11, this.viewRect, this.iconRect, this.textRect, text == null ? 0 : this.iconTextGap);
        int minLeft = Math.min(this.iconRect.x, this.textRect.x);
        int maxRight = Math.max(this.iconRect.x + this.iconRect.width, this.textRect.x + this.textRect.width);
        int minTop = Math.min(this.iconRect.y, this.textRect.y);
        int maxBottom = Math.max(this.iconRect.y + this.iconRect.height, this.textRect.y + this.textRect.height);
        int width = maxRight - minLeft;
        int height = maxBottom - minTop;
        Insets insets = this.triStateCheckBox.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g, c);
        g2d.dispose();
    }
}

