/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.JSwitch;
import org.pushingpixels.radiance.component.api.common.model.SwitchContentModel;
import org.pushingpixels.radiance.component.api.common.model.SwitchPresentationModel;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RolloverButtonListener;

public abstract class BasicSwitchUI
extends BasicToggleButtonUI
implements TransitionAwareUI {
    protected JSwitch switchComp;
    private PropertyChangeListener componentPropertyChangeListener;
    private PropertyChangeListener projectionPropertyChangeListener;
    protected StateTransitionTracker stateTransitionTracker;

    public BasicSwitchUI(JSwitch switchComp) {
        this.switchComp = switchComp;
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)this.switchComp, this.switchComp.getModel());
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.switchComp = null;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (this.switchComp.getProjection() == null) {
            return;
        }
        Border border = this.switchComp.getBorder();
        if (border == null || border instanceof UIResource) {
            this.switchComp.setBorder(new BorderUIResource.EmptyBorderUIResource(((SwitchPresentationModel)this.switchComp.getProjection().getPresentationModel()).getContentPadding()));
        }
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        if (this.switchComp.getProjection() == null) {
            return;
        }
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.componentPropertyChangeListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(this.switchComp::updateUI);
            }
        };
        this.switchComp.addPropertyChangeListener(this.componentPropertyChangeListener);
        this.projectionPropertyChangeListener = propertyChangeEvent -> {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.switchComp.getModel().setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
            if ("selected".equals(propertyChangeEvent.getPropertyName())) {
                this.switchComp.getModel().setSelected((Boolean)propertyChangeEvent.getNewValue());
            }
            this.switchComp.invalidate();
            this.switchComp.revalidate();
            this.switchComp.repaint();
        };
        ((SwitchContentModel)this.switchComp.getProjection().getContentModel()).addPropertyChangeListener(this.projectionPropertyChangeListener);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        LookAndFeel.uninstallBorder(this.switchComp);
        super.uninstallDefaults(b);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        this.switchComp.removePropertyChangeListener(this.componentPropertyChangeListener);
        this.componentPropertyChangeListener = null;
        ((SwitchContentModel)this.switchComp.getProjection().getContentModel()).removePropertyChangeListener(this.projectionPropertyChangeListener);
        this.projectionPropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        super.uninstallListeners(b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b, this.stateTransitionTracker);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Insets insets = this.switchComp.getInsets();
        Dimension trackSize = ((SwitchPresentationModel)this.switchComp.getProjection().getPresentationModel()).getTrackSize();
        int width = insets.left + trackSize.width + insets.right;
        int height = insets.top + trackSize.height + insets.bottom;
        return new Dimension(width, height);
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g, c);
        g2d.dispose();
    }
}

