/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.HorizontalAlignment;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.JScrollablePanel;
import org.pushingpixels.radiance.component.api.common.icon.CommandButtonFollowColorSchemeIcon;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.internal.ui.common.ScrollablePanelUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public abstract class BasicScrollablePanelUI
extends ScrollablePanelUI {
    protected JScrollablePanel scrollablePanel;
    private JPanel viewport;
    private Command leadingScrollCommand;
    private Command trailingScrollCommand;
    private JCommandButton leadingScroller;
    private JCommandButton trailingScroller;
    private int viewOffset;
    private MouseWheelListener mouseWheelListener;
    private PropertyChangeListener propertyChangeListener;
    private ComponentListener componentListener;

    @Override
    public void installUI(JComponent c) {
        this.scrollablePanel = (JScrollablePanel)c;
        super.installUI(this.scrollablePanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    protected void installListeners() {
        this.mouseWheelListener = mouseWheelEvent -> {
            if (this.scrollablePanel.getScrollType() != JScrollablePanel.ScrollType.VERTICALLY) {
                return;
            }
            int scrollAmount = 8 * mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
            this.viewOffset += scrollAmount;
            this.syncScrolling();
        };
        this.scrollablePanel.addMouseWheelListener(this.mouseWheelListener);
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("scrollOnRollover".equals(propertyChangeEvent.getPropertyName())) {
                this.scrollablePanel.remove(this.leadingScroller);
                this.scrollablePanel.remove(this.trailingScroller);
                this.syncScrollers();
            }
        };
        this.scrollablePanel.addPropertyChangeListener(this.propertyChangeListener);
        if (this.scrollablePanel.getView() != null) {
            this.componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    BasicScrollablePanelUI.this.scrollablePanel.doLayout();
                }
            };
            ((Component)this.scrollablePanel.getView()).addComponentListener(this.componentListener);
        }
    }

    protected void installComponents() {
        this.viewport = new JPanel(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(10, 10);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Object view = BasicScrollablePanelUI.this.scrollablePanel.getView();
                if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                    int viewWidth = ((JComponent)view).getPreferredSize().width;
                    int availWidth = parent.getWidth();
                    int offsetX = -BasicScrollablePanelUI.this.viewOffset;
                    ((Component)view).setBounds(offsetX, 0, Math.max(viewWidth, availWidth), parent.getHeight());
                } else {
                    int viewHeight = ((JComponent)view).getPreferredSize().height;
                    int availHeight = parent.getHeight();
                    int offsetY = -BasicScrollablePanelUI.this.viewOffset;
                    ((Component)view).setBounds(0, offsetY, parent.getWidth(), Math.max(viewHeight, availHeight));
                }
            }
        });
        Object view = this.scrollablePanel.getView();
        if (view != null) {
            this.viewport.add((Component)view);
        }
        this.scrollablePanel.add(this.viewport);
        int fontSize = RadianceSizeUtils.getComponentFontSize(null);
        int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        this.leadingScrollCommand = ((Command.Builder)((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            this.viewOffset -= 12;
            this.syncScrolling();
        })).setIconFactory(() -> new CommandButtonFollowColorSchemeIcon((g, scheme, width, height) -> BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 7 : 1), (RadianceColorScheme)scheme), new Dimension(arrowIconHeight, arrowIconWidth)))).build();
        this.trailingScrollCommand = ((Command.Builder)((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            this.viewOffset += 12;
            this.syncScrolling();
        })).setIconFactory(() -> new CommandButtonFollowColorSchemeIcon((g, scheme, width, height) -> BladeArrowIconUtils.drawDoubleArrow((Graphics2D)g, (float)width, (float)height, (float)RadianceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)RadianceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 3 : 5), (RadianceColorScheme)scheme), new Dimension(arrowIconHeight, arrowIconWidth)))).build();
        this.syncScrollers();
    }

    private void syncScrollers() {
        int fontSize = RadianceSizeUtils.getComponentFontSize(null);
        int arrowIconWidth = (int)RadianceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        int arrowIconHeight = (int)RadianceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        CommandButtonPresentationModel scrollerActionsPresentation = ((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL_FIT_TO_ICON)).setIconDimension(new Dimension(arrowIconHeight, arrowIconWidth))).setContentPadding(new Insets(2, 2, 2, 2))).setFocusable(false)).setToDismissPopupsOnActivation(false)).setHorizontalAlignment(HorizontalAlignment.CENTER)).setBackgroundAppearanceStrategy(RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT)).setActionFireTrigger(this.scrollablePanel.isScrollOnRollover() ? BaseCommandButtonPresentationModel.ActionFireTrigger.ON_ROLLOVER : BaseCommandButtonPresentationModel.ActionFireTrigger.ON_PRESS_RELEASED)).setAutoRepeatAction(true)).setAutoRepeatActionIntervals(200, 50)).build();
        CommandButtonProjection<Command> leadingScrollerProjection = this.leadingScrollCommand.project(scrollerActionsPresentation.overlayWith(CommandButtonPresentationModel.overlay().setSides(RadianceThemingSlices.Sides.builder().setStraightSides(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(RadianceThemingSlices.Side.TRAILING) : EnumSet.of(RadianceThemingSlices.Side.BOTTOM)).build())));
        CommandButtonProjection<Command> trailingScrollerProjection = this.trailingScrollCommand.project(scrollerActionsPresentation.overlayWith(CommandButtonPresentationModel.overlay().setSides(RadianceThemingSlices.Sides.builder().setStraightSides(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(RadianceThemingSlices.Side.LEADING) : EnumSet.of(RadianceThemingSlices.Side.TOP)).build())));
        this.leadingScroller = (JCommandButton)leadingScrollerProjection.buildComponent();
        this.scrollablePanel.add(this.leadingScroller);
        this.trailingScroller = (JCommandButton)trailingScrollerProjection.buildComponent();
        this.scrollablePanel.add(this.trailingScroller);
    }

    protected void installDefaults() {
        this.scrollablePanel.setLayout(new ScrollablePanelLayout());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.scrollablePanel);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        this.scrollablePanel.remove(this.viewport);
        this.scrollablePanel.remove(this.leadingScroller);
        this.scrollablePanel.remove(this.trailingScroller);
    }

    protected void uninstallListeners() {
        this.scrollablePanel.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.scrollablePanel.removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        if (this.scrollablePanel.getView() != null) {
            ((Component)this.scrollablePanel.getView()).removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    private void syncScrolling() {
        this.scrollablePanel.doLayout();
    }

    @Override
    public void scrollToIfNecessary(int startPosition, int span) {
        if (this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
            if (this.scrollablePanel.getComponentOrientation().isLeftToRight()) {
                this.revealRightEdge(startPosition, span);
                this.revealLeftEdge(startPosition);
            } else {
                this.revealLeftEdge(startPosition);
                this.revealRightEdge(startPosition, span);
            }
        } else {
            this.revealBottomEdge(startPosition, span);
            this.revealTopEdge(startPosition);
        }
    }

    private void revealLeftEdge(int x) {
        if (x < this.viewOffset) {
            this.viewOffset = x - 5;
            this.syncScrolling();
        }
    }

    private void revealRightEdge(int x, int width) {
        if (x + width > this.viewOffset + this.viewport.getWidth()) {
            this.viewOffset = x + width - this.viewport.getWidth() + 5;
            this.syncScrolling();
        }
    }

    private void revealTopEdge(int y) {
        if (y < this.viewOffset) {
            this.viewOffset = y - 5;
            this.syncScrolling();
        }
    }

    private void revealBottomEdge(int y, int height) {
        if (y + height > this.viewOffset + this.viewport.getHeight()) {
            this.viewOffset = y + height - this.viewport.getHeight() + 5;
            this.syncScrolling();
        }
    }

    @Override
    public boolean isShowingScrollButtons() {
        return this.leadingScroller.isVisible();
    }

    protected class ScrollablePanelLayout
    implements LayoutManager {
        private ScrollablePanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                return new Dimension(c.getWidth(), 21);
            }
            return new Dimension(21, c.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                return new Dimension(10, 21);
            }
            return new Dimension(21, 10);
        }

        @Override
        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            Insets ins = c.getInsets();
            Object view = BasicScrollablePanelUI.this.scrollablePanel.getView();
            Dimension viewPrefSize = ((JComponent)view).getPreferredSize();
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                boolean shouldShowScrollerButtons = viewPrefSize.width > width;
                BasicScrollablePanelUI.this.leadingScroller.setVisible(shouldShowScrollerButtons);
                BasicScrollablePanelUI.this.trailingScroller.setVisible(shouldShowScrollerButtons);
                int scrollPanelWidth = shouldShowScrollerButtons ? width - ins.left - ins.right - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().width - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().width - 4 : width - ins.left - ins.right;
                int x = ins.left;
                if (shouldShowScrollerButtons) {
                    int spw = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().width;
                    BasicScrollablePanelUI.this.leadingScroller.setBounds(x, ins.top, spw, height - ins.top - ins.bottom);
                    x += spw + 2;
                }
                BasicScrollablePanelUI.this.viewport.setBounds(x, ins.top, scrollPanelWidth, height - ins.top - ins.bottom);
                int viewPreferredWidth = ((JComponent)view).getPreferredSize().width;
                if (BasicScrollablePanelUI.this.viewOffset < 0) {
                    BasicScrollablePanelUI.this.viewOffset = 0;
                }
                if (viewPreferredWidth > 0 && BasicScrollablePanelUI.this.viewOffset + scrollPanelWidth > viewPreferredWidth) {
                    BasicScrollablePanelUI.this.viewOffset = Math.max(0, viewPreferredWidth - scrollPanelWidth);
                }
                BasicScrollablePanelUI.this.viewport.doLayout();
                x += scrollPanelWidth + 2;
                if (shouldShowScrollerButtons) {
                    int spw = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().width;
                    BasicScrollablePanelUI.this.trailingScroller.setBounds(x, ins.top, spw, height - ins.top - ins.bottom);
                }
            } else {
                boolean shouldShowScrollerButtons = viewPrefSize.height > height;
                BasicScrollablePanelUI.this.leadingScroller.setVisible(shouldShowScrollerButtons);
                BasicScrollablePanelUI.this.trailingScroller.setVisible(shouldShowScrollerButtons);
                int scrollPanelHeight = shouldShowScrollerButtons ? height - ins.top - ins.bottom - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().height - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().height - 4 : height - ins.top - ins.bottom;
                int y = ins.top;
                if (shouldShowScrollerButtons) {
                    int sph = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().height;
                    BasicScrollablePanelUI.this.leadingScroller.setBounds(ins.left, y, width - ins.left - ins.right, sph);
                    y += sph + 2;
                }
                BasicScrollablePanelUI.this.viewport.setBounds(ins.left, y, width - ins.left - ins.right, scrollPanelHeight);
                int viewPreferredHeight = ((JComponent)view).getPreferredSize().height;
                if (BasicScrollablePanelUI.this.viewOffset < 0) {
                    BasicScrollablePanelUI.this.viewOffset = 0;
                }
                if (viewPreferredHeight > 0 && BasicScrollablePanelUI.this.viewOffset + scrollPanelHeight > viewPreferredHeight) {
                    BasicScrollablePanelUI.this.viewOffset = Math.max(0, viewPreferredHeight - scrollPanelHeight);
                }
                BasicScrollablePanelUI.this.viewport.doLayout();
                y += scrollPanelHeight + 2;
                if (shouldShowScrollerButtons) {
                    int sph = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().height;
                    BasicScrollablePanelUI.this.trailingScroller.setBounds(ins.left, y, width - ins.left - ins.right, sph);
                }
            }
            BasicScrollablePanelUI.this.leadingScrollCommand.setActionEnabled(BasicScrollablePanelUI.this.viewOffset > 0);
            BasicScrollablePanelUI.this.trailingScrollCommand.setActionEnabled(BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? BasicScrollablePanelUI.this.viewOffset + BasicScrollablePanelUI.this.viewport.getWidth() < ((JComponent)view).getWidth() : BasicScrollablePanelUI.this.viewOffset + BasicScrollablePanelUI.this.viewport.getHeight() < ((JComponent)view).getHeight());
        }
    }
}

