/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.internal.theming.common.GlowingRadianceIcon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

public class CommandButtonBackgroundDelegate {
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    public void paintCommandButtonIcon(Graphics2D g, Rectangle iconRect, JCommandButton commandButton, Icon regular, GlowingRadianceIcon glowingIcon, ButtonModel model, StateTransitionTracker stateTransitionTracker, Color textColor) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(iconRect.x, iconRect.y);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        float alpha = stateTransitionTracker.getActiveStrength();
        if (alpha > 0.0f && glowingIcon != null && model.isEnabled() && AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.ICON_GLOW, (Component)commandButton) && stateTransitionTracker.getIconGlowTracker().isPlaying()) {
            glowingIcon.paintIcon(commandButton, g2d, 0, 0);
            return;
        }
        if (regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular.paintIcon(commandButton, g2d, 0, 0);
            return;
        }
        StateTransitionTracker.ModelStateInfo stateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currentState = stateInfo.getCurrModelState();
        if (currentState.isDisabled()) {
            Icon disabledIcon = RadianceCoreUtilities.getFilteredIcon((JComponent)commandButton, (Icon)regular, (ComponentState)currentState, (Color)textColor);
            disabledIcon.paintIcon(commandButton, g2d, 0, 0);
        } else {
            Icon enabledIcon = RadianceCoreUtilities.getFilteredIcon((JComponent)commandButton, (Icon)regular, (ComponentState)ComponentState.ENABLED, (Color)textColor);
            enabledIcon.paintIcon(commandButton, g2d, 0, 0);
            if (stateTransitionTracker.getActiveStrength() > 0.0f) {
                for (Map.Entry entry : stateInfo.getStateContributionMap().entrySet()) {
                    Icon activeIcon;
                    float contribution;
                    if (entry.getKey() == ComponentState.ENABLED || !((contribution = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) > 0.0f) || (activeIcon = RadianceCoreUtilities.getFilteredIcon((JComponent)commandButton, (Icon)regular, (ComponentState)((ComponentState)entry.getKey()), (Color)textColor)) == enabledIcon) continue;
                    g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)commandButton, (float)contribution, (Graphics)g));
                    activeIcon.paintIcon(commandButton, g2d, 0, 0);
                }
            }
        }
        g2d.dispose();
    }

    public void updateBackground(Graphics2D g, JCommandButton commandButton, StateTransitionTracker actionTransitionTracker, Rectangle actionArea, StateTransitionTracker popupTransitionTracker, Rectangle popupArea) {
        float popupAlpha;
        float actionAlpha;
        boolean ignoreSelectedState = commandButton.getContentModel().isToggle() && commandButton.getPresentationModel().getSelectedStateHighlight() == BaseCommandButtonPresentationModel.SelectedStateHighlight.ICON_ONLY;
        ComponentState currActionState = ignoreSelectedState ? actionTransitionTracker.getModelStateInfo().getCurrModelStateNoSelection() : actionTransitionTracker.getModelStateInfo().getCurrModelState();
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableFillColorScheme, (StateTransitionTracker.ModelStateInfo)actionTransitionTracker.getModelStateInfo(), (ComponentState)currActionState, (BladeUtils.ColorSchemeDelegate)BladeUtils.getDefaultColorSchemeDelegate((Component)commandButton, state -> RadianceThemingSlices.ColorSchemeAssociationKind.FILL), (boolean)ignoreSelectedState);
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableBorderColorScheme, (StateTransitionTracker.ModelStateInfo)actionTransitionTracker.getModelStateInfo(), (ComponentState)currActionState, (BladeUtils.ColorSchemeDelegate)BladeUtils.getDefaultColorSchemeDelegate((Component)commandButton, state -> RadianceThemingSlices.ColorSchemeAssociationKind.BORDER), (boolean)ignoreSelectedState);
        if (commandButton.getPresentationModel().getBackgroundAppearanceStrategy() == RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT) {
            if (currActionState == ComponentState.DISABLED_SELECTED) {
                actionAlpha = RadianceColorSchemeUtilities.getAlpha((Component)commandButton, (ComponentState)currActionState);
            } else {
                actionAlpha = 0.0f;
                Map actionStates = ignoreSelectedState ? actionTransitionTracker.getModelStateInfo().getStateNoSelectionContributionMap() : actionTransitionTracker.getModelStateInfo().getStateContributionMap();
                for (Map.Entry activeEntry : actionStates.entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    actionAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                actionAlpha = Math.max(actionAlpha, popupTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER));
            }
        } else {
            actionAlpha = currActionState.isDisabled() ? RadianceColorSchemeUtilities.getAlpha((Component)commandButton, (ComponentState)currActionState) : 1.0f;
        }
        this.drawArea(g, commandButton, actionAlpha, actionArea);
        ComponentState currPopupState = popupTransitionTracker.getModelStateInfo().getCurrModelState();
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableFillColorScheme, (StateTransitionTracker.ModelStateInfo)popupTransitionTracker.getModelStateInfo(), (ComponentState)currPopupState, (BladeUtils.ColorSchemeDelegate)BladeUtils.getDefaultColorSchemeDelegate((Component)commandButton, state -> RadianceThemingSlices.ColorSchemeAssociationKind.FILL), (boolean)false);
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableBorderColorScheme, (StateTransitionTracker.ModelStateInfo)popupTransitionTracker.getModelStateInfo(), (ComponentState)currPopupState, (BladeUtils.ColorSchemeDelegate)BladeUtils.getDefaultColorSchemeDelegate((Component)commandButton, state -> RadianceThemingSlices.ColorSchemeAssociationKind.BORDER), (boolean)false);
        if (commandButton.getPresentationModel().getBackgroundAppearanceStrategy() == RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT) {
            if (currPopupState == ComponentState.DISABLED_SELECTED) {
                popupAlpha = RadianceColorSchemeUtilities.getAlpha((Component)commandButton, (ComponentState)currPopupState);
            } else {
                popupAlpha = 0.0f;
                Map popupStates = popupTransitionTracker.getModelStateInfo().getStateContributionMap();
                for (Map.Entry activeEntry : popupStates.entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    popupAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                popupAlpha = Math.max(popupAlpha, actionTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.ROLLOVER));
            }
        } else {
            popupAlpha = currPopupState.isDisabled() ? RadianceColorSchemeUtilities.getAlpha((Component)commandButton, (ComponentState)currPopupState) : 1.0f;
        }
        this.drawArea(g, commandButton, popupAlpha, popupArea);
    }

    private void drawArea(Graphics2D g, JCommandButton commandButton, float alpha, Rectangle clipArea) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)commandButton, (float)alpha, (Graphics)g));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.clip(clipArea);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)commandButton.getWidth(), (int)commandButton.getHeight(), (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter((Component)commandButton);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter((Component)commandButton);
            RadianceThemingSlices.Sides sides = commandButton.getPresentationModel().getSides();
            Set openSides = sides != null ? sides.getOpenSides() : null;
            Set straightSides = sides != null ? sides.getStraightSides() : null;
            ComponentOrientation orientation = commandButton.getComponentOrientation();
            RadianceThemingSlices.Side leftSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.LEADING : RadianceThemingSlices.Side.TRAILING;
            RadianceThemingSlices.Side rightSide = orientation.isLeftToRight() ? RadianceThemingSlices.Side.TRAILING : RadianceThemingSlices.Side.LEADING;
            int openDelta = (int)(3.0 * scaleFactor);
            int deltaLeft = openSides != null && openSides.contains(leftSide) ? openDelta : 0;
            int deltaRight = openSides != null && openSides.contains(rightSide) ? openDelta : 0;
            int deltaTop = openSides != null && openSides.contains(RadianceThemingSlices.Side.TOP) ? openDelta : 0;
            int deltaBottom = openSides != null && openSides.contains(RadianceThemingSlices.Side.BOTTOM) ? openDelta : 0;
            int dx = -deltaLeft;
            int dw = deltaLeft + deltaRight;
            int dy = -deltaTop;
            int dh = deltaTop + deltaBottom;
            float radius = commandButton.getPresentationModel().getSelectedStateHighlight() == BaseCommandButtonPresentationModel.SelectedStateHighlight.ICON_ONLY ? 0.0f : (float)scaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius((int)RadianceSizeUtils.getComponentFontSize((Component)commandButton));
            graphics1X.translate(dx, dy);
            Shape contourFill = RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)commandButton.getComponentOrientation(), (float)(scaledWidth + dw), (float)(scaledHeight + dh), (float)radius, (Set)straightSides, (float)0.5f);
            fillPainter.paintContourBackground((Graphics)graphics1X, (Component)commandButton, (float)(scaledWidth + dw), (float)(scaledHeight + dh), contourFill, (RadianceColorScheme)this.mutableFillColorScheme);
            Shape contourOuter = RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)commandButton.getComponentOrientation(), (float)(scaledWidth + dw - 1), (float)(scaledHeight + dh - 1), (float)radius, (Set)straightSides, (float)0.0f);
            Shape contourInner = borderPainter.isPaintingInnerContour() ? RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)commandButton.getComponentOrientation(), (float)(scaledWidth + dw - 1), (float)(scaledHeight + dh - 1), (float)radius, (Set)straightSides, (float)1.0f) : null;
            borderPainter.paintBorder((Graphics)graphics1X, (Component)commandButton, (float)(scaledWidth + dw), (float)(scaledHeight + dh), contourOuter, contourInner, (RadianceColorScheme)this.mutableBorderColorScheme);
            graphics1X.translate(-dx, -dy);
        });
        graphics.dispose();
    }
}

