/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.api.common.JSwitch;
import org.pushingpixels.radiance.component.api.common.model.SwitchPresentationModel;
import org.pushingpixels.radiance.component.internal.ui.common.BasicSwitchUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceSwitchUI
extends BasicSwitchUI {
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableMarkColorScheme = new BladeColorScheme();

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceSwitchUI((JSwitch)comp);
    }

    private RadianceSwitchUI(JSwitch switchComp) {
        super(switchComp);
    }

    @Override
    protected String getPropertyPrefix() {
        return "Switch.";
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JSwitch switchComp = (JSwitch)c;
        if (RadianceCoreUtilities.isOpaque((JComponent)c)) {
            BackgroundPaintingUtils.update((Graphics)g, (JComponent)switchComp, (boolean)false);
        }
        Insets i = switchComp.getInsets();
        boolean ltr = switchComp.getComponentOrientation().isLeftToRight();
        Graphics2D g2d = (Graphics2D)g.create();
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.stateTransitionTracker.getModelStateInfo();
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter((Component)switchComp);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter((Component)switchComp);
        ComponentState currState = modelStateInfo.getCurrModelState();
        float alpha = RadianceColorSchemeUtilities.getAlpha((Component)switchComp, (ComponentState)currState);
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableFillColorScheme, (Component)switchComp, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, (boolean)false);
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableBorderColorScheme, (Component)switchComp, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, (boolean)false);
        BladeUtils.populateColorScheme((BladeColorScheme)this.mutableMarkColorScheme, (Component)switchComp, (StateTransitionTracker.ModelStateInfo)modelStateInfo, (ComponentState)currState, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.MARK, (boolean)false);
        SwitchPresentationModel presentationModel = (SwitchPresentationModel)switchComp.getProjection().getPresentationModel();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)switchComp.getWidth(), (int)switchComp.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            float thumbXStart;
            float selectedStartX;
            float unselectedStartX;
            graphics1X.setComposite(WidgetUtilities.getAlphaComposite((Component)switchComp, (float)alpha, (Graphics)graphics1X));
            graphics1X.translate(scaleFactor * (double)i.left, scaleFactor * (double)i.top);
            float trackWidth = (float)presentationModel.getTrackSize().width * (float)scaleFactor;
            float trackHeight = (float)presentationModel.getTrackSize().height * (float)scaleFactor;
            Shape contourFill = RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)switchComp.getComponentOrientation(), (float)trackWidth, (float)trackHeight, (float)(trackHeight * 0.5f), null, (float)0.0f);
            fillPainter.paintContourBackground((Graphics)graphics1X, (Component)switchComp, trackWidth, trackHeight, contourFill, (RadianceColorScheme)this.mutableFillColorScheme);
            Shape contourOuter = RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)switchComp.getComponentOrientation(), (float)trackWidth, (float)trackHeight, (float)(trackHeight * 0.5f), null);
            Shape contourInner = borderPainter.isPaintingInnerContour() ? RadianceOutlineUtilities.getBaseOutline((ComponentOrientation)switchComp.getComponentOrientation(), (float)trackWidth, (float)trackHeight, (float)(trackHeight * 0.5f - 1.0f), null, (float)1.0f) : null;
            borderPainter.paintBorder((Graphics)graphics1X, (Component)switchComp, trackWidth, trackHeight, contourOuter, contourInner, (RadianceColorScheme)this.mutableBorderColorScheme);
            float thumbSelectionFactor = this.stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
            float thumbSizeOff = (float)presentationModel.getThumbSizeOff() * (float)scaleFactor;
            float thumbSizeOn = (float)presentationModel.getThumbSizeOn() * (float)scaleFactor;
            float thumbSize = thumbSizeOff + (thumbSizeOn - thumbSizeOff) * thumbSelectionFactor;
            if (ltr) {
                unselectedStartX = (trackHeight - thumbSizeOff) / 2.0f;
                selectedStartX = trackWidth - (trackHeight - thumbSizeOn) / 2.0f - thumbSizeOn;
                thumbXStart = unselectedStartX + (selectedStartX - unselectedStartX) * thumbSelectionFactor;
            } else {
                unselectedStartX = trackWidth - (trackHeight - thumbSizeOff) / 2.0f - thumbSizeOff;
                selectedStartX = (trackHeight - thumbSizeOn) / 2.0f;
                thumbXStart = selectedStartX + (unselectedStartX - selectedStartX) * (1.0f - thumbSelectionFactor);
            }
            float thumbRadiusPx = thumbSize / 2.0f;
            float thumbVerticalCenterPx = trackHeight / 2.0f;
            Ellipse2D.Double thumbOutline = new Ellipse2D.Double(thumbXStart, thumbVerticalCenterPx - thumbRadiusPx, 2.0f * thumbRadiusPx, 2.0f * thumbRadiusPx);
            graphics1X.setColor(this.mutableMarkColorScheme.getMarkColor());
            graphics1X.fill(thumbOutline);
            graphics1X.translate(-scaleFactor * (double)i.left, -scaleFactor * (double)i.top);
            if (switchComp.isFocusPainted()) {
                float focusRingPadding = RadianceSizeUtils.getFocusRingPadding((Component)switchComp, (int)RadianceSizeUtils.getComponentFontSize((Component)switchComp)) / 2.0f;
                RadianceCoreUtilities.paintFocus((Graphics)graphics1X, (Component)switchComp, (Component)switchComp, (TransitionAwareUI)this, (double)scaleFactor, null, null, (float)1.0f, (float)((float)scaleFactor * focusRingPadding));
            }
        });
        graphics.dispose();
        g2d.dispose();
    }
}

