/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.component.api.common.JExoLabel;
import org.pushingpixels.radiance.component.api.common.model.LabelContentModel;
import org.pushingpixels.radiance.component.api.common.model.LabelPresentationModel;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceExoLabelUI
extends ComponentUI {
    private RadianceIcon icon;
    private JLabel singleLineLabel;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceExoLabelUI();
    }

    protected RadianceExoLabelUI() {
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        JExoLabel label = (JExoLabel)c;
        LabelContentModel contentModel = (LabelContentModel)label.getProjection().getContentModel();
        LabelPresentationModel presentationModel = (LabelPresentationModel)label.getProjection().getPresentationModel();
        RadianceIcon.Factory factory = contentModel.getIconFactory();
        if (factory != null) {
            this.icon = factory.createNewIcon();
            this.icon.setDimension(presentationModel.getIconDimension());
        }
        RadianceThemingCortex.ComponentScope.setIconFilterStrategies((JComponent)label, (RadianceThemingSlices.IconFilterStrategy)presentationModel.getEnabledIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)presentationModel.getEnabledIconFilterStrategy(), (RadianceThemingSlices.IconFilterStrategy)presentationModel.getDisabledIconFilterStrategy());
        this.singleLineLabel = new JLabel(contentModel.getText());
        this.singleLineLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.singleLineLabel.setFocusable(false);
        if (presentationModel.getFont() != null) {
            this.singleLineLabel.setFont(presentationModel.getFont());
        }
        label.add(this.singleLineLabel);
        this.propertyChangeListener = evt -> {
            if ("text".equals(evt.getPropertyName())) {
                String newText = (String)evt.getNewValue();
                this.singleLineLabel.setText(newText);
            }
        };
        contentModel.addPropertyChangeListener(this.propertyChangeListener);
        label.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                JExoLabel label = (JExoLabel)c;
                return RadianceExoLabelUI.getSingleLinePreferredDimension(label);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                JExoLabel label = (JExoLabel)c;
                LabelContentModel contentModel = (LabelContentModel)label.getProjection().getContentModel();
                LabelPresentationModel presentationModel = (LabelPresentationModel)label.getProjection().getPresentationModel();
                int width = label.getWidth();
                int shiftX = 0;
                int preferredWidth = RadianceExoLabelUI.getSingleLineNoPrototypePreferredDimension((JExoLabel)label).width;
                if (preferredWidth < label.getWidth()) {
                    switch (presentationModel.getHorizontalAlignment()) {
                        case LEADING: 
                        case FILL: {
                            break;
                        }
                        case CENTER: {
                            shiftX = (width - preferredWidth) / 2;
                            break;
                        }
                        case TRAILING: {
                            shiftX = width - preferredWidth;
                        }
                    }
                }
                int textLeft = 0;
                int textTop = presentationModel.getContentPadding().top;
                int textRight = 0;
                int textBottom = label.getHeight() - presentationModel.getContentPadding().bottom;
                if (label.getComponentOrientation().isLeftToRight()) {
                    textLeft = contentModel.getIconFactory() == null ? presentationModel.getContentPadding().left : presentationModel.getContentPadding().left + presentationModel.getIconDimension().width + (int)((float)presentationModel.getIconTextGap() * presentationModel.getHorizontalGapScaleFactor());
                    textRight = width - presentationModel.getContentPadding().right;
                } else {
                    textLeft = presentationModel.getContentPadding().left;
                    textRight = contentModel.getIconFactory() == null ? width - presentationModel.getContentPadding().right : width - presentationModel.getContentPadding().right - presentationModel.getIconDimension().width - (int)((float)presentationModel.getIconTextGap() * presentationModel.getHorizontalGapScaleFactor());
                }
                label.getComponent(0).setBounds(shiftX + textLeft, textTop, shiftX + textRight - textLeft, textBottom - textTop);
            }
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        JExoLabel label = (JExoLabel)c;
        LabelContentModel contentModel = (LabelContentModel)label.getProjection().getContentModel();
        contentModel.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        super.uninstallUI(c);
    }

    private static Dimension getSingleLinePreferredDimension(JExoLabel label) {
        int iconWidth;
        LabelContentModel contentModel = (LabelContentModel)label.getProjection().getContentModel();
        LabelPresentationModel presentationModel = (LabelPresentationModel)label.getProjection().getPresentationModel();
        int width = presentationModel.getContentPadding().left + presentationModel.getContentPadding().right;
        int height = presentationModel.getContentPadding().top + presentationModel.getContentPadding().bottom;
        int iconHeight = contentModel.getIconFactory() != null ? presentationModel.getIconDimension().height : 0;
        int n = iconWidth = contentModel.getIconFactory() != null ? presentationModel.getIconDimension().width : 0;
        if (iconWidth > 0) {
            width = width + iconWidth + (int)((float)presentationModel.getIconTextGap() * presentationModel.getHorizontalGapScaleFactor());
        }
        Font font = presentationModel.getFont() != null ? presentationModel.getFont() : label.getFont();
        Dimension textDimension = RadianceMetricsUtilities.getLabelPreferredSingleLineDimension((JComponent)label, (String)contentModel.getText(), (Font)font);
        int textWidth = textDimension.width;
        int textHeight = textDimension.height;
        if (presentationModel.getSingleLineDisplayPrototype() != null) {
            Dimension prototypeTextDimension = RadianceMetricsUtilities.getLabelPreferredSingleLineDimension((JComponent)label, (String)presentationModel.getSingleLineDisplayPrototype(), (Font)font);
            textWidth = Math.max(textWidth, prototypeTextDimension.width);
            textHeight = Math.max(textHeight, prototypeTextDimension.height);
        }
        return new Dimension(width += textWidth, height += Math.max(iconHeight, textHeight));
    }

    private static Dimension getSingleLineNoPrototypePreferredDimension(JExoLabel label) {
        int iconWidth;
        LabelContentModel contentModel = (LabelContentModel)label.getProjection().getContentModel();
        LabelPresentationModel presentationModel = (LabelPresentationModel)label.getProjection().getPresentationModel();
        int width = presentationModel.getContentPadding().left + presentationModel.getContentPadding().right;
        int height = presentationModel.getContentPadding().top + presentationModel.getContentPadding().bottom;
        int iconHeight = contentModel.getIconFactory() != null ? presentationModel.getIconDimension().height : 0;
        int n = iconWidth = contentModel.getIconFactory() != null ? presentationModel.getIconDimension().width : 0;
        if (iconWidth > 0) {
            width = width + iconWidth + (int)((float)presentationModel.getIconTextGap() * presentationModel.getHorizontalGapScaleFactor());
        }
        Font font = presentationModel.getFont() != null ? presentationModel.getFont() : label.getFont();
        Dimension textDimension = RadianceMetricsUtilities.getLabelPreferredSingleLineDimension((JComponent)label, (String)contentModel.getText(), (Font)font);
        int textWidth = textDimension.width;
        int textHeight = textDimension.height;
        return new Dimension(width += textWidth, height += Math.max(iconHeight, textHeight));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JExoLabel label = (JExoLabel)c;
        LabelContentModel contentModel = (LabelContentModel)label.getProjection().getContentModel();
        LabelPresentationModel presentationModel = (LabelPresentationModel)label.getProjection().getPresentationModel();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)label, (Graphics)g));
        int width = label.getWidth();
        int shiftX = 0;
        int preferredWidth = RadianceExoLabelUI.getSingleLinePreferredDimension((JExoLabel)label).width;
        if (preferredWidth < label.getWidth()) {
            switch (presentationModel.getHorizontalAlignment()) {
                case LEADING: 
                case FILL: {
                    break;
                }
                case CENTER: {
                    shiftX = (width - preferredWidth) / 2;
                    break;
                }
                case TRAILING: {
                    shiftX = width - preferredWidth;
                }
            }
        }
        if (this.icon != null) {
            int iconX = label.getComponentOrientation().isLeftToRight() ? presentationModel.getContentPadding().left : label.getWidth() - presentationModel.getContentPadding().right - this.icon.getIconWidth();
            int iconY = presentationModel.getContentPadding().top;
            g2d.translate(shiftX + iconX, iconY);
            ComponentState state = contentModel.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            float alpha = RadianceColorSchemeUtilities.getAlpha((Component)label, (ComponentState)state);
            Color textColor = RadianceColorSchemeUtilities.getColorScheme((Component)label, (ComponentState)state).getForegroundColor();
            if (alpha < 1.0f) {
                Color backgroundFill = RadianceColorUtilities.getBackgroundFillColor((Component)label);
                textColor = RadianceColorUtilities.getInterpolatedColor((Color)textColor, (Color)backgroundFill, (double)alpha);
            }
            Icon filteredIcon = RadianceCoreUtilities.getFilteredIcon((JComponent)label, (Icon)this.icon, (ComponentState)state, (Color)textColor);
            filteredIcon.paintIcon(label, g2d, 0, 0);
        }
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }
}

