/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.internal.ui.common.popup.BasicColorSelectorPanelUI;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceColorSelectorPanelUI
extends BasicColorSelectorPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceColorSelectorPanelUI();
    }

    private RadianceColorSelectorPanelUI() {
    }

    @Override
    protected void paintCaptionBackground(Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceSkin skin = RadianceCoreUtilities.getSkin((Component)this.colorSelectorPanel);
            RadianceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)this.colorSelectorPanel));
            Color backgroundFill = scheme.getAccentedBackgroundFillColor();
            EnumSet<RadianceThemingSlices.Side> openSides = EnumSet.of(RadianceThemingSlices.Side.LEADING, RadianceThemingSlices.Side.TRAILING);
            graphics1X.setColor(backgroundFill);
            graphics1X.fillRect(0, 0, scaledWidth, scaledHeight);
            HighlightPainterUtils.paintHighlightBorder1X((Graphics2D)graphics1X, (Component)this.colorSelectorPanel, (int)scaledWidth, (int)scaledHeight, (float)1.0f, openSides, (RadianceBorderPainter)RadianceCoreUtilities.getBorderPainter((Component)this.colorSelectorPanel), (RadianceColorScheme)RadianceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorPanel, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED));
        });
        graphics.dispose();
    }

    @Override
    protected void paintBottomDivider(Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            Color borderColor = RadianceCoreUtilities.getSkin((Component)this.colorSelectorPanel).getOverlayColor(RadianceThemingSlices.ColorOverlayType.LINE, DecorationPainterUtils.getDecorationType((Component)this.colorSelectorPanel), ComponentState.ENABLED);
            if (borderColor == null) {
                RadianceColorScheme bgBorderScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorPanel, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)ComponentState.ENABLED);
                borderColor = bgBorderScheme.getLineColor();
            }
            graphics1X.setColor(borderColor);
            int lineY = scaledY + scaledHeight - 1;
            graphics1X.drawLine(scaledX, lineY, scaledX + scaledWidth, lineY);
        });
        graphics.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque((Graphics)g, (JComponent)c);
        this.paint(g, c);
    }

    @Override
    protected int getLayoutGap() {
        return (int)RadianceSizeUtils.getAdjustedSize((int)RadianceSizeUtils.getComponentFontSize((Component)this.colorSelectorPanel), (float)4.0f, (int)1, (float)0.25f);
    }
}

