/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.component.internal.ui.common.popup.BasicColorSelectorComponentUI;
import org.pushingpixels.radiance.component.internal.ui.common.popup.JColorSelectorComponent;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceColorSelectorComponentUI
extends BasicColorSelectorComponentUI
implements TransitionAwareUI {
    private StateTransitionTracker stateTransitionTracker;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new RadianceColorSelectorComponentUI((JColorSelectorComponent)comp);
    }

    private RadianceColorSelectorComponentUI(JColorSelectorComponent colorSelectorComponent) {
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)colorSelectorComponent, this.buttonModel);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        super.uninstallListeners();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    protected void paintBorder(Graphics g) {
        int w = this.colorSelectorComponent.getWidth();
        int h = this.colorSelectorComponent.getHeight();
        Color fillColor = this.colorSelectorComponent.getColor();
        float[] hsb = new float[3];
        Color.RGBtoHSB(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), hsb);
        float brightness = hsb[2] * 0.7f;
        Color borderColor = new Color(brightness, brightness, brightness);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)w, (int)h, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.setColor(borderColor);
            int ty = this.colorSelectorComponent.isTopOpen() ? 1 : 0;
            int by = this.colorSelectorComponent.isBottomOpen() ? 1 : 0;
            graphics1X.drawRect(x, y - ty, scaledWidth - 1, scaledHeight - 1 + ty + by);
        });
        graphics.dispose();
    }

    @Override
    protected void paintRolloverIndication(Graphics g) {
        int w = this.colorSelectorComponent.getWidth();
        int h = this.colorSelectorComponent.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setComposite(AlphaComposite.SrcOver.derive(this.rollover));
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)w, (int)h, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceColorScheme highlightBorderScheme = RadianceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorComponent, (RadianceThemingSlices.ColorSchemeAssociationKind)RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)ComponentState.ROLLOVER_UNSELECTED);
            graphics1X.setColor(highlightBorderScheme.getMidColor());
            graphics1X.drawRect(0, 0, scaledWidth - 1, scaledHeight - 1);
            graphics1X.setColor(highlightBorderScheme.getUltraDarkColor());
            graphics1X.drawRect(1, 1, scaledWidth - 3, scaledHeight - 3);
        });
        graphics.dispose();
    }

    @Override
    protected void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)g2d, (int)0, (int)0, (int)this.colorSelectorComponent.getWidth(), (int)this.colorSelectorComponent.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            float focusRingPadding = (float)scaleFactor * RadianceSizeUtils.getFocusRingPadding((Component)this.colorSelectorComponent, (int)RadianceSizeUtils.getComponentFontSize((Component)this.colorSelectorComponent));
            Rectangle2D.Float insetFocusArea = new Rectangle2D.Float(focusRingPadding, focusRingPadding, (float)scaledWidth - 2.0f * focusRingPadding, (float)scaledHeight - 2.0f * focusRingPadding);
            RadianceCoreUtilities.paintFocus((Graphics)graphics1X, (Component)this.colorSelectorComponent, (Component)this.colorSelectorComponent, (TransitionAwareUI)this, (double)scaleFactor, (Shape)insetFocusArea, null, (float)1.0f, (float)0.0f);
        });
        g2d.dispose();
    }
}

