/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common.tristate;

import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import org.pushingpixels.radiance.component.api.common.JTriStateCheckBox;
import org.pushingpixels.radiance.component.internal.theming.common.tristate.BasicTriStateListener;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;

public class RolloverTriStateListener
extends BasicTriStateListener {
    private boolean isMouseInside = false;
    private StateTransitionTracker stateTransitionTracker;

    public RolloverTriStateListener(JTriStateCheckBox b, StateTransitionTracker stateTransitionTracker) {
        super(b);
        this.stateTransitionTracker = stateTransitionTracker;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean isMouseDrag;
            super.mouseEntered(e);
            this.isMouseInside = true;
            boolean bl = isMouseDrag = e.getButton() == 1;
            if (!isMouseDrag) {
                this.button.getTriStateButtonModel().setRollover(true);
            }
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseExited(e);
            this.isMouseInside = false;
            this.button.getTriStateButtonModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseReleased(e);
            this.button.getTriStateButtonModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseMoved(e);
            this.button.getTriStateButtonModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusGained(FocusEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.focusGained(e);
            if (!this.button.isShowing()) {
                return;
            }
            PointerInfo pi = MouseInfo.getPointerInfo();
            if (pi != null) {
                int px = pi.getLocation().x - this.button.getLocationOnScreen().x;
                int py = pi.getLocation().y - this.button.getLocationOnScreen().y;
                this.button.getTriStateButtonModel().setRollover(this.button.contains(px, py));
            }
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.focusLost(e);
            this.button.getTriStateButtonModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseClicked(e);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mouseDragged(e);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            super.mousePressed(e);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }
}

