/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.internal.theming.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.radiance.common.api.AsynchronousLoading;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.internal.animation.IconGlowTracker;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class GlowingRadianceIcon
implements RadianceIcon {
    private Map<String, BufferedImage> cachedImages;
    private RadianceIcon delegate;
    private IconGlowTracker iconGlowTracker;

    public GlowingRadianceIcon(RadianceIcon delegate, IconGlowTracker iconGlowTracker) {
        this.delegate = delegate;
        this.iconGlowTracker = iconGlowTracker;
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public boolean supportsColorFilter() {
        return this.delegate.supportsColorFilter();
    }

    public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
        this.delegate.setColorFilter(colorFilter);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d;
        float fadePos;
        if (this.delegate == null) {
            return;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)c);
        String key = scale + ":" + (fadePos = this.iconGlowTracker.getIconGlowPosition()) + ":" + this.getIconWidth() + ":" + this.getIconHeight();
        if (!this.cachedImages.containsKey(key)) {
            AsynchronousLoading asyncDelegate;
            if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)this.delegate).isLoading()) {
                return;
            }
            BufferedImage offscreen = RadianceCoreUtilities.getBlankImage((double)scale, (int)this.getIconWidth(), (int)this.getIconHeight());
            g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, (Graphics)g2d, 0, 0);
            g2d.dispose();
            int pixelWidth = offscreen.getWidth();
            int pixelHeight = offscreen.getHeight();
            for (int i = 0; i < pixelWidth; ++i) {
                for (int j = 0; j < pixelHeight; ++j) {
                    int rgba = offscreen.getRGB(i, j);
                    int transp = rgba >>> 24 & 0xFF;
                    double coef = Math.sin(Math.PI * 2 * (double)fadePos / 2.0) / 3.0;
                    Color newColor = coef >= 0.0 ? RadianceColorUtilities.getLighterColor((Color)new Color(rgba), (double)coef) : RadianceColorUtilities.getDarkerColor((Color)new Color(rgba), (double)(-coef));
                    offscreen.setRGB(i, j, transp << 24 | newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue());
                }
            }
            this.cachedImages.put(key, offscreen);
        }
        BufferedImage toDraw = this.cachedImages.get(key);
        g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        RadianceCommonCortex.drawImageWithScale((Graphics)g2d, (double)scale, (Image)toDraw, (int)0, (int)0);
        g2d.dispose();
    }
}

