/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.component.api.ribbon;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.radiance.component.api.common.CommandButtonPresentationState;
import org.pushingpixels.radiance.component.api.common.JCommandButton;
import org.pushingpixels.radiance.component.api.common.model.BaseCommand;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.BaseCommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.Command;
import org.pushingpixels.radiance.component.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.radiance.component.api.common.model.CommandMenuContentModel;
import org.pushingpixels.radiance.component.api.common.model.ContentModel;
import org.pushingpixels.radiance.component.api.common.popup.JPopupPanel;
import org.pushingpixels.radiance.component.api.common.popup.PopupPanelManager;
import org.pushingpixels.radiance.component.api.common.popup.model.BaseCommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.radiance.component.api.common.projection.BaseCommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.CommandButtonProjection;
import org.pushingpixels.radiance.component.api.common.projection.CommandPopupMenuPanelProjection;
import org.pushingpixels.radiance.component.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.radiance.component.api.ribbon.DefaultRibbonTaskbarKeyTipPolicy;
import org.pushingpixels.radiance.component.api.ribbon.JRibbonFrame;
import org.pushingpixels.radiance.component.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.radiance.component.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTask;
import org.pushingpixels.radiance.component.api.ribbon.RibbonTaskbarKeyTipPolicy;
import org.pushingpixels.radiance.component.api.ribbon.model.RibbonApplicationMenuCommand;
import org.pushingpixels.radiance.component.api.ribbon.model.RibbonGalleryContentModel;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonApplicationMenuCommandButtonProjection;
import org.pushingpixels.radiance.component.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.radiance.component.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.radiance.component.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.radiance.component.internal.theming.ribbon.ui.RadianceRibbonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.radiance.component.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.radiance.component.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.radiance.component.internal.ui.ribbon.appmenu.RibbonApplicationMenuProjection;
import org.pushingpixels.radiance.component.internal.utils.ComponentUtilities;

public class JRibbon
extends JComponent {
    private ArrayList<RibbonTask> tasks = new ArrayList();
    private ArrayList<RibbonContextualTaskGroup> contextualTaskGroups = new ArrayList();
    private ArrayList<Component> taskbarComponents = new ArrayList();
    private List<TaskbarContentHandler<?>> taskbarContentHandlers = new ArrayList();
    private ArrayList<AbstractRibbonBand> bands = new ArrayList();
    private RibbonTask currentlySelectedTask = null;
    private ArrayList<CommandButtonProjection> anchoredCommands;
    private Map<RibbonContextualTaskGroup, Boolean> groupVisibilityMap = new HashMap<RibbonContextualTaskGroup, Boolean>();
    private RibbonApplicationMenuCommandButtonProjection applicationMenuCommandProjection;
    private RibbonApplicationMenuProjection applicationMenuProjection;
    private boolean isMinimized;
    private JRibbonFrame ribbonFrame;
    private OnShowContextualMenuListener onShowContextualMenuListener;
    private List<OnTaskSelectionChangeListener> onTaskSelectionChangeListeners;
    private RibbonTaskbarKeyTipPolicy taskbarKeyTipPolicy;
    public static final String uiClassID = "RibbonUI";

    public JRibbon() {
        this.anchoredCommands = new ArrayList();
        this.taskbarKeyTipPolicy = new DefaultRibbonTaskbarKeyTipPolicy();
        this.updateUI();
    }

    JRibbon(JRibbonFrame ribbonFrame) {
        this();
        this.ribbonFrame = ribbonFrame;
    }

    public void setTaskbarKeyTipPolicy(RibbonTaskbarKeyTipPolicy taskbarKeyTipPolicy) {
        if (taskbarKeyTipPolicy == null) {
            throw new IllegalArgumentException("Cannot pass null policy");
        }
        this.taskbarKeyTipPolicy = taskbarKeyTipPolicy;
    }

    public RibbonTaskbarKeyTipPolicy getTaskbarKeyTipPolicy() {
        return this.taskbarKeyTipPolicy;
    }

    private boolean matchesTaskbarContentHandler(ContentModel key) {
        return this.getTaskbarContentHandlerFor(key) != null;
    }

    private TaskbarContentHandler getTaskbarContentHandlerFor(ContentModel key) {
        for (TaskbarContentHandler<?> taskbarContentHandler : this.taskbarContentHandlers) {
            if (taskbarContentHandler.getKey() != key) continue;
            return taskbarContentHandler;
        }
        return null;
    }

    private void removeTaskbarContentHandlerFor(ContentModel key) {
        for (int i = this.taskbarContentHandlers.size() - 1; i >= 0; --i) {
            if (this.taskbarContentHandlers.get(i).getKey() != key) continue;
            this.taskbarContentHandlers.remove(i);
            this.syncTaskbarContent();
            this.fireStateChanged();
            return;
        }
    }

    private void syncTaskbarContent() {
        this.taskbarComponents.clear();
        RibbonTaskbarKeyTipPolicy keyTipPolicy = this.getTaskbarKeyTipPolicy();
        int currentKeyTipIndex = 1;
        for (TaskbarContentHandler<?> taskbarContentHandler : this.taskbarContentHandlers) {
            JComponent taskbarComponent = taskbarContentHandler.buildComponent(keyTipPolicy, currentKeyTipIndex);
            this.taskbarComponents.add(taskbarComponent);
            currentKeyTipIndex += taskbarContentHandler.numberOfKeyTipsNeeded();
        }
    }

    public synchronized <M extends BaseCommand<MCM>, MCM extends BaseCommandMenuContentModel, P extends BaseCommandButtonPresentationModel<MPM, P>, MPM extends BaseCommandPopupMenuPresentationModel> void addTaskbarCommand(BaseCommandButtonProjection<M, MCM, P, MPM> projection) {
        this.taskbarContentHandlers.add(new TaskbarCommandHandler<M, MCM, P, MPM>(projection));
        this.syncTaskbarContent();
        this.fireStateChanged();
    }

    public synchronized boolean isShowingInTaskbar(BaseCommand<?> command) {
        return this.matchesTaskbarContentHandler(command);
    }

    public synchronized void removeTaskbarCommand(BaseCommand<?> command) {
        this.removeTaskbarContentHandlerFor(command);
    }

    public synchronized void addTaskbarAppMenuLink(Command appMenuCommand) {
        if (this.applicationMenuProjection == null) {
            throw new IllegalArgumentException("Can't add app menu link when app menu is not set");
        }
        RibbonApplicationMenu ribbonApplicationMenu = (RibbonApplicationMenu)this.applicationMenuProjection.getContentModel();
        if (ribbonApplicationMenu == null) {
            throw new IllegalArgumentException("Can't add app menu link when app menu is not set");
        }
        if (!ribbonApplicationMenu.getFooterCommands().getCommands().contains(appMenuCommand) && !ComponentUtilities.existsInMenu(appMenuCommand, ribbonApplicationMenu)) {
            throw new IllegalArgumentException("Command not found in app menu");
        }
        this.taskbarContentHandlers.add(new TaskbarAppMenuLinkHandler(appMenuCommand));
        this.syncTaskbarContent();
        this.fireStateChanged();
    }

    public synchronized void removeTaskbarAppMenuLink(Command appMenuCommand) {
        if (this.applicationMenuProjection == null) {
            throw new IllegalArgumentException("Can't remove app menu link when app menu is not set");
        }
        RibbonApplicationMenu ribbonApplicationMenu = (RibbonApplicationMenu)this.applicationMenuProjection.getContentModel();
        if (ribbonApplicationMenu == null) {
            throw new IllegalArgumentException("Can't remove app menu link when app menu is not set");
        }
        if (!ribbonApplicationMenu.getFooterCommands().getCommands().contains(appMenuCommand) && !ComponentUtilities.existsInMenu(appMenuCommand, ribbonApplicationMenu)) {
            throw new IllegalArgumentException("Command not found in app menu");
        }
        this.removeTaskbarContentHandlerFor(appMenuCommand);
    }

    public synchronized void addTaskbarComponent(ComponentProjection<? extends JComponent, ? extends ComponentContentModel> projection) {
        this.taskbarContentHandlers.add(new TaskbarComponentHandler<JComponent, ComponentContentModel>(projection));
        this.syncTaskbarContent();
        this.fireStateChanged();
    }

    public synchronized boolean isShowingInTaskbar(ComponentContentModel componentContentModel) {
        return this.matchesTaskbarContentHandler(componentContentModel);
    }

    public synchronized void removeTaskbarComponent(ComponentContentModel componentContentModel) {
        this.removeTaskbarContentHandlerFor(componentContentModel);
    }

    public synchronized void addTaskbarGalleryDropdown(RibbonGalleryProjection galleryProjection) {
        this.taskbarContentHandlers.add(new TaskbarGalleryDropdownHandler(galleryProjection));
        this.syncTaskbarContent();
        this.fireStateChanged();
    }

    public synchronized boolean isShowingInTaskbar(RibbonGalleryContentModel galleryContentModel) {
        return this.matchesTaskbarContentHandler(galleryContentModel);
    }

    public synchronized void removeTaskbarGallery(RibbonGalleryContentModel galleryContentModel) {
        this.removeTaskbarContentHandlerFor(galleryContentModel);
    }

    public synchronized void clearTaskbar() {
        this.taskbarContentHandlers.clear();
        this.syncTaskbarContent();
    }

    public synchronized void addTask(RibbonTask task) {
        task.setRibbon(this);
        this.tasks.add(task);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(task);
        }
        this.fireStateChanged();
    }

    public synchronized void addAnchoredCommand(CommandButtonProjection projection) {
        this.anchoredCommands.add(projection);
        this.fireStateChanged();
    }

    public synchronized void removeAnchoredCommand(CommandButtonProjection projection) {
        this.anchoredCommands.remove(projection);
        this.fireStateChanged();
    }

    public synchronized List<CommandButtonProjection> getAnchoredCommands() {
        return Collections.unmodifiableList(this.anchoredCommands);
    }

    public synchronized void addContextualTaskGroup(RibbonContextualTaskGroup group) {
        group.setRibbon(this);
        this.contextualTaskGroups.add(group);
        this.groupVisibilityMap.put(group, Boolean.FALSE);
        this.fireStateChanged();
    }

    public synchronized int getTaskCount() {
        return this.tasks.size();
    }

    public synchronized RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    public synchronized int getContextualTaskGroupCount() {
        return this.contextualTaskGroups.size();
    }

    public synchronized RibbonContextualTaskGroup getContextualTaskGroup(int index) {
        return this.contextualTaskGroups.get(index);
    }

    public synchronized void setSelectedTask(RibbonTask task) {
        boolean valid = this.tasks.contains(task);
        if (!valid) {
            for (int i = 0; i < this.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = this.getContextualTaskGroup(i);
                if (!this.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount(); ++j) {
                    if (group.getTask(j) != task) continue;
                    valid = true;
                    break;
                }
                if (valid) break;
            }
        }
        if (!valid) {
            throw new IllegalArgumentException("The specified task to be selected is either not part of this ribbon or not marked as visible");
        }
        for (AbstractRibbonBand ribbonBand : this.bands) {
            ribbonBand.setVisible(false);
        }
        this.bands.clear();
        for (int i = 0; i < task.getBandCount(); ++i) {
            AbstractRibbonBand ribbonBand;
            ribbonBand = task.getBand(i);
            ribbonBand.setVisible(true);
            this.bands.add(ribbonBand);
        }
        RibbonTask old = this.currentlySelectedTask;
        this.currentlySelectedTask = task;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("selectedTask", old, this.currentlySelectedTask);
        this.fireTaskSelectionChanged();
    }

    public synchronized RibbonTask getSelectedTask() {
        return this.currentlySelectedTask;
    }

    @Override
    public void updateUI() {
        this.setUI(RadianceRibbonUI.createUI(this));
        for (Component comp : this.taskbarComponents) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized List<Component> getTaskbarComponents() {
        return Collections.unmodifiableList(this.taskbarComponents);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public synchronized void setVisible(RibbonContextualTaskGroup group, boolean isVisible) {
        this.groupVisibilityMap.put(group, isVisible);
        if (!isVisible) {
            boolean isSelectedBeingHidden = false;
            for (int i = 0; i < group.getTaskCount(); ++i) {
                if (this.getSelectedTask() != group.getTask(i)) continue;
                isSelectedBeingHidden = true;
                break;
            }
            if (isSelectedBeingHidden) {
                this.setSelectedTask(this.getTask(0));
            }
        }
        this.fireStateChanged();
        this.revalidate();
        SwingUtilities.getWindowAncestor(this).repaint();
    }

    public synchronized boolean isVisible(RibbonContextualTaskGroup group) {
        return this.groupVisibilityMap.get(group);
    }

    public synchronized void setApplicationMenuCommand(RibbonApplicationMenuCommandButtonProjection applicationMenuCommandProjection) {
        if (this.applicationMenuCommandProjection == applicationMenuCommandProjection) {
            return;
        }
        RibbonApplicationMenuProjection old = this.applicationMenuProjection;
        this.applicationMenuCommandProjection = applicationMenuCommandProjection;
        if (applicationMenuCommandProjection == null) {
            this.applicationMenuProjection = null;
        } else {
            RibbonApplicationMenuProjection ribbonApplicationMenuProjection;
            RibbonApplicationMenu ribbonApplicationMenu = (RibbonApplicationMenu)((RibbonApplicationMenuCommand)applicationMenuCommandProjection.getContentModel()).getSecondaryContentModel();
            this.applicationMenuProjection = ribbonApplicationMenuProjection = new RibbonApplicationMenuProjection(ribbonApplicationMenu, CommandButtonPresentationModel.withDefaults());
        }
        this.firePropertyChange("applicationMenu", old, this.applicationMenuProjection);
    }

    public RibbonApplicationMenuCommandButtonProjection getApplicationMenuCommandProjection() {
        return this.applicationMenuCommandProjection;
    }

    public synchronized RibbonApplicationMenuProjection getApplicationMenuProjection() {
        return this.applicationMenuProjection;
    }

    public synchronized boolean isMinimized() {
        return this.isMinimized;
    }

    public synchronized void setMinimized(boolean isMinimized) {
        boolean old = this.isMinimized;
        if (old != isMinimized) {
            this.isMinimized = isMinimized;
            this.firePropertyChange("minimized", old, this.isMinimized);
        }
    }

    public JRibbonFrame getRibbonFrame() {
        return this.ribbonFrame;
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.getRibbonFrame() != null) {
            throw new IllegalArgumentException("Can't hide ribbon on JRibbonFrame");
        }
        super.setVisible(flag);
    }

    public void setOnShowContextualMenuListener(OnShowContextualMenuListener onShowContextualMenuListener) {
        this.onShowContextualMenuListener = onShowContextualMenuListener;
    }

    public OnShowContextualMenuListener getOnShowContextualMenuListener() {
        return this.onShowContextualMenuListener;
    }

    public synchronized void addOnTaskSelectionChangedListener(OnTaskSelectionChangeListener listener) {
        if (this.onTaskSelectionChangeListeners == null) {
            this.onTaskSelectionChangeListeners = new ArrayList<OnTaskSelectionChangeListener>();
        }
        this.onTaskSelectionChangeListeners.add(listener);
    }

    public synchronized void removeOnTaskSelectionChangedListener(OnTaskSelectionChangeListener listener) {
        if (this.onTaskSelectionChangeListeners == null) {
            return;
        }
        this.onTaskSelectionChangeListeners.remove(listener);
    }

    private synchronized void fireTaskSelectionChanged() {
        if (this.onTaskSelectionChangeListeners == null) {
            return;
        }
        for (int i = this.onTaskSelectionChangeListeners.size() - 1; i >= 0; --i) {
            this.onTaskSelectionChangeListeners.get(i).onTaskSelectionChanged(this.currentlySelectedTask);
        }
    }

    private class TaskbarComponentHandler<C extends JComponent, CCM extends ComponentContentModel>
    implements TaskbarContentHandler<CCM> {
        private ComponentProjection<C, CCM> projection;

        public TaskbarComponentHandler(ComponentProjection<C, CCM> projection) {
            this.projection = projection;
        }

        @Override
        public CCM getKey() {
            return (CCM)((ComponentContentModel)this.projection.getContentModel());
        }

        @Override
        public int numberOfKeyTipsNeeded() {
            return 1;
        }

        @Override
        public JComponent buildComponent(RibbonTaskbarKeyTipPolicy keyTipPolicy, int currentKeyTipIndex) {
            JRibbonComponent ribbonComponent = new JRibbonComponent(this.projection);
            ribbonComponent.setKeyTip(keyTipPolicy.getContentKeyTip(currentKeyTipIndex));
            ribbonComponent.putClientProperty("radiance.component.internal.ribbon.taskbarProjection", this.projection);
            return ribbonComponent;
        }
    }

    private class TaskbarGalleryDropdownHandler
    implements TaskbarContentHandler<RibbonGalleryContentModel> {
        private RibbonGalleryProjection galleryProjection;

        public TaskbarGalleryDropdownHandler(RibbonGalleryProjection galleryProjection) {
            this.galleryProjection = galleryProjection;
        }

        @Override
        public RibbonGalleryContentModel getKey() {
            return (RibbonGalleryContentModel)this.galleryProjection.getContentModel();
        }

        @Override
        public int numberOfKeyTipsNeeded() {
            return 1;
        }

        @Override
        public JComponent buildComponent(RibbonTaskbarKeyTipPolicy keyTipPolicy, int currentKeyTipIndex) {
            CommandPopupMenuPanelProjection popupMenuPanelProjection = JRibbonGallery.getExpandPopupMenuPanelProjection(this.galleryProjection);
            Command galleryDropdownCommand = ((Command.Builder)((Command.Builder)Command.builder().setIconFactory(((RibbonGalleryContentModel)this.galleryProjection.getContentModel()).getIconFactory())).setSecondaryContentModel((CommandMenuContentModel)popupMenuPanelProjection.getContentModel())).build();
            CommandButtonProjection<Command> galleryDropdownProjection = galleryDropdownCommand.project(((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL)).setPopupMenuPresentationModel((CommandPopupMenuPresentationModel)popupMenuPanelProjection.getPresentationModel())).setPopupKeyTip(keyTipPolicy.getContentKeyTip(currentKeyTipIndex))).build());
            galleryDropdownProjection.setCommandOverlays(popupMenuPanelProjection.getCommandOverlays());
            JCommandButton galleryDropdown = (JCommandButton)galleryDropdownProjection.buildComponent();
            galleryDropdown.putClientProperty("radiance.component.internal.ribbon.taskbarProjection", this.galleryProjection);
            return galleryDropdown;
        }
    }

    private class TaskbarAppMenuLinkHandler
    implements TaskbarContentHandler<Command> {
        private Command appMenuCommand;

        public TaskbarAppMenuLinkHandler(Command appMenuCommand) {
            this.appMenuCommand = appMenuCommand;
        }

        @Override
        public Command getKey() {
            return this.appMenuCommand;
        }

        @Override
        public int numberOfKeyTipsNeeded() {
            return 1;
        }

        @Override
        public JComponent buildComponent(RibbonTaskbarKeyTipPolicy keyTipPolicy, int currentKeyTipIndex) {
            if (JRibbon.this.applicationMenuProjection == null) {
                throw new IllegalArgumentException("Can't add app menu link when app menu is not set");
            }
            RibbonApplicationMenu ribbonApplicationMenu = (RibbonApplicationMenu)JRibbon.this.applicationMenuProjection.getContentModel();
            if (ribbonApplicationMenu == null) {
                throw new IllegalArgumentException("Can't add app menu link when app menu is not set");
            }
            if (!ribbonApplicationMenu.getFooterCommands().getCommands().contains(this.appMenuCommand) && !ComponentUtilities.existsInMenu(this.appMenuCommand, ribbonApplicationMenu)) {
                throw new IllegalArgumentException("Command not found in app menu");
            }
            Command clone = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.appMenuCommand.getText())).setIconFactory(this.appMenuCommand.getIconFactory())).setAction(commandActionEvent -> {
                JRibbon.this.getUI().getApplicationMenuButton().doPopupClick();
                SwingUtilities.invokeLater(() -> {
                    List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                    if (!popups.isEmpty()) {
                        PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                        JPopupPanel popupPanel = last.getPopupPanel();
                        if (!(popupPanel instanceof JRibbonApplicationMenuPopupPanel)) {
                            return;
                        }
                        JRibbonApplicationMenuPopupPanel appMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)popupPanel;
                        appMenuPopupPanel.getPathToSequence(this.appMenuCommand).run();
                    }
                });
            })).setActionRichTooltip(this.appMenuCommand.getActionRichTooltip())).build();
            CommandButtonPresentationModel presentationModel = ((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)((CommandButtonPresentationModel.Builder)CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL)).setHorizontalGapScaleFactor(0.5)).setVerticalGapScaleFactor(0.5)).setActionKeyTip(keyTipPolicy.getContentKeyTip(currentKeyTipIndex))).build();
            CommandButtonProjection<Command> projection = clone.project(presentationModel);
            JCommandButton commandButton = (JCommandButton)projection.buildComponent();
            return commandButton;
        }
    }

    private class TaskbarCommandHandler<M extends BaseCommand<MCM>, MCM extends BaseCommandMenuContentModel, P extends BaseCommandButtonPresentationModel<MPM, P>, MPM extends BaseCommandPopupMenuPresentationModel>
    implements TaskbarContentHandler<M> {
        private BaseCommandButtonProjection<M, MCM, P, MPM> projection;

        public TaskbarCommandHandler(BaseCommandButtonProjection<M, MCM, P, MPM> projection) {
            this.projection = projection;
        }

        @Override
        public M getKey() {
            return (M)((BaseCommand)this.projection.getContentModel());
        }

        @Override
        public int numberOfKeyTipsNeeded() {
            ContentModel command = this.getKey();
            boolean needsActionTip = ((BaseCommand)command).getAction() != null && ((BaseCommand)command).isActionEnabled();
            boolean needsPopupTip = ((BaseCommand)command).hasSecondaryContent() && ((BaseCommand)command).isSecondaryEnabled();
            return (needsActionTip ? 1 : 0) + (needsPopupTip ? 1 : 0);
        }

        @Override
        public JComponent buildComponent(RibbonTaskbarKeyTipPolicy keyTipPolicy, int currentKeyTipIndex) {
            ContentModel command = this.getKey();
            boolean needsActionTip = ((BaseCommand)command).getAction() != null && ((BaseCommand)command).isActionEnabled();
            boolean needsPopupTip = ((BaseCommand)command).hasSecondaryContent() && ((BaseCommand)command).isSecondaryEnabled();
            BaseCommandButtonPresentationModel originalPresentationModel = (BaseCommandButtonPresentationModel)this.projection.getPresentationModel();
            Object presentationModel = originalPresentationModel.overlayWith(new BaseCommandButtonPresentationModel.Overlay().setPresentationState(CommandButtonPresentationState.SMALL).setIconFilterStrategies(((BaseCommandButtonPresentationModel)this.projection.getPresentationModel()).getActiveIconFilterStrategy(), ((BaseCommandButtonPresentationModel)this.projection.getPresentationModel()).getEnabledIconFilterStrategy(), ((BaseCommandButtonPresentationModel)this.projection.getPresentationModel()).getDisabledIconFilterStrategy()).setHorizontalGapScaleFactor(0.5).setVerticalGapScaleFactor(0.5).setActionKeyTip(needsActionTip ? keyTipPolicy.getContentKeyTip(currentKeyTipIndex++) : null).setPopupKeyTip(needsPopupTip ? keyTipPolicy.getContentKeyTip(currentKeyTipIndex) : null));
            JCommandButton commandButton = (JCommandButton)this.projection.reproject(presentationModel).buildComponent();
            commandButton.putClientProperty("radiance.component.internal.ribbon.taskbarProjection", this.projection);
            return commandButton;
        }
    }

    private static interface TaskbarContentHandler<T extends ContentModel> {
        public T getKey();

        public int numberOfKeyTipsNeeded();

        public JComponent buildComponent(RibbonTaskbarKeyTipPolicy var1, int var2);
    }

    @FunctionalInterface
    public static interface OnTaskSelectionChangeListener {
        public void onTaskSelectionChanged(RibbonTask var1);
    }

    public static interface OnShowContextualMenuListener {
        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, RibbonGalleryProjection var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, ComponentProjection<? extends JComponent, ? extends ComponentContentModel> var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, BaseCommandButtonProjection<? extends BaseCommand<?>, ? extends BaseCommandMenuContentModel, ? extends BaseCommandButtonPresentationModel<?, ?>, ? extends BaseCommandPopupMenuPresentationModel> var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1, Command var2);

        public CommandMenuContentModel getContextualMenuContentModel(JRibbon var1);
    }
}

